/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/**
 * org.apache.xerces.parsers.SAXParser̃ZLAȃTuNX邽߂̊NXB
 * <p>
 * TuNXCastorŗp邱ƂOƂĂB<br>
 * TuNX̓CX^XɃZLA[hƂȂA
 * setEntityResolversɁAEntityResolver𔻒fޗƂāAʏ탂[hɖ߂ƂłB<br>
 * TuNXł́A<br>
 * EZLA[hւ̈ڍs<br>
 * Eʏ탂[hւ̈ڍs<br>
 * Eʏ탂[hɖ߂ۂ̔f<br>
 * ̎KvB
 * </p>
 */
public abstract class AbstractSecureSAXParser extends SAXParser {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(AbstractSecureSAXParser.class);

    /**
     * RXgN^B
     * <p>
     * ZLA[hɈڍsB
     * </p>
     * @throws SAXException@p[TΉĂȂݒsꍇ(gpXercesɍ킹ăTuNXĂA̗O͔ȂB)
     */
    public AbstractSecureSAXParser() throws SAXException {
        super();
        backupNormalSetting();
        toSecureMode();
    }

    /**
     * EntityResolverݒ肷B
     * <p>
     * EntityResolverݒ肷ہAEntityResolvermFAZLA[hłKv΁Aʏ탂[hɖ߂B
     * </p>
     * @see org.apache.xerces.parsers.AbstractSAXParser#setEntityResolver(org.xml.sax.EntityResolver)
     */
    @Override
    public void setEntityResolver(EntityResolver resolver) {
        if (needNotSecureMode(resolver)) {
            try {
                toNormalMode();
            } catch (SAXException e) {

                // gpXercesɍ킹ăTuNXĂA̗O͔ȂB
                log.error("", e);
            }
        }
        super.setEntityResolver(resolver);
    }

    /**
     * lsȐݒobNAbv邽߂̊g|CgB
     * @throws SAXException@p[TΉĂȂݒsꍇ(gpXercesɍ킹ăTuNXĂA̗O͔ȂB)
     */
    protected void backupNormalSetting() throws SAXException {
    }

    /**
     * ZLA[hłKvꍇtrueԋpB
     * @param resolver@EntityResolver
     * @return ZLA[hłKvꍇtrueBȊOfalseB
     */
    protected abstract boolean needNotSecureMode(EntityResolver resolver);

    /**
     * ZLA[hɈڍsB
     * @throws SAXException@p[TΉĂȂݒsꍇ(gpXercesɍ킹ăTuNXĂA̗O͔ȂB)
     */
    protected abstract void toSecureMode() throws SAXException;

    /**
     * ʏ탂[hɈڍsB
     * @throws SAXException@p[TΉĂȂݒsꍇ(gpXercesɍ킹ăTuNXĂA̗O͔ȂB)
     */
    protected abstract void toNormalMode() throws SAXException;
}
