/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.xerces;

import jp.terasoluna.fw.oxm.xsd.exception.ErrorReporterNotFoundException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

/**
 * ͒XML̗vfXMLErrorReporterEx̃X^bNɊi[邽߂ɁAXMLSchemaValidator̊gsNXB
 * 
 * <p>
 * vf̊JnɁAvfɃCfbNXtAXMLErrorReporterEx̃X^bNɃvbVB<br>
 * vf̏IɁAX^bN|bvB<br>
 * vf̏񂪓X^bN𗘗p邱ƂŁAG[ӏ肷邱ƂłB
 * </p>
 * <p>
 * XML̗vf񂪂ǂ̂悤ɃX^bNɊi[邩ȉɋLB
 * </p>
 * <p>
 * yXMLf[^̃Tvz<br>
 * <code><pre>
 * &lt;sample-dto&gt;
 *   &lt;param-a&gt;
 *     &lt;param-b&gt;
 *       &lt;param-c&gt;...&lt;/param-c&gt;
 *       &lt;param-d&gt;...&lt;/param-d&gt;
 *     &lt;/param-b&gt;
 *   &lt;/param-a&gt;
 *   &lt;param-e&gt;
 *     &lt;param-f&gt;...&lt;/param-f&gt;
 *   &lt;/param-e&gt;
 *   &lt;param-e&gt;
 *     &lt;param-f&gt;...&lt;/param-f&gt;
 *   &lt;/param-e&gt;
 * &lt;/sample-dto&gt;
 * </pre></code>
 * </p>
 * <p>
 * yLXMLf[^͂ꂽꍇ́AX^bN̏Ԃ̕ωz
 * <code><pre>
 * <ol>
 * <li>ij</li>
 * <li>{sample-dto[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}{param-b[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}{param-b[0]}{param-c[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}{param-b[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}{param-b[0]}{param-d[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}{param-b[0]}</li>
 * <li>{sample-dto[0]}{param-a[0]}</li>
 * <li>{sample-dto[0]}</li>
 * <li>{sample-dto[0]}{param-e[0]}</li>
 * <li>{sample-dto[0]}{param-e[0]}{param-f[0]}</li>
 * <li>{sample-dto[0]}{param-e[0]}</li>
 * <li>{sample-dto[0]}</li>
 * <li>{sample-dto[0]}{param-e[1]}</li>
 * <li>{sample-dto[0]}{param-e[1]}{param-f[0]}</li>
 * <li>{sample-dto[0]}{param-e[1]}</li>
 * <li>{sample-dto[0]}</li>
 * <li>ij</li>
 * </ol>
 * </pre></code>
 * </p>
 * 
 * <p>
 * Ⴆ΁ALTvparam-cvfɕsȒlĂꍇAG[̃X^bN̏Ԃ͈ȉ̒ʂłB<br>
 * X^bN̏ԁF<code><b>{sample-dto[0]}{param-a[0]}{param-b[0]}{param-c[0]}</b></code>
 * </p>
 * 
 * <p>
 * XMLErrorReporterEx͈ȉ̂悤ɃX^bN̒lhbgi"."jŘAāAG[̃tB[h𐶐B<br>
 * tB[hF<code><b>sample-dto[0].param-a[0].param-b[0].param-c[0]</b></code>
 * </p>
 * 
 * <p>
 * ͒XML͓̑̏肷邱ƂłȂB<br>
 * G[̓G[̒u񂩂擾邱ƂłB<br>
 * ڍׂ́A{@link jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx}QƂ邱ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx
 * 
 */
public class XMLSchemaValidatorEx extends XMLSchemaValidator {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(XMLSchemaValidatorEx.class);
    
    /**
     * XMLErrorReporterExCX^X
     */
    private XMLErrorReporterEx reporter = null;

    /**
     * RXgN^
     * 
     * @param reporter XMLErrorReporterExCX^X
     */
    public XMLSchemaValidatorEx(XMLErrorReporterEx reporter) {
        this.reporter = reporter;
    }

    /**
     * vf̊JnɁA͒̃tB[hXMLErrorReporterEx̃X^bNɃvbVB
     * 
     * @param element XMLvf̏CX^X
     * @param attributes XML̏CX^X
     * @param augs Ó؂̌ʂi[CX^X
     * @throws XNIException p[TŔsO
     */
    @Override
    public void startElement(QName element, XMLAttributes attributes,
            Augmentations augs) throws XNIException {

        if (reporter == null) {
            log.error("ErrorReporterEx is not found.");
            throw new ErrorReporterNotFoundException();
        }
        // vfɃCfbNXtԋp
        String pushStr = reporter.indexResolve(element.rawname);
        // XMLErrorReporterEx̃X^bNɉ͒̃tB[hvbV
        reporter.getTagStack().push(pushStr);
        super.startElement(element, attributes, augs);
    }
    
    /**
     * vf̏IɁAXMLErrorReporterEx̃X^bN|bvB
     * 
     * @param element XMLvf̏CX^X
     * @param augs Ó؂̌ʂi[CX^X
     * @throws XNIException p[TŔsO
     */
    @Override
    public void endElement(QName element, Augmentations augs)
            throws XNIException {

        super.endElement(element, augs);
        if (reporter == null) {
            log.error("ErrorReporterEx is not found.");
            throw new ErrorReporterNotFoundException();
        }
        // vf̏IŁAXMLErrorReporterEx̃X^bN|bv
        reporter.getTagStack().pop();
    }

}
