/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.mapper.castor;

import java.util.HashSet;
import java.util.Set;

import org.exolab.castor.xml.XMLClassDescriptorResolver;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.oxm.mapper.castor.XMLClassDescriptorResolverAndMappedClassSet}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * XMLClassDescriptorResolverƃ}bsO`fς݃NXW̃yAB
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.mapper.castor.XMLClassDescriptorResolverAndMappedClassSet
 */
public class XMLClassDescriptorResolverAndMappedClassSetTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(XMLClassDescriptorResolverAndMappedClassSetTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public XMLClassDescriptorResolverAndMappedClassSetTest(String name) {
        super(name);
    }

    /**
     * testGetResolver01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() resolver:XMLClassDescriptorResolverImplExCX^X(RXgN^ŝ܂)<br>
     * 
     * <br>
     * ҒlF(߂l) resolverɂXMLClassDescriptorResolverImplExCX^X<br>
     * 
     * <br>
     * XMLClassDescriptorResolverImplEx擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetResolver01() throws Exception {
        // O
        XMLClassDescriptorResolverAndMappedClassSet obj = new XMLClassDescriptorResolverAndMappedClassSet();
        XMLClassDescriptorResolverImplEx expected = (XMLClassDescriptorResolverImplEx) UTUtil
                .getPrivateField(obj, "resolver");

        // eXg{
        XMLClassDescriptorResolver resolver = obj.getResolver();

        // 
        assertSame(expected, resolver);
    }

    /**
     * testGetMappedClassSet01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() mappedClassSet:HashSetCX^X(RXgN^ŝ܂)<br>
     * 
     * <br>
     * ҒlF(߂l) mappedClassSetɂHashSetCX^X<br>
     * 
     * <br>
     * HashSet擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetMappedClassSet01() throws Exception {
        // O
        XMLClassDescriptorResolverAndMappedClassSet obj = new XMLClassDescriptorResolverAndMappedClassSet();
        HashSet expected = (HashSet) UTUtil.getPrivateField(obj,
                "mappedClassSet");

        // eXg{
        Set<Class> mappedClassSet = obj.getMappedClassSet();

        // 
        assertSame(expected, mappedClassSet);
    }

}
