/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.AdminItem;
import org.mafait.thinknowlogy.BoolResultType;
import org.mafait.thinknowlogy.Console;
import org.mafait.thinknowlogy.ContextResultType;
import org.mafait.thinknowlogy.DuplicateResultType;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.GrammarItem;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.ReadItem;
import org.mafait.thinknowlogy.ShortResultType;
import org.mafait.thinknowlogy.SpecificationItem;
import org.mafait.thinknowlogy.WordEndingResultType;
import org.mafait.thinknowlogy.WordItem;
import org.mafait.thinknowlogy.WordResultType;
import org.mafait.thinknowlogy.WordTypeItem;

class AdminReadSentence {
    private boolean hasAnyChangeBeenMadeByThisSentence_ = false;
    private boolean hasFemaleUserSpecificationWord_ = false;
    private boolean isAssignment_ = false;
    private boolean isInactiveAssignment_ = false;
    private boolean isArchivedAssignment_ = false;
    private boolean isCharacteristicFor_ = false;
    private boolean isChineseCurrentLanguage_ = false;
    private boolean isConditional_ = false;
    private boolean isEveryGeneralization_ = false;
    private boolean isExclusiveSpecification_ = false;
    private boolean isNegative_ = false;
    private boolean isPartOf_ = false;
    private boolean isPossessive_ = false;
    private boolean isSpecific_ = false;
    private boolean isSpecificationGeneralization_ = false;
    private boolean isUncountableGeneralizationNoun_ = false;
    private boolean isUniqueUserRelation_ = false;
    private boolean isUserImperativeSentence_ = false;
    private boolean wasPreviousCommandUndoOrRedo_ = false;
    private short currentParseWordOrderNr_ = 0;
    private short prepositionParameter_ = 0;
    private short previousGeneralizationWordTypeNr_ = 0;
    private short questionParameter_ = 0;
    private short selectionListNr_ = Short.MAX_VALUE;
    private short userAssumptionLevel_ = 0;
    private int generalizationContextNr_ = 0;
    private int specificationContextNr_ = 0;
    private ReadItem currentReadItem_ = null;
    private ReadItem linkedGeneralizationReadItem_ = null;
    private ReadItem startGeneralizationReadItem_ = null;
    private ReadItem endGeneralizationReadItem_ = null;
    private ReadItem startSpecificationReadItem_ = null;
    private ReadItem endSpecificationReadItem_ = null;
    private ReadItem startRelationReadItem_ = null;
    private ReadItem endRelationReadItem_ = null;
    private WordItem previousGeneralizationWordItem_ = null;
    private String moduleNameString_ = this.getClass().getName();
    private AdminItem adminItem_ = null;

    private void checkForChangesMadeByThisSentence() {
        int currentSentenceNr = GlobalVariables.currentSentenceNr;
        int highestFoundSentenceNr = this.adminItem_.highestFoundSentenceNr(false, false, currentSentenceNr);
        this.hasAnyChangeBeenMadeByThisSentence_ = highestFoundSentenceNr >= currentSentenceNr;
    }

    private static void clearReplacingInfoInSpecificationWords() {
        WordItem currentSpecificationWordItem = GlobalVariables.firstSpecificationWordItem;
        if (currentSpecificationWordItem != null) {
            do {
                currentSpecificationWordItem.clearReplacingInfoInWord();
            } while ((currentSpecificationWordItem = currentSpecificationWordItem.nextSpecificationWordItem) != null);
        }
    }

    private void setVariables(short wordParameter) {
        switch (wordParameter) {
            case 633: 
            case 705: 
            case 706: 
            case 707: {
                this.isNegative_ = true;
                break;
            }
            case 623: {
                this.isCharacteristicFor_ = true;
                break;
            }
            case 637: {
                this.isSpecific_ = true;
                break;
            }
            case 700: {
                this.userAssumptionLevel_ = (short)3;
                break;
            }
            case 701: {
                this.userAssumptionLevel_ = (short)2;
                break;
            }
            case 702: {
                this.userAssumptionLevel_ = 1;
                break;
            }
            case 703: {
                this.isUniqueUserRelation_ = true;
                break;
            }
            case 2201: 
            case 2301: {
                this.isAssignment_ = true;
                this.isArchivedAssignment_ = true;
                break;
            }
            case 2202: 
            case 2302: {
                this.isConditional_ = true;
                break;
            }
            case 2105: {
                if (this.isAssignment_ || this.startSpecificationReadItem_ != null) break;
                this.isPossessive_ = true;
                break;
            }
            case 2203: 
            case 2303: {
                this.isPossessive_ = true;
                break;
            }
            case 2204: 
            case 2304: {
                this.isAssignment_ = true;
                this.isArchivedAssignment_ = true;
                this.isPossessive_ = true;
            }
        }
    }

    private byte assignLanguage(short newLanguageNr) {
        WordItem predefinedNounLanguageWordItem = GlobalVariables.predefinedNounLanguageWordItem;
        if (predefinedNounLanguageWordItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The predefined noun language word item is undefined");
        }
        WordItem languageWordItem = predefinedNounLanguageWordItem.languageWordItem(newLanguageNr);
        if (languageWordItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find the requested language");
        }
        GlobalVariables.currentLanguageNr = newLanguageNr;
        GlobalVariables.currentLanguageWordItem = languageWordItem;
        if (this.adminItem_.assignSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)languageWordItem, (WordItem)GlobalVariables.predefinedNounLanguageWordItem, null).result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the language with authorization");
        }
        return 1;
    }

    private byte addMultipleWord(short adjectiveParameter, short definiteArticleParameter, short indefiniteArticleParameter, ReadItem firstReadItem, ReadItem secondReadItem) {
        WordItem currentWordItem;
        short currentWordTypeNr;
        WordTypeItem firstWordTypeItem;
        boolean hasCurrentWordWithSameWordType = true;
        boolean hasFoundFrenchPreposition = false;
        boolean hasFoundWordWithDifferentWordType = false;
        boolean isFirstWordTypeNumeral = false;
        short nWordParts = 1;
        ReadItem currentReadItem = secondReadItem;
        ReadItem lastReadItem = null;
        WordResultType wordResult = new WordResultType();
        if (firstReadItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given first read item is undefined");
        }
        if (secondReadItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given second read item is undefined");
        }
        WordItem firstWordItem = firstReadItem.readWordItem();
        if (firstWordItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given first read item has no read word");
        }
        short firstWordTypeNr = firstReadItem.wordTypeNr();
        if (firstWordTypeNr == 2) {
            isFirstWordTypeNumeral = true;
        }
        if ((firstWordTypeItem = firstWordItem.activeWordTypeItem(firstWordTypeNr)) == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find the word type item of the given first read item");
        }
        if (adjectiveParameter == 0) {
            adjectiveParameter = firstWordTypeItem.adjectiveParameter();
        }
        if (definiteArticleParameter == 0) {
            definiteArticleParameter = firstWordTypeItem.definiteArticleParameter();
        }
        if (indefiniteArticleParameter == 0) {
            indefiniteArticleParameter = firstWordTypeItem.indefiniteArticleParameter();
        }
        StringBuffer multipleWordStringBuffer = new StringBuffer(firstWordTypeItem.itemString());
        StringBuffer existingMultipleWordStringBuffer = new StringBuffer(multipleWordStringBuffer);
        do {
            boolean isFrenchPreposition;
            if (isFrenchPreposition = currentReadItem.isFrenchPreposition()) {
                hasFoundFrenchPreposition = true;
            }
            currentWordTypeNr = currentReadItem.wordTypeNr();
            if (isFirstWordTypeNumeral || isFrenchPreposition || firstWordTypeNr == currentWordTypeNr || this.adminItem_.isNounWordType(firstWordTypeNr) && this.adminItem_.isNounWordType(currentWordTypeNr)) {
                WordTypeItem differentWordTypeItem;
                currentWordItem = currentReadItem.readWordItem();
                if (currentWordItem == null) {
                    return this.adminItem_.startError(1, this.moduleNameString_, "I found a read item without read word");
                }
                WordTypeItem currentWordTypeItem = currentWordItem.activeWordTypeItem(currentWordTypeNr);
                if (currentWordTypeItem == null) {
                    return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find the word type item of the current read word");
                }
                nWordParts = (short)(nWordParts + 1);
                lastReadItem = currentReadItem;
                if (!this.isChineseCurrentLanguage_ || currentWordTypeNr == 5) {
                    multipleWordStringBuffer.append(" ");
                    existingMultipleWordStringBuffer.append(" ");
                }
                multipleWordStringBuffer.append(currentWordTypeItem.itemString());
                if (firstWordTypeNr != currentWordTypeNr && (differentWordTypeItem = currentWordItem.activeWordTypeItem(firstWordTypeNr)) != null) {
                    hasFoundWordWithDifferentWordType = true;
                    existingMultipleWordStringBuffer.append(differentWordTypeItem.itemString());
                    continue;
                }
                existingMultipleWordStringBuffer.append(currentWordTypeItem.itemString());
                continue;
            }
            hasCurrentWordWithSameWordType = false;
        } while (hasCurrentWordWithSameWordType && (currentReadItem = currentReadItem.nextReadItem()) != null && !currentReadItem.isSymbol());
        currentReadItem = secondReadItem;
        do {
            currentWordTypeNr = hasFoundFrenchPreposition ? firstWordTypeNr : currentReadItem.wordTypeNr();
            currentWordItem = currentReadItem.readWordItem();
            if (currentWordItem == null) {
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a read item without read word");
            }
            WordItem createdMultipleWordItem = null;
            WordItem createdWordItem = null;
            WordItem multipleWordItem = null;
            if (hasFoundWordWithDifferentWordType) {
                wordResult = this.adminItem_.findWordTypeInAllWords(false, firstWordTypeNr, existingMultipleWordStringBuffer.toString(), null);
                if (wordResult.result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find an exact word type in all words");
                }
                createdWordItem = wordResult.foundWordItem;
                if (createdWordItem != null) {
                    if (createdWordItem.addWordType((boolean)false, (boolean)firstWordTypeItem.isProperNounPrecededByDefiniteArticle((short)firstWordTypeItem.definiteArticleParameter()), (short)adjectiveParameter, (short)definiteArticleParameter, (short)indefiniteArticleParameter, (short)currentWordTypeNr, (int)multipleWordStringBuffer.length(), (String)multipleWordStringBuffer.toString()).result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the word type to multiple word \"" + createdWordItem.anyWordTypeString() + "\"");
                    }
                    createdMultipleWordItem = createdWordItem;
                    multipleWordItem = createdWordItem;
                }
            }
            if (createdWordItem == null) {
                wordResult = this.adminItem_.addWord(false, true, adjectiveParameter, definiteArticleParameter, indefiniteArticleParameter, firstReadItem.wordParameter(), isFirstWordTypeNumeral ? firstWordTypeNr : currentWordTypeNr, multipleWordStringBuffer.length(), multipleWordStringBuffer.toString());
                if (wordResult.result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the multiple word");
                }
                createdMultipleWordItem = wordResult.createdWordItem;
                multipleWordItem = createdMultipleWordItem == null ? wordResult.foundWordItem : createdMultipleWordItem;
                WordTypeItem foundWordTypeItem = wordResult.foundWordTypeItem;
                if (foundWordTypeItem != null) {
                    if (adjectiveParameter > 0 && !foundWordTypeItem.hasAdjectiveParameter() && foundWordTypeItem.setAdjectiveParameter(adjectiveParameter) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set the adjective parameter of a singular noun");
                    }
                    if (definiteArticleParameter > 0 && !foundWordTypeItem.hasDefiniteArticleParameter() && foundWordTypeItem.setDefiniteArticleParameter(definiteArticleParameter) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set the definite article parameter of a singular noun");
                    }
                    if (indefiniteArticleParameter > 0 && !foundWordTypeItem.hasIndefiniteArticleParameter() && foundWordTypeItem.setIndefiniteArticleParameter(indefiniteArticleParameter) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set the indefinite article parameter of a singular noun");
                    }
                }
            }
            if (createdMultipleWordItem != null) {
                if (firstWordItem.addMultipleWord(nWordParts, firstWordTypeNr, createdMultipleWordItem) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the first multiple word");
                }
                currentWordItem = currentReadItem.readWordItem();
                if (currentWordItem == null) {
                    return this.adminItem_.startError(1, this.moduleNameString_, "The current word item is undefined");
                }
                if (currentWordItem.addMultipleWord(nWordParts, firstWordTypeNr, createdMultipleWordItem) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the second multiple word");
                }
            }
            if (multipleWordItem == null) {
                return this.adminItem_.startError(1, this.moduleNameString_, "The multiple word is undefined");
            }
            if (firstReadItem.changeReadWord(isFirstWordTypeNumeral ? firstWordTypeNr : currentWordTypeNr, multipleWordItem) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete an active read item");
            }
            ReadItem deletedReadItem = currentReadItem;
            ReadItem readItem = currentReadItem = deletedReadItem == lastReadItem ? null : currentReadItem.nextReadItem();
            if (this.adminItem_.deleteReadItem(deletedReadItem) == 1) continue;
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete the second read item");
        } while (currentReadItem != null);
        return 1;
    }

    private byte addReadSpecification(boolean isAction, boolean isNewStart, short selectionLevel, String readUserSentenceString) {
        boolean isSelection = this.selectionListNr_ != Short.MAX_VALUE;
        short imperativeVerbParameter = 0;
        ReadItem currentGeneralizationReadItem = this.startGeneralizationReadItem_;
        if (currentGeneralizationReadItem == null) {
            return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "The start generalization read item is undefined");
        }
        if (this.endGeneralizationReadItem_ == null) {
            return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "The end generalization read item is undefined");
        }
        if (!isSelection && GlobalVariables.nUserGeneralizationWords == 1 && GlobalVariables.nUserSpecificationWords > 1 && GlobalVariables.nUserRelationWords > 1) {
            if (InputOutput.writeInterfaceText(false, (short)5, (short)1630) != 1) {
                return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to write an interface warning about ambiguity");
            }
        } else {
            if (this.wasPreviousCommandUndoOrRedo_) {
                this.wasPreviousCommandUndoOrRedo_ = false;
                AdminReadSentence.clearReplacingInfoInSpecificationWords();
            }
            boolean isConditional = isSelection || this.isConditional_;
            this.adminItem_.initializeAdminVariables();
            block4: do {
                switch (currentGeneralizationReadItem.grammarParameter) {
                    case 4040: {
                        short tempVerbParameter;
                        imperativeVerbParameter = this.isChineseCurrentLanguage_ && (tempVerbParameter = currentGeneralizationReadItem.readAheadChineseImperativeVerbParameter()) > 0 ? tempVerbParameter : currentGeneralizationReadItem.wordParameter();
                    }
                    case 5011: {
                        SpecificationItem userSpecificationItem;
                        if (this.adminItem_.addUserSpecification(isAction, this.isAssignment_, this.isCharacteristicFor_, isConditional, this.isInactiveAssignment_, this.isArchivedAssignment_, this.isEveryGeneralization_, this.isExclusiveSpecification_, this.isNegative_, isNewStart, this.isPartOf_, this.isPossessive_, this.isSpecific_, this.isSpecificationGeneralization_, this.isUncountableGeneralizationNoun_, this.isUniqueUserRelation_, imperativeVerbParameter, this.prepositionParameter_, this.questionParameter_, selectionLevel, this.selectionListNr_, this.userAssumptionLevel_, this.generalizationContextNr_, this.specificationContextNr_, currentGeneralizationReadItem, this.startSpecificationReadItem_, this.endSpecificationReadItem_, this.startRelationReadItem_, this.endRelationReadItem_) != 1) {
                            return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to add the read user specifications");
                        }
                        if (isSelection || (userSpecificationItem = this.adminItem_.userSpecificationItem()) == null || this.adminItem_.prepareIntegrityCheckOfStoredUserSentence(this.isChineseCurrentLanguage_, userSpecificationItem, readUserSentenceString) == 1) continue block4;
                        return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to prepare the integrity check of the stored user sentence");
                    }
                }
            } while (!GlobalVariables.hasDisplayedWarning && currentGeneralizationReadItem != this.endGeneralizationReadItem_ && (currentGeneralizationReadItem = currentGeneralizationReadItem.nextReadItem()) != null);
        }
        return 1;
    }

    private byte checkAllWordsForStructuralIntegrity() {
        WordItem currentSpecificationWordItem;
        if (this.adminItem_.checkForUnprocessedNegativeConclusion() == 1 && (currentSpecificationWordItem = GlobalVariables.firstSpecificationWordItem) != null) {
            do {
                if (currentSpecificationWordItem.checkStructuralIntegrityInWord() == 1) continue;
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check the structural integrity in word \"" + currentSpecificationWordItem.anyWordTypeString() + "\"");
            } while (!GlobalVariables.hasDisplayedIntegrityWarning && (currentSpecificationWordItem = currentSpecificationWordItem.nextSpecificationWordItem) != null);
        }
        return 1;
    }

    private byte checkForDuplicateSelection() {
        boolean hasFoundDuplicateSelection = false;
        DuplicateResultType duplicateResult = this.adminItem_.checkForDuplicateCondition();
        if (duplicateResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check if the condition selection part is duplicate");
        }
        int duplicateConditionSentenceNr = duplicateResult.duplicateConditionSentenceNr;
        if (duplicateConditionSentenceNr > 0) {
            duplicateResult = this.adminItem_.checkForDuplicateSelectionPart(true, duplicateConditionSentenceNr);
            if (duplicateResult.result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check if the action selection part is duplicate");
            }
            if (duplicateResult.hasFoundDuplicateSelection) {
                if (GlobalVariables.adminAlternativeList == null) {
                    hasFoundDuplicateSelection = true;
                } else {
                    duplicateResult = this.adminItem_.checkForDuplicateSelectionPart(false, duplicateConditionSentenceNr);
                    if (duplicateResult.result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check if the alternative selection part is duplicate");
                    }
                    if (duplicateResult.hasFoundDuplicateSelection) {
                        hasFoundDuplicateSelection = true;
                    }
                }
            }
            if (hasFoundDuplicateSelection) {
                this.adminItem_.deleteSentences(GlobalVariables.currentSentenceNr);
            }
        }
        return 1;
    }

    private byte deleteAllWordTypesOfCurrentSentence() {
        if (this.deleteAllWordTypesOfCurrentSentence(true) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete all word types of the active read list");
        }
        if (this.deleteAllWordTypesOfCurrentSentence(false) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete all word types of the inactive read list");
        }
        return 1;
    }

    private byte deleteAllWordTypesOfCurrentSentence(boolean isActiveItems) {
        ReadItem currentReadItem = isActiveItems ? this.adminItem_.firstActiveReadItem() : this.adminItem_.firstInactiveReadItem();
        while (currentReadItem != null) {
            WordItem currentWordItem = currentReadItem.readWordItem();
            if (currentWordItem != null && !currentWordItem.isDeletedItem()) {
                if (currentWordItem.deleteAllWordTypesOfCurrentSentence() != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete all word types of the current sentence in word \"" + currentWordItem.anyWordTypeString() + "\"");
                }
                if (!currentWordItem.hasAnyWordType() && this.adminItem_.deleteWordItem(currentWordItem) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete word \"" + currentWordItem.anyWordTypeString() + "\"");
                }
            }
            currentReadItem = currentReadItem.nextReadItem();
        }
        return 1;
    }

    private byte deleteUnusedWordsAndWordTypes() {
        if (this.deleteUnusedWordsAndWordTypes(true) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete unused word types in the active read list");
        }
        if (this.deleteUnusedWordsAndWordTypes(false) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete unused word types in the inactive read list");
        }
        return 1;
    }

    private byte deleteUnusedWordsAndWordTypes(boolean isActiveItems) {
        short previousWordOrderNr = 0;
        ReadItem currentReadItem = isActiveItems ? this.adminItem_.firstActiveReadItem() : this.adminItem_.firstInactiveReadItem();
        while (currentReadItem != null) {
            boolean isSameWordOrderNr = currentReadItem.wordOrderNr() == previousWordOrderNr;
            previousWordOrderNr = currentReadItem.wordOrderNr();
            WordItem currentReadWordItem = currentReadItem.readWordItem();
            if (currentReadWordItem != null) {
                if (!isActiveItems || isSameWordOrderNr && !currentReadItem.isSingularNoun()) {
                    WordTypeItem currentWordTypeItem = currentReadItem.activeReadWordTypeItem();
                    if (currentWordTypeItem == null) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find the word type of an active read word");
                    }
                    if (currentWordTypeItem.hasCurrentCreationSentenceNr()) {
                        ShortResultType shortResult = this.adminItem_.getNumberOfReadWordReferences(currentReadItem.wordTypeNr(), currentReadWordItem);
                        if (shortResult.result != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to get the number of read word references");
                        }
                        short nReadWordReferences = shortResult.shortValue;
                        if (nReadWordReferences < 1) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "I found an invalid number of read word references");
                        }
                        if (nReadWordReferences == 1) {
                            if (currentReadWordItem.deleteWordType(currentWordTypeItem) != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete an unused word type item");
                            }
                            if (!currentReadWordItem.hasAnyWordType() && this.adminItem_.deleteWordItem(currentReadWordItem) != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete an unused word item");
                            }
                        }
                    }
                }
                if (!isActiveItems || isSameWordOrderNr) {
                    if (this.adminItem_.deleteReadItem(currentReadItem) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete an active read item");
                    }
                    currentReadItem = this.adminItem_.nextReadListItem();
                    continue;
                }
                currentReadItem = currentReadItem.nextReadItem();
                continue;
            }
            currentReadItem = currentReadItem.nextReadItem();
        }
        return 1;
    }

    private byte findGrammarPath(short grammarLevel, short lastCreatedWordOrderNr, GrammarItem parseGrammarItem) {
        short previousWordOrderNr;
        GrammarItem definitionParseGrammarItem;
        short choiceStartWordOrderNr = 0;
        if (grammarLevel >= 50) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given grammar level is too high: #" + grammarLevel);
        }
        if (parseGrammarItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given parse grammar item is undefined");
        }
        if (grammarLevel == 0) {
            this.currentParseWordOrderNr_ = 0;
        }
        short startWordOrderNr = this.currentParseWordOrderNr_;
        do {
            boolean isChoice = false;
            boolean isOption = false;
            boolean isWaitingForChoiceEnd = false;
            boolean isWaitingForNewStart = true;
            this.currentParseWordOrderNr_ = startWordOrderNr;
            previousWordOrderNr = startWordOrderNr;
            definitionParseGrammarItem = parseGrammarItem;
            do {
                if (isWaitingForNewStart && parseGrammarItem.isNewStart()) {
                    isWaitingForNewStart = false;
                }
                if (!isWaitingForNewStart && !isWaitingForChoiceEnd) {
                    previousWordOrderNr = this.currentParseWordOrderNr_;
                    if (parseGrammarItem.isOptionStart()) {
                        isOption = true;
                    }
                    if (parseGrammarItem.isChoiceStart()) {
                        isChoice = true;
                        choiceStartWordOrderNr = this.currentParseWordOrderNr_;
                    }
                    if (parseGrammarItem.isDefinitionStart()) {
                        BoolResultType boolResult = this.adminItem_.selectMatchingWordType(this.currentParseWordOrderNr_, definitionParseGrammarItem.grammarParameter(), definitionParseGrammarItem.grammarWordTypeNr());
                        if (boolResult.result != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to select a matching word type");
                        }
                        if (boolResult.booleanValue) {
                            this.currentParseWordOrderNr_ = (short)(this.currentParseWordOrderNr_ + 1);
                        }
                    } else {
                        if (grammarLevel + 1 >= 50) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "There is probably an endless loop in the grammar definitions, because I reached the grammar level: #" + grammarLevel);
                        }
                        if (parseGrammarItem.definitionGrammarItem == null) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "Grammar word \"" + parseGrammarItem.grammarString() + "\" isn't defined in the grammar file");
                        }
                        if (this.currentParseWordOrderNr_ < lastCreatedWordOrderNr && this.findGrammarPath((short)(grammarLevel + 1), lastCreatedWordOrderNr, parseGrammarItem.definitionGrammarItem) != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find the grammar path at grammar word \"" + parseGrammarItem.grammarString() + "\"");
                        }
                        if (this.currentParseWordOrderNr_ == previousWordOrderNr) {
                            if (isOption) {
                                isWaitingForNewStart = true;
                            }
                            if (isChoice) {
                                if (!parseGrammarItem.isChoiceEnd) {
                                    isWaitingForNewStart = true;
                                }
                                this.currentParseWordOrderNr_ = choiceStartWordOrderNr;
                            }
                            if (startWordOrderNr < this.currentParseWordOrderNr_ && this.adminItem_.activateInactiveReadWords(this.currentParseWordOrderNr_) != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to activate inactive read words from position: " + this.currentParseWordOrderNr_);
                            }
                        }
                    }
                }
                if (parseGrammarItem.isOptionEnd) {
                    isOption = false;
                }
                if (parseGrammarItem.isChoiceEnd) {
                    isChoice = false;
                    isWaitingForChoiceEnd = false;
                }
                parseGrammarItem = parseGrammarItem.nextGrammarItem();
                if (!isChoice || isWaitingForChoiceEnd || this.currentParseWordOrderNr_ <= previousWordOrderNr || parseGrammarItem == null || !parseGrammarItem.isNewStart()) continue;
                isWaitingForChoiceEnd = true;
            } while ((isWaitingForNewStart || isWaitingForChoiceEnd || this.currentParseWordOrderNr_ > previousWordOrderNr) && parseGrammarItem != null && definitionParseGrammarItem.activeSentenceNr() == parseGrammarItem.activeSentenceNr());
            if (isWaitingForNewStart || this.currentParseWordOrderNr_ <= startWordOrderNr || this.currentParseWordOrderNr_ != previousWordOrderNr) continue;
            this.currentParseWordOrderNr_ = startWordOrderNr;
        } while (this.currentParseWordOrderNr_ == startWordOrderNr && definitionParseGrammarItem != null && (parseGrammarItem = definitionParseGrammarItem.nextDefinitionGrammarItem) != null);
        if ((previousWordOrderNr > startWordOrderNr || this.currentParseWordOrderNr_ > startWordOrderNr) && definitionParseGrammarItem != null && definitionParseGrammarItem.isGrammarDefinition() && this.adminItem_.setGrammarParameter(this.currentParseWordOrderNr_ > startWordOrderNr, startWordOrderNr, this.currentParseWordOrderNr_ > startWordOrderNr ? this.currentParseWordOrderNr_ : previousWordOrderNr, definitionParseGrammarItem) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set the grammar parameter of the read words between the positions " + startWordOrderNr + " and " + this.currentParseWordOrderNr_);
        }
        return 1;
    }

    private static byte initializeVariablesInAllWords() {
        WordItem currentWordItem = GlobalVariables.firstWordItem;
        if (currentWordItem != null) {
            do {
                currentWordItem.initializeVariablesInWord();
            } while ((currentWordItem = currentWordItem.nextWordItem()) != null);
        }
        return 1;
    }

    private byte parseSentence(StringBuffer readUserSentenceStringBuffer) {
        boolean isAction = false;
        boolean isChineseCurrentLanguage = this.adminItem_.isChineseCurrentLanguage();
        boolean isNewStart = true;
        short selectionLevel = 0;
        this.isChineseCurrentLanguage_ = isChineseCurrentLanguage;
        this.isUserImperativeSentence_ = false;
        this.selectionListNr_ = Short.MAX_VALUE;
        this.linkedGeneralizationReadItem_ = null;
        this.startGeneralizationReadItem_ = null;
        this.endGeneralizationReadItem_ = null;
        this.adminItem_.initializeLinkedWord();
        if (readUserSentenceStringBuffer == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given read user sentence string buffer is undefined");
        }
        this.currentReadItem_ = this.adminItem_.firstActiveReadItem();
        if (this.currentReadItem_ == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I failed to get the first read item");
        }
        block16: do {
            if (this.currentReadItem_.isSeparator()) continue;
            short wordOrderNr = this.currentReadItem_.wordOrderNr();
            short wordParameter = this.currentReadItem_.wordParameter();
            block0 : switch (this.currentReadItem_.grammarParameter) {
                case 5000: 
                case 5010: 
                case 5011: 
                case 5020: 
                case 5021: 
                case 5022: 
                case 5030: 
                case 5031: 
                case 5100: 
                case 5101: 
                case 5102: 
                case 5120: 
                case 5121: 
                case 5122: 
                case 5123: {
                    if (this.scanSpecification() != 1) {
                        return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to scan the generalization-specification");
                    }
                    if (this.addReadSpecification(isAction, isNewStart, selectionLevel, readUserSentenceStringBuffer.toString()) != 1) {
                        return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to add the read specification");
                    }
                    isNewStart = false;
                    break;
                }
                case 4040: {
                    if (this.readImperative(isAction, isNewStart, selectionLevel) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read an imperative");
                    }
                    isNewStart = false;
                    this.isUserImperativeSentence_ = true;
                    break;
                }
                case 4011: {
                    if (InputOutput.writeInterfaceText(false, (short)5, (short)1628) == 1) continue block16;
                    return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to write an interface warning");
                }
                case 5110: {
                    switch (wordParameter) {
                        case 100: 
                        case 1000: 
                        case 1005: {
                            break block0;
                        }
                        case 1001: {
                            isNewStart = true;
                            break block0;
                        }
                    }
                    return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I found an illegal conjunction word parameter: " + wordParameter);
                }
                case 2400: 
                case 2401: 
                case 2402: 
                case 4030: {
                    switch (wordParameter) {
                        case 2400: {
                            if (this.selectionListNr_ != Short.MAX_VALUE && (selectionLevel = (short)(selectionLevel + 1)) == Short.MAX_VALUE) {
                                return this.adminItem_.startSystemError(1, this.moduleNameString_, "Selection overflow in list <" + this.adminItem_.adminListChar(this.selectionListNr_) + "> at word position " + wordOrderNr);
                            }
                            isNewStart = true;
                            this.selectionListNr_ = (short)4;
                            break block0;
                        }
                        case 2401: {
                            isNewStart = true;
                            isAction = true;
                            this.selectionListNr_ = (short)5;
                            break block0;
                        }
                        case 2402: {
                            isNewStart = true;
                            isAction = false;
                            this.selectionListNr_ = (short)6;
                            break block0;
                        }
                    }
                    return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I found an illegal selection word");
                }
                default: {
                    if (this.adminItem_.isCurrentlyTesting() || this.adminItem_.isSystemStartingUp()) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found an unknown word in sentence \"" + readUserSentenceStringBuffer + "\" at position " + wordOrderNr + " with grammar parameter " + this.currentReadItem_.grammarParameter + " and word parameter " + wordParameter);
                    }
                    return this.adminItem_.startError(1, this.moduleNameString_, "I found an unknown word at position " + wordOrderNr + " with grammar parameter " + this.currentReadItem_.grammarParameter + " and word parameter " + wordParameter);
                }
            }
        } while (this.currentReadItem_ != null && !GlobalVariables.hasDisplayedWarning && !this.adminItem_.hasRequestedRestart() && (this.currentReadItem_ = this.currentReadItem_.nextReadItem()) != null);
        if (this.selectionListNr_ != Short.MAX_VALUE && this.checkForDuplicateSelection() != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check on a duplicate selection");
        }
        return 1;
    }

    private byte processSentence(StringBuffer readUserSentenceStringBuffer) {
        boolean isInterpretationSuccessful;
        short originalLanguageNr = GlobalVariables.currentLanguageNr;
        if (readUserSentenceStringBuffer == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given read user sentence string buffer is undefined");
        }
        short nLanguages = this.adminItem_.nLanguages();
        if (nLanguages <= 0) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find any language");
        }
        short currentLanguageNr = originalLanguageNr;
        if (nLanguages < currentLanguageNr) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The current language number exceeds the number of languages");
        }
        do {
            this.adminItem_.deleteTemporaryReadList();
            if (currentLanguageNr != GlobalVariables.currentLanguageNr && this.assignLanguage(currentLanguageNr) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the language");
            }
            if (this.adminItem_.checkGrammarOfCurrentLanguage() != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check the grammar");
            }
            BoolResultType boolResult = this.adminItem_.expandMergedWordsInReadSentenceOfCurrentLanguage(readUserSentenceStringBuffer);
            if (boolResult.result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to expand the merged words in the read user sentence string");
            }
            if (boolResult.booleanValue && GlobalVariables.readUserSentenceStringBuffer != null) {
                readUserSentenceStringBuffer = GlobalVariables.readUserSentenceStringBuffer;
            }
            boolResult = this.adminItem_.createReadWords(this.isChineseCurrentLanguage_, readUserSentenceStringBuffer.toString());
            if (boolResult.result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to create the read words");
            }
            isInterpretationSuccessful = false;
            this.adminItem_.clearLastActivatedWordOrderNr();
            if (boolResult.booleanValue) {
                short lastCreatedWordOrderNr = this.adminItem_.lastCreatedWordOrderNr();
                GrammarItem readingGrammarItem = this.adminItem_.firstCurrentLanguageReadingGrammarItem();
                do {
                    if (this.findGrammarPath((short)0, lastCreatedWordOrderNr, readingGrammarItem) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find the grammar path for a sentence with language \"" + this.adminItem_.languageNameString(currentLanguageNr) + "\"");
                    }
                    boolean bl = isInterpretationSuccessful = this.currentParseWordOrderNr_ == lastCreatedWordOrderNr;
                    if (isInterpretationSuccessful) continue;
                    boolResult = this.adminItem_.findMoreInterpretations();
                    if (boolResult.result == 1) continue;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find more interpretations");
                } while (!isInterpretationSuccessful && boolResult.booleanValue);
            }
            if (isInterpretationSuccessful) {
                if (this.deleteUnusedWordsAndWordTypes() != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete the unused words and word types of the read words");
                }
                if (this.parseSentence(readUserSentenceStringBuffer) == 1) continue;
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to parse the sentence");
            }
            if (this.deleteAllWordTypesOfCurrentSentence() != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to delete words and word types of the read words");
            }
            if (nLanguages <= 1) {
                currentLanguageNr = (short)(currentLanguageNr + 1);
                continue;
            }
            if ((currentLanguageNr = currentLanguageNr == originalLanguageNr ? (short)1 : (short)(currentLanguageNr + 1)) != originalLanguageNr) continue;
            currentLanguageNr = (short)(currentLanguageNr + 1);
        } while (!isInterpretationSuccessful && currentLanguageNr <= nLanguages);
        if (!isInterpretationSuccessful) {
            if (this.wasPreviousCommandUndoOrRedo_) {
                this.wasPreviousCommandUndoOrRedo_ = false;
                AdminReadSentence.clearReplacingInfoInSpecificationWords();
            }
            if (GlobalVariables.currentLanguageNr != originalLanguageNr && this.assignLanguage(originalLanguageNr) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the language after an interpretation failure");
            }
            if (this.currentParseWordOrderNr_ == 0) {
                if (this.adminItem_.isSystemStartingUp()) {
                    return this.adminItem_.startSystemError(1, this.moduleNameString_, "I don't understand this sentence. Please make sure you enter a sentence within my limited grammar definition");
                }
                if (InputOutput.writeInterfaceText(false, (short)5, (short)1620) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write an interface warning");
                }
            } else {
                if (this.adminItem_.isSystemStartingUp()) {
                    return this.adminItem_.startSystemError(1, this.moduleNameString_, "I don't understand the sentence from the word at position: " + this.currentParseWordOrderNr_);
                }
                if (InputOutput.writeInterfaceText((short)5, (short)1621, (int)this.currentParseWordOrderNr_, (short)1622) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write an interface warning");
                }
            }
        }
        return 1;
    }

    private byte readImperative(boolean isAction, boolean isNewStart, short selectionLevel) {
        ReadItem currentReadItem;
        boolean hasFoundChineseImperativeVerb = false;
        short executionNounWordParameter = 0;
        short imperativeVerbParameter = 0;
        WordItem imperativeVerbWordItem = null;
        this.startGeneralizationReadItem_ = null;
        this.endGeneralizationReadItem_ = null;
        if (this.scanSpecification() != 1) {
            return this.adminItem_.addErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I failed to scan the generalization-specification");
        }
        if (this.endGeneralizationReadItem_ == null || (currentReadItem = this.startGeneralizationReadItem_) == null) {
            return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "I couldn't find the imperative");
        }
        do {
            short tempNounWordParameter;
            if (currentReadItem.isVerb()) {
                short tempVerbParameter;
                if (this.isChineseCurrentLanguage_ && (tempVerbParameter = currentReadItem.readAheadChineseImperativeVerbParameter()) > 0) {
                    hasFoundChineseImperativeVerb = true;
                    imperativeVerbParameter = tempVerbParameter;
                    imperativeVerbWordItem = this.adminItem_.predefinedWordItem(tempVerbParameter);
                    continue;
                }
                imperativeVerbParameter = currentReadItem.wordParameter();
                imperativeVerbWordItem = currentReadItem.readWordItem();
                continue;
            }
            if (!currentReadItem.isSpecificationWord() || currentReadItem.isNounHeadOrTail() || (tempNounWordParameter = currentReadItem.wordParameter()) <= 0) continue;
            executionNounWordParameter = tempNounWordParameter;
        } while ((currentReadItem = currentReadItem.nextReadItem()) != null);
        ReadItem specificationReadItem = this.startSpecificationReadItem_;
        if (specificationReadItem == null) {
            if (imperativeVerbWordItem != null && imperativeVerbWordItem.isImperativeVerbUndoOrRedo()) {
                this.wasPreviousCommandUndoOrRedo_ = true;
            } else {
                this.wasPreviousCommandUndoOrRedo_ = false;
                AdminReadSentence.clearReplacingInfoInSpecificationWords();
            }
            if (this.adminItem_.executeImperative(true, (short)Short.MAX_VALUE, (short)0, this.startGeneralizationReadItem_.wordParameter(), (short)0, Integer.MAX_VALUE, this.startGeneralizationReadItem_.readString, this.startGeneralizationReadItem_.readWordItem(), null, this.startRelationReadItem_, this.endRelationReadItem_, null, null) != 1) {
                if (this.startGeneralizationReadItem_ == null) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute the single imperative");
                }
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute the single imperative at position " + this.startGeneralizationReadItem_.wordOrderNr());
            }
        } else {
            if (this.endSpecificationReadItem_ == null) {
                return this.adminItem_.startErrorWithAdminListNr(this.selectionListNr_, 1, this.moduleNameString_, "The end specification read item is undefined");
            }
            if (this.addReadSpecification(isAction, isNewStart, selectionLevel, null) != 1) {
                if (this.startGeneralizationReadItem_ == null || this.endGeneralizationReadItem_ == null) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the generalization part of the read specification");
                }
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add the generalization part of the read specification between the positions " + this.startGeneralizationReadItem_.wordOrderNr() + " and " + this.endGeneralizationReadItem_.wordOrderNr());
            }
            if (!GlobalVariables.hasDisplayedWarning && this.selectionListNr_ == Short.MAX_VALUE) {
                do {
                    if (!specificationReadItem.isImperativeNoun()) continue;
                    short specificationWordTypeNr = specificationReadItem.wordTypeNr();
                    if (hasFoundChineseImperativeVerb && specificationWordTypeNr == 11 || this.adminItem_.executeImperative(true, (short)Short.MAX_VALUE, executionNounWordParameter, imperativeVerbParameter, specificationWordTypeNr, Integer.MAX_VALUE, specificationReadItem.readString, imperativeVerbWordItem, specificationReadItem.readWordItem(), this.startRelationReadItem_, this.endRelationReadItem_, null, null) == 1) continue;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute an imperative with specifications");
                } while (this.startGeneralizationReadItem_ == this.endGeneralizationReadItem_ && specificationReadItem != this.endSpecificationReadItem_ && !specificationReadItem.isVirtualListPreposition() && this.adminItem_.firstActiveReadItem() != null && !GlobalVariables.hasDisplayedWarning && (specificationReadItem = specificationReadItem.nextReadItem()) != null);
            }
        }
        return 1;
    }

    private byte scanSpecification() {
        boolean hasGeneralizationArticle = false;
        boolean isStop = false;
        short generalizationAdjectiveParameter = 0;
        short generalizationDefiniteArticleParameter = 0;
        short generalizationIndefiniteArticleParameter = 0;
        short previousWordTypeNr = 0;
        ReadItem previousReadItem = null;
        this.hasFemaleUserSpecificationWord_ = false;
        this.isAssignment_ = false;
        this.isInactiveAssignment_ = false;
        this.isArchivedAssignment_ = false;
        this.isCharacteristicFor_ = false;
        this.isConditional_ = false;
        this.isEveryGeneralization_ = false;
        this.isExclusiveSpecification_ = false;
        this.isNegative_ = false;
        this.isPartOf_ = false;
        this.isPossessive_ = false;
        this.isSpecific_ = false;
        this.isSpecificationGeneralization_ = false;
        this.isUncountableGeneralizationNoun_ = false;
        this.isUniqueUserRelation_ = false;
        this.currentParseWordOrderNr_ = 0;
        this.prepositionParameter_ = 0;
        this.questionParameter_ = 0;
        this.userAssumptionLevel_ = 0;
        this.generalizationContextNr_ = 0;
        this.specificationContextNr_ = 0;
        this.startSpecificationReadItem_ = null;
        this.endSpecificationReadItem_ = null;
        this.startRelationReadItem_ = null;
        this.endRelationReadItem_ = null;
        GlobalVariables.nUserGeneralizationWords = 0;
        GlobalVariables.nUserSpecificationWords = 0;
        GlobalVariables.nUserRelationWords = 0;
        if (this.linkedGeneralizationReadItem_ == null) {
            this.startGeneralizationReadItem_ = null;
            this.endGeneralizationReadItem_ = null;
        }
        if (this.currentReadItem_ == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The read item is undefined");
        }
        do {
            boolean isFrenchPreposition = this.currentReadItem_.isFrenchPreposition();
            short currentWordParameter = this.currentReadItem_.wordParameter();
            short currentWordTypeNr = this.currentReadItem_.wordTypeNr();
            WordItem currentReadWordItem = this.currentReadItem_.readWordItem();
            this.setVariables(currentWordParameter);
            boolean isSameWordTypeAsPreviousWord = isFrenchPreposition || previousWordTypeNr == currentWordTypeNr || this.adminItem_.isNounWordType(previousWordTypeNr) && this.adminItem_.isNounWordType(currentWordTypeNr);
            switch (this.currentReadItem_.grammarParameter) {
                case 4010: {
                    if (!this.isChineseCurrentLanguage_ || !this.currentReadItem_.isQuestionMark()) break;
                    this.questionParameter_ = (short)2200;
                    break;
                }
                case 5100: {
                    this.isAssignment_ = true;
                }
                case 4040: 
                case 5000: 
                case 5010: 
                case 5011: {
                    ContextResultType contextResult;
                    switch (currentWordTypeNr) {
                        case 6: {
                            if (this.adminItem_.isAdjectiveParameter(this.currentReadItem_.wordParameter())) {
                                generalizationAdjectiveParameter = this.currentReadItem_.wordParameter();
                            }
                            if (this.currentReadItem_.isAdjectivePrevious()) {
                                this.isAssignment_ = true;
                                this.isInactiveAssignment_ = true;
                            }
                            if (!this.currentReadItem_.isAdjectiveEvery()) break;
                            this.isEveryGeneralization_ = true;
                            break;
                        }
                        case 9: {
                            hasGeneralizationArticle = true;
                            if (this.currentReadItem_.isDefiniteArticleParameter(this.currentReadItem_.wordParameter())) {
                                generalizationDefiniteArticleParameter = this.currentReadItem_.wordParameter();
                                break;
                            }
                            generalizationIndefiniteArticleParameter = this.currentReadItem_.wordParameter();
                            break;
                        }
                        case 5: 
                        case 11: 
                        case 12: {
                            if (this.currentReadItem_.isNounPartOf()) {
                                this.isPartOf_ = true;
                            }
                            if (!this.currentReadItem_.isGeneralizationWord() || currentReadWordItem == null) break;
                            if (isSameWordTypeAsPreviousWord) {
                                if (this.addMultipleWord(generalizationAdjectiveParameter, generalizationDefiniteArticleParameter, generalizationIndefiniteArticleParameter, previousReadItem, this.currentReadItem_) != 1) {
                                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a multiple generalization word");
                                }
                                this.currentReadItem_ = previousReadItem;
                            } else {
                                this.previousGeneralizationWordTypeNr_ = currentWordTypeNr;
                                this.previousGeneralizationWordItem_ = currentReadWordItem;
                                ++GlobalVariables.nUserGeneralizationWords;
                            }
                            if (this.currentReadItem_.isUncountableGeneralizationNoun()) {
                                this.isUncountableGeneralizationNoun_ = true;
                            }
                            currentReadWordItem.isUserGeneralizationWord = true;
                            break;
                        }
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: {
                            if (this.generalizationContextNr_ > 0) {
                                return this.adminItem_.startError(1, this.moduleNameString_, "The generalization context number is already assigned");
                            }
                            contextResult = this.addPronounContext(currentWordTypeNr, currentReadWordItem);
                            if (contextResult.result != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a generalization pronoun context");
                            }
                            this.generalizationContextNr_ = contextResult.contextNr;
                        }
                    }
                    if (this.startGeneralizationReadItem_ == null) {
                        this.startGeneralizationReadItem_ = this.currentReadItem_;
                    }
                    this.endGeneralizationReadItem_ = this.currentReadItem_;
                    break;
                }
                case 5012: {
                    ReadItem nextReadItem;
                    isStop = true;
                    this.linkedGeneralizationReadItem_ = nextReadItem = this.currentReadItem_.nextReadItem();
                    break;
                }
                case 5023: {
                    this.isExclusiveSpecification_ = true;
                    break;
                }
                case 5030: 
                case 5031: {
                    if (this.currentReadItem_.isPreposition()) {
                        this.prepositionParameter_ = currentWordParameter;
                    }
                    if (this.currentReadItem_.isRelationWord() && currentReadWordItem != null) {
                        if (previousWordTypeNr != currentWordTypeNr) {
                            if (previousWordTypeNr == 2) {
                                isSameWordTypeAsPreviousWord = true;
                            } else if (currentWordTypeNr == 11 && previousWordTypeNr == 22) {
                                this.isUncountableGeneralizationNoun_ = true;
                            }
                        }
                        if (isSameWordTypeAsPreviousWord) {
                            if (this.addMultipleWord((short)0, (short)0, (short)0, previousReadItem, this.currentReadItem_) != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a multiple relation word");
                            }
                            this.currentReadItem_ = previousReadItem;
                        } else {
                            ++GlobalVariables.nUserRelationWords;
                        }
                        currentReadWordItem.isUserRelationWord = true;
                    }
                    if (this.startSpecificationReadItem_ == null) {
                        this.startSpecificationReadItem_ = this.currentReadItem_;
                    }
                    this.endSpecificationReadItem_ = this.currentReadItem_;
                    if (this.startRelationReadItem_ == null) {
                        this.startRelationReadItem_ = this.currentReadItem_;
                    }
                    this.endRelationReadItem_ = this.currentReadItem_;
                    if (currentWordParameter != 200 && currentWordParameter != 1004) break;
                    this.isExclusiveSpecification_ = true;
                    break;
                }
                case 5021: 
                case 5101: {
                    ContextResultType contextResult;
                    this.isAssignment_ = true;
                    if (this.currentReadItem_.isDeterminerOrPronoun()) {
                        if (this.specificationContextNr_ > 0) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "The specification context number is already assigned");
                        }
                        contextResult = this.addPronounContext(currentWordTypeNr, currentReadWordItem);
                        if (contextResult.result != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a specification pronoun context");
                        }
                        this.specificationContextNr_ = contextResult.contextNr;
                    }
                }
                case 5020: 
                case 5022: 
                case 5040: {
                    if (this.currentReadItem_.isSpecificationWord() && currentReadWordItem != null) {
                        if (isSameWordTypeAsPreviousWord) {
                            if (this.addMultipleWord((short)0, (short)0, (short)0, previousReadItem, this.currentReadItem_) != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a multiple specification word");
                            }
                            this.currentReadItem_ = previousReadItem;
                        } else {
                            WordEndingResultType wordEndingResult;
                            if (!hasGeneralizationArticle && this.isArchivedAssignment_) {
                                if (this.isChineseCurrentLanguage_) {
                                    if (this.startRelationReadItem_ != null) {
                                        wordEndingResult = this.adminItem_.analyzeWordEndingWithCurrentLanguage((short)3006, 0, currentReadWordItem.activeWordTypeString((short)11));
                                        if (wordEndingResult.result != 1) {
                                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check for a Chinese assignment noun");
                                        }
                                        if (wordEndingResult.hasFoundWordEnding) {
                                            this.isUniqueUserRelation_ = true;
                                        }
                                    }
                                } else {
                                    this.isUniqueUserRelation_ = true;
                                }
                            }
                            if (currentReadWordItem.isFemale()) {
                                this.hasFemaleUserSpecificationWord_ = true;
                            }
                            ++GlobalVariables.nUserSpecificationWords;
                            if (currentWordTypeNr == 11) {
                                WordTypeItem generalizationWordTypeItem;
                                WordTypeItem currentReadWordTypeItem;
                                if (this.isChineseCurrentLanguage_) {
                                    if (!this.isAssignment_ && !this.isPossessive_ && currentWordParameter == 0 && this.startRelationReadItem_ != null) {
                                        wordEndingResult = this.adminItem_.analyzeWordEndingWithCurrentLanguage((short)3006, 0, currentReadWordItem.activeWordTypeString((short)11));
                                        if (wordEndingResult.result != 1) {
                                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check for a Chinese assignment noun");
                                        }
                                        if (wordEndingResult.hasFoundWordEnding) {
                                            this.isAssignment_ = true;
                                        }
                                    }
                                } else if (this.previousGeneralizationWordItem_ != null && this.previousGeneralizationWordTypeNr_ == 5 && (currentReadWordTypeItem = this.currentReadItem_.activeReadWordTypeItem()) != null && !currentReadWordTypeItem.hasDefiniteArticleParameter() && !currentReadWordTypeItem.hasIndefiniteArticleParameter() && (generalizationWordTypeItem = this.previousGeneralizationWordItem_.activeWordTypeItem((short)5)) != null && generalizationWordTypeItem.hasFeminineOrMasculineWordEnding() && currentReadWordTypeItem.setIndefiniteArticleParameter(generalizationWordTypeItem.hasFeminineWordEnding() ? (short)906 : 907) != 1) {
                                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set the indefinite article parameter of a singular noun");
                                }
                            }
                        }
                        currentReadWordItem.isUserSpecificationWord = true;
                    }
                    if (this.startSpecificationReadItem_ == null) {
                        this.startSpecificationReadItem_ = this.currentReadItem_;
                    }
                    this.endSpecificationReadItem_ = this.currentReadItem_;
                    break;
                }
                case 5102: {
                    break;
                }
                case 5120: {
                    if (this.startSpecificationReadItem_ == null) {
                        this.startSpecificationReadItem_ = this.currentReadItem_;
                    }
                    this.endSpecificationReadItem_ = this.currentReadItem_;
                    break;
                }
                case 5121: {
                    this.questionParameter_ = currentWordParameter;
                    break;
                }
                case 5123: {
                    this.questionParameter_ = currentWordParameter;
                }
                case 5122: {
                    this.isSpecificationGeneralization_ = true;
                    if (this.startSpecificationReadItem_ == null) {
                        this.startSpecificationReadItem_ = this.currentReadItem_;
                    }
                    this.endSpecificationReadItem_ = this.currentReadItem_;
                    break;
                }
                default: {
                    if (previousReadItem == null) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found a word that doesn't belong to an assignment or a specification");
                    }
                    isStop = true;
                    this.currentReadItem_ = previousReadItem;
                }
            }
            if (!isFrenchPreposition) {
                previousWordTypeNr = currentWordTypeNr;
            }
            previousReadItem = this.currentReadItem_;
        } while (!isStop && (this.currentReadItem_ = this.currentReadItem_.nextReadItem()) != null);
        return 1;
    }

    private ContextResultType addPronounContext(short contextWordTypeNr, WordItem contextWordItem) {
        ContextResultType contextResult = new ContextResultType();
        if (contextWordItem == null) {
            return this.adminItem_.startContextResultError(1, this.moduleNameString_, "The read word of the read ahead item is undefined");
        }
        contextResult.contextNr = contextWordItem.contextNr(null);
        if (contextResult.contextNr == 0) {
            contextResult.contextNr = this.adminItem_.highestContextNrInAllContextWords();
            if (contextResult.contextNr >= Integer.MAX_VALUE) {
                return this.adminItem_.startContextResultSystemError(1, this.moduleNameString_, "Context number overflow");
            }
            ++contextResult.contextNr;
        }
        if (contextWordItem.addContext(contextWordTypeNr, (short)0, contextResult.contextNr, 0, null) != 1) {
            return this.adminItem_.addContextResultError(1, this.moduleNameString_, "I failed to add a pronoun context to word \"" + contextWordItem.anyWordTypeString() + "\"");
        }
        return contextResult;
    }

    protected AdminReadSentence(AdminItem adminItem) {
        this.adminItem_ = adminItem;
        if (this.adminItem_ == null) {
            GlobalVariables.result = (byte)-1;
            Console.addError("\nClass:" + this.moduleNameString_ + "\nMethod:\t" + "<init>" + "\nError:\t\tThe given admin item is undefined.\n");
        }
    }

    protected boolean hasAnyChangeBeenMadeByThisSentence() {
        return this.hasAnyChangeBeenMadeByThisSentence_;
    }

    protected boolean hasFemaleUserSpecificationWord() {
        return this.hasFemaleUserSpecificationWord_;
    }

    protected boolean isUniqueUserRelation() {
        return this.isUniqueUserRelation_;
    }

    protected boolean isUserQuestion() {
        return this.questionParameter_ > 0;
    }

    protected boolean wasPreviousCommandUndoOrRedo() {
        return this.wasPreviousCommandUndoOrRedo_;
    }

    protected byte processReadSentence(StringBuffer readUserSentenceStringBuffer) {
        int startSentenceNr = GlobalVariables.currentSentenceNr;
        this.previousGeneralizationWordTypeNr_ = 0;
        this.previousGeneralizationWordItem_ = null;
        GlobalVariables.hasFoundAnswerToQuestion = false;
        GlobalVariables.isFirstAnswerToQuestion = true;
        GlobalVariables.isQuestionAlreadyAnswered = false;
        GlobalVariables.firstTouchedWordItem = null;
        GlobalVariables.writtenUserSentenceStringBuffer = new StringBuffer();
        if (readUserSentenceStringBuffer == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given read user sentence string buffer is undefined");
        }
        if (AdminReadSentence.initializeVariablesInAllWords() != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to initialize variables in all words");
        }
        if (this.processSentence(readUserSentenceStringBuffer) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to process sentence: \"" + readUserSentenceStringBuffer + "\"");
        }
        if (!GlobalVariables.hasDisplayedWarning && !this.adminItem_.hasRequestedRestart() && startSentenceNr == GlobalVariables.currentSentenceNr) {
            this.checkForChangesMadeByThisSentence();
            if (this.hasAnyChangeBeenMadeByThisSentence_ && !this.isUserImperativeSentence_ && this.selectionListNr_ == Short.MAX_VALUE && this.adminItem_.checkIntegrityOfStoredUserSentence(readUserSentenceStringBuffer.toString()) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check the integrity of the stored user sentence \"" + readUserSentenceStringBuffer + "\"");
            }
            if (!GlobalVariables.hasDisplayedWarning) {
                if (this.hasAnyChangeBeenMadeByThisSentence_) {
                    if (this.adminItem_.writeSelfGeneratedInfo(true, false, false) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the self-generated conclusions");
                    }
                    if (this.adminItem_.writeSelfGeneratedInfo(false, true, false) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the self-generated assumptions");
                    }
                    if (this.adminItem_.writeSelfGeneratedInfo(false, false, true) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the self-generated questions");
                    }
                    if (this.checkAllWordsForStructuralIntegrity() != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "The system has problem with the structural integrity");
                    }
                }
                if (this.questionParameter_ > 0 && this.adminItem_.answerQuestions() != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to answer questions");
                }
            }
        }
        return 1;
    }
}

