<?
/*----------------------------------------------------

  TwCoreClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/WikiCommonLib.php' );
require_once( 'Wiki/PluginManager.php' );
require_once( 'Wiki/WikiDisplayManager.php'  );
require_once( 'Wiki/Auth.php' );
require_once( 'Wiki/MessageManager.php' );

class TwCore
{

var $config;
var $plugin_manager;
var $tw_db;
var $auth;
var $display_manager;
var $message_manager;
var $process_status;

//////////////////////////////////////////
// 󥹥ȥ饯
function TwCore(&$config_obj)
{
	$this->config = &$config_obj;
}


//////////////////////////////////////////
// 
function initialize(&$error_message)
{
	// å꥽ޥ͡
	$this->message_manager = new MessageManager( $this->config );
	
	if(! $this->message_manager->load() )
	{
		array_push($error_message,"Resource file load error.");
		return false;
	}
	
	//ץ饰ޥ͡㡼
	$this->plugin_manager = new PluginManager( $this,$this->config );
	
	// DB³
	if( !$this->plugin_manager->database_connection_initialize() )
	{
		array_push($error_message,$this->message_manager->get('ERROR_DB_INITIALIZE').$this->config->get('db_plugin_name'));
		return false;
	}
	$this->tw_db = $this->plugin_manager->wiki_db;
	
	
	// ǧڥ饹
	$this->auth = new Auth( $this->config , $this->plugin_manager );
	
	
	// ǥץ쥤ޥ͡
	$this->display_manager = new WikiDisplayManager( $this,$this->config,$this->plugin_manager,$this->message_manager,$this->auth );
	
	return true;
}


//////////////////////////////////////////
// ¹
function run(&$error_message)
{
	$this->process_status = array();
	$request_array = $_REQUEST;
	$request_array['ns'] = WikiCommonLib::convert_slashes($request_array['ns']);
	$request_array['pg'] = WikiCommonLib::convert_slashes($request_array['pg']);
	
	$mode = "";
	if( !$this->system_mode_switch($error_message,$request_array,$mode) )
	{
		array_push($error_message,"System Manager Exception");
		return false;
	}
	
	
	$html = $this->display_manager->render( $mode,$request_array );
	if( $html )
	{
		$this->output( $html );
		return true;
	}
	else
	{
		array_push($error_message,"Unknown Exception");
		return false;
	}
}

//////////////////////////////////////////
// ʬ
function system_mode_switch( &$error_message,&$request_data,&$mode )
{
	$mode = $this->process_status['mode'] = $request_data['md'];
	switch( $mode )
	{
		case('login'):
			$this->process_login( $request_data,$mode );
			return true;

		case('logout'):
			$this->process_logout( $request_data );
			return true;
		
		case('system'):
			$this->process_system_manager( &$request_data );
			return false;
	}
	return true;

}

//////////////////////////////////////////
// 
function output( $body )
{
	if($this->auth->auth_flag == "on")
	{
		session_write_close();
	}
	
	header("Content-Type: text/html; charset=EUC-JP");
	print( $body );
	
	exit;
}

//////////////////////////////////////////
// 
function process_login( &$post_data,&$mode )
{
	$this->auth->login( $post_data['id'],$post_data['password'] );
	$mode = $this->process_status['mode'] = $post_data['login_md'];
}

//////////////////////////////////////////
// Ƚ
function process_logout( &$post_data )
{
	if ($this->auth->logout() )
	{
		$mode = $post_data['login_md'];
	}
}


//////////////////////////////////////////
// åɽ
function print_message($message,$message_title)
{
	$this->output( $this->display_manager->call_smarty($message,$message_title) );
}



//////////////////////////////////////////
// ƥ
function process_system_manager( &$postdata )
{
	require_once( 'Wiki/UserManager.php' );
	require_once( 'Wiki/SystemMenuRenderer.php' );
	
	$user_manager    = new UserManager( $this->config , $this->auth );
	$system_renderer = new SystemMenuRenderer( $this->config );
	
	$html  = "";
	$title = $this->message_manager->get( 'TITLE_SYSTEM_MANAGER' );
	$sub_mode = $postdata['smd'];
	
	// ưå
	if( $user_manager->check_initial_start() )
	{
		switch( $sub_mode )
		{
		case( 'user_add_post'):
			
			if( $postdata['password'] == "")
			{
				$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_EMPTY') );
			}
			elseif( $postdata['password'] == $postdata['password_confirm'])
			{
				if( $user_manager->add_user($postdata['id'] ,$postdata['password'],true) )
				{
					$html  = $this->message_manager->get( 'MESSAGE_ADMIN_USER_ADD' );
				}
				else
				{
					$html  = $this->message_manager->get( 'ERROR_USER_ADD_FAIL' );
				}
			}
			else{
				$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_TYPO') );
			}
			$this->print_message( $html ,$title );
			break;
		
		
		case( 'user_add' ):
		default:
			$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_INITIAL_START') );
			$this->print_message( $html ,$title );
			break;
		
		}
	}
	
	if( !$this->auth->check_user_operation_permission("system") )
	{
		$html = $this->display_manager->render_login_page($page_name,$name_space,"system");
		$this->output($html);
	}
	
	// 
	switch( $sub_mode )
	{
	case( 'user_add_post'):
		if( $postdata['password'] == "")
		{
			$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_EMPTY') );
		}
		elseif( $postdata['password'] == $postdata['password_confirm'])
		{
			if( $user_manager->add_user($postdata['id'] ,$postdata['password'],false) )
			{
				$user_data_list = $user_manager->get_user_data_list();
				$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_USER_ADD') );
				$html .= $system_renderer->user_list( $user_data_list );
			}
			else
			{
				$html = $system_renderer->user_add_form( $this->message_manager->get( 'ERROR_USER_ADD_FAIL' ) );
			}
		}
		else{
			$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_TYPO') );
		}
		break;
	
	
	case( 'target' ):
		list( $target_mode,$target_name ) = $this->get_target( $postdata );
		if($user_data = $user_manager->get_user_data($target_name))
		{
			if( $target_mode == "edit" )
			{
				$html = $system_renderer->user_edit_form($user_data);
			}
			else
			{
				$html = $system_renderer->user_delete_form($user_data);
			}
		}
		
		break;
	
	case( 'target_edit_post' ):
		$old_data = $user_manager->get_user_data($postdata['id']);
		if( $postdata['password'] != "" )
		{
			if($postdata['password'] == $postdata['password_confirm'])
			{
				if($user_manager->modify_user_data($postdata['id'],$postdata['password'],$old_data))
				{
					$user_data_list = $user_manager->get_user_data_list();
					$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_USER_ADD') );
					$html .= $system_renderer->user_list( $user_data_list );
					
				}
				else
				{
					$html  = $this->message_manager->get( 'ERROR_USER_ADD_FAIL' );
				}
			}
			else
			{
				$html = $system_renderer->user_edit_form( $old_data,$this->message_manager->get('ERROR_PASSWORD_TYPO') );
			}
		}
		
		break;
	
	
	
	case('target_delete_post'):
		if( $user_manager->delete_user($postdata['id']) )
		{
			$user_data_list = $user_manager->get_user_data_list();
			$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_USER_DELETE') );
			$html .= $system_renderer->user_list( $user_data_list );
		}
		else
		{
			$user_data_list = $user_manager->get_user_data_list();
			$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_USER_DELETE_FAIL') );
			$html .= $system_renderer->user_list( $user_data_list );
		}
		
		break;
	
	default:
		$user_data_list = $user_manager->get_user_data_list();
		$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_USER_ADD_FORM') );
		$html .= $system_renderer->user_list( $user_data_list );
		break;
	}
	
	$this->print_message( $html ,$title );

}

//////////////////////////////////////////
// POSTͤо
function get_target( &$postdata )
{
	while( list($key_name,$value )= each($postdata) )
	{
		if( $value )
		{
			if( preg_match("/^edit_(.+)$/",$key_name,$match) )
			{
				return array("edit",$match[1]);
			}
			elseif( preg_match("/^delete_(.+)$/",$key_name,$match) )
			{
				return array("delete",$match[1]);
			}
		}
	}
	return array("","");
}


}
?>
