<?php
/*----------------------------------------------------

  WikiDiplayManagerClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/WikiCommonLib.php' );
require_once( 'Wiki/WikiRenderer.php' );
require_once( 'Wiki/SystemMenuRenderer.php' );
require_once( 'Wiki/ListRenderer.php' );
require_once( 'Wiki/CacheManager.php' );
require_once( 'Wiki/PageData.php' );
require_once( 'Wiki/WikiDiff.php' );
require_once( 'Smarty/Smarty.class.php' );

class WikiDisplayManager
{

var $core;
var $config;
var $plugin_manager;
var $message_manager;
var $cache_manager;
var $auth;
var $wiki_db;
var $wiki_renderer;
var $system_menu_renderer;
var $list_renderer;
var $smarty;

var $use_template_name;


//////////////////////////////////////////
// 󥹥ȥ饯
function WikiDisplayManager( &$core,&$config, &$plugin_manager, &$message_manager,&$auth )
{
	$this->core     = &$core;
	$this->config   = &$config;
	$this->plugin_manager  = &$plugin_manager;
	$this->message_manager = &$message_manager;
	$this->auth     = &$auth;
	$this->wiki_db  = &$plugin_manager->wiki_db;
	
	$this->wiki_renderer        = new WikiRenderer($config,$this->wiki_db,$plugin_manager);
	$this->system_menu_renderer = new SystemMenuRenderer( $config );
	$this->list_renderer        = new ListRenderer( $config,$this->wiki_renderer,$message_manager );
	$this->cache_manager        = new CacheManager( $config,$auth );
	$this->smarty               = new Smarty();
	$this->smarty->template_dir = $config->get('template_dir');
	
	$this->use_template_name    = $config->get('use_template_name');

	$this->base_template_data               = array();
	$this->base_template_data['SITE_NAME']  = $config->get('site_name');
	$this->base_template_data['MY_URL']     = $_SERVER['PHP_SELF'];
	$this->base_template_data['BASE_TAG']   = $config->get('base_tag') .$config->get('use_template_name') . "/";
	$this->base_template_data['SIDE_MENU_PAGE_NAME'] = urlencode( $config->get('side_menu_page') );
	$this->base_template_data['SIDE_MENU_PAGE_NAME2'] = urlencode( $config->get('side_menu_page2') );

}


//////////////////////////////////////////
// Wikiڡ󥰽
function render( $mode,&$request )
{
	$namespace = $this->core->process_status['namespace'] = $request['ns'];
	$pagename  = $this->core->process_status['pagename']  = $request['pg'];
	$action    = $mode;
	
	if( $mode == "read" || $mode == "edit" || $mode == "" )
	{
		// оݥڡ¸ߥå
		$exists_check_result = $this->wiki_db->check_exist( $pagename,$namespace );
	
		// ¹ԥ
		$action = $this->check_action( $exists_check_result,$mode,$request );
	}

	$this->base_template_data['MD']        = $action;
	$this->base_template_data['PG']        = urlencode( $pagename );
	$this->base_template_data['NS']        = urlencode( $namespace );
	$this->base_template_data['PAGE_NAME'] = $pagename;
	$this->base_template_data['NAME_SPACE'] = $namespace;
	
	// ǧ
	if( !$this->auth->check_user_operation_permission($action) )
	{
		return $this->render_login_page( $pagename,$namespace,$mode );
	}
	
	switch( $action )
	{
		case('read'):
			return $this->render_normal_page( $pagename,$namespace,$request['word'],$request['number'] );
		
		case('edit'):
			return $this->render_edit_page( $pagename,$namespace );
		
		case('create'):
			return $this->render_create_page( $pagename,$namespace );
		
		case('post'):
			$result = $this->render_post_result( $request );
			if( !$result )
			{
				return $this->render_create_page( $request['page_name'],$request['name_space'] );
			}
			else
			{
				return $result;
			}
		
		case('list'):
			return $this->render_page_list( $namespace );
		
		case('history'):
			return $this->render_history_list( $pagename,$namespace );
		
		case('read_history'):
			return $this->render_history_page( $request['ts'],$pagename,$namespace );
		
		case('plugin'):
			return $this->call_plugin( $pagename,$namespace,$request['pn'],$request);

		case('search'):
			return $this->render_grep_result( $request['word'],$namespace );
		
		case('permission'):
			return $this->process_permission_manager( $request );
			break;
			
		case('file'):
			return $this->process_file_manager( $request );
			break;
		
		
		default:
			return $this->render_normal_page( $pagename,$namespace,$request['word'],$request['number'] );
			break;
		

	}
}


//////////////////////////////////////////
// 
function check_action( $exists_result ,$mode,&$row_request )
{
	switch( $mode )
	{
	case('edit'):
		if( $exists_result == "hit" )
		{
			return "edit";
		}
		else
		{
			return "create";
		}
	
	
	case('read'):
	default:
		if( $exists_result != "hit" && $row_request['pg'] == "" )
		{
			return "list";
		}
		
		if( $exists_result == "not_found" )
		{
			return "create";
		}
		else
		{
			return "read";
		}
	
	}
}

//////////////////////////////////////////
// ڡ
function render_login_page( $pagename,$namespace,$mode )
{
	$main  = $this->system_menu_renderer->login_form( $pagename,$namespace,$mode );
	$title = $this->message_manager->get( 'TITLE_LOGIN' );
	return $this->call_smarty( $main,$title );
}

//////////////////////////////////////////
// ̾ڡ
function render_normal_page( $pagename,$namespace,$word="",$number=0 )
{
	if( $word == "" )
	{
		$cache_result = $this->cache_manager->check($pagename,$namespace);
		if( $cache_result == "hit" )
		{
			return $this->cache_manager->load($pagename,$namespace);
		}
	}

	$page_data = new PageData();
	$this->wiki_db->load( $page_data,$pagename,$namespace );
	
	if( $this->auth->check_target_page_permission($page_data,"read") )
	{
		$this->base_template_data['WORD']      = urlencode( $word );
		$this->base_template_data['NUMBER']    = $number;
		$this->base_template_data['PAGE_PATH'] = $this->page_path($pagename,$namespace);
		$main  = join( "\n",$this->wiki_renderer->process($page_data,$word,$number) );
		$title = $pagename;
		return $this->call_smarty( $main,$title );
	}
	return $this->render_login_page($pagename,$namespace,"read");
}

//////////////////////////////////////////
// Խڡ
function render_edit_page( $pagename,$namespace )
{
	$page_data = new PageData();
	$this->wiki_db->load( $page_data,$pagename,$namespace );
	
	if( $this->auth->check_target_page_permission($page_data,"edit") )
	{
		$this->base_template_data['PAGE_PATH'] = $this->page_path($pagename,$namespace);
		
		$form_data = array();
		$form_data['PAGE_NAME']  = $page_data->data['name'];
		$form_data['NAME_SPACE'] = $page_data->data['name_space'];
		$form_data['TIMESTAMP']  = $page_data->data['last_modify'];
		$form_data['INDEX_NAME'] = $page_data->data['index_name'];
		$form_data['ROW_TEXT']   = join("\n",$page_data->data['body']);
		
		$main  = $this->system_menu_renderer->page_edit_form($form_data);
		$title = $pagename;
		return $this->call_smarty( $main,$title );
	}
	return $this->render_login_page($page_name,$name_space,"read");
}

//////////////////////////////////////////
// ڡ̥
function render_create_page( $pagename,$namespace )
{
	$form_data = array();
	$form_data['PAGE_NAME']  = $pagename;
	$form_data['NAME_SPACE'] = $namespace;
	$form_data['NS_SELECT_LIST'] = $this->wiki_db->get_namespace_list($namespace);
	
	$html  = $this->system_menu_renderer->page_create_form($form_data);
	$title = $this->message_manager->get('TITLE_PAGE_CREATE');
	return $this->call_smarty( $html,$title );
}


//////////////////////////////////////////
// ƽ̤
function render_post_result( &$post )
{
	$pagename  = $this->core->process_status['pagename'] = WikiCommonLib::convert_control_char($post['page_name']);
	$namespace = $this->base_template_data['NS'] = $this->core->process_status['namespace']  = WikiCommonLib::convert_control_char($post['name_space']);
	
	$this->base_template_data['MD'] = "read";
	$this->base_template_data['PG'] = urlencode($pagename);
	$this->base_template_data['NS'] = urlencode($namespace);
	
	list($pagename,$namespace) = $this->regulate_input_name( $pagename ,$namespace );
	$olddata = new PageData();
	$newdata = new PageData();
	$new_page_flag = false;
	
	if($this->wiki_db->load( $olddata ,$pagename,$namespace ))
	{
		if( !$this->auth->check_target_page_permission($olddata,"edit") )
		{
			return $this->render_login_page($pagename,$namespace,"edit");
		}
		$newdata = $olddata;
	}
	else
	{
		$new_page_flag = true;
		
		if( !$this->auth->check_user_operation_permission("create") )
		{
			return $this->render_login_page($pagename,$namespace,"edit");
		}
		$newdata->data['owner'] = $this->auth->user_data->user_name;
		$newdata->data['permit_group'] = $this->config->get('default_group_user_permission');
		$newdata->data['permit_other'] = $this->config->get('default_other_user_permission');
		$newdata->data['permit_guest'] = $this->config->get('guest_user_auth_for_user_page');
	}
	
	$newdata->data['name']        = $pagename;
	$newdata->data['name_space']  = $namespace;
	$newdata->data['last_modify'] = WikiCommonLib::convert_control_char($post['timestamp']);
	$newdata->data['index_name']  = WikiCommonLib::convert_control_char($post['index_name']);
	$newdata->data['body']        = preg_split("/\r?\n/",WikiCommonLib::convert_control_char($post['edit_text']));
	
	$this->wiki_renderer->post_time_plugin_call( $newdata );
	
	if( $new_page_flag && $newdata->check_valid() != "ok" )
	{
		return;
	}
	
	if( !preg_match("/[^\r\n]/",$post['edit_text']) )
	{
		if( $new_page_flag ){ return; }
		
		//оݥڡ
		$delete_result = $this->wiki_db->delete_page( $newdata );
		$html  = $this->message_manager->get('MESSAGE_DELETE_SUCESS');
		$title = $this->message_manager->get('TITLE_DELETE_PROCESS');
		return $this->call_smarty( $main,$title );
		
	}
	else
	{
		//оݥڡ¸
		
		$save_result = $this->wiki_db->save($newdata);
		
		if( $save_result == "modifyed" )
		{
			$diff = new WikiDiff();
			$patch = $diff->compare( preg_split("/\r?\n/",WikiCommonLib::convert_control_char($post['old_text'])),$newdata->data['body']);
			$olddata->data['body'] = $diff->patch( $olddata->data['body'],$patch );
			
			$this->wiki_db->save($olddata);
		}
		
		return $this->render_normal_page($newdata->data['name'],$newdata->data['name_space']);
	}
	
}

//////////////////////////////////////////
// ڡ
function render_page_list( $namespace )
{
	$this->base_template_data['MD']        = "list";
	$this->base_template_data['NS']        = urlencode( $namespace );
	$this->base_template_data['NAME_SPACE'] = $namespace;

	$list_page_url = WikiCommonLib::make_myself_url("list","",$namespace);
	$list_data = $this->wiki_db->get_page_list( $namespace );
	$html  = $this->list_renderer->render( $list_data,$list_page_url);
	$title = $this->message_manager->get('TITLE_PAGE_LIST');
	
	return $this->call_smarty( $html,$title );
}

//////////////////////////////////////////
// 
function render_history_list( $pagename,$namespace )
{
	$list_data = $this->wiki_db->get_history_list( $pagename,$namespace );
	$html  = $this->render_history_list_data( $pagename,$namespace,$list_data );
	$title = $this->message_manager->get('TITLE_HISTORY_LIST');
	return $this->call_smarty( $html,$title );
}

//////////////////////////////////////////
// ꥹHTML
function render_history_list_data($pagename,$namespace,&$list_data)
{
	$list_data = array_reverse($list_data);
	$html_data = "<ol>";
	for($i=0;$i<count($list_data);$i++){
		
		$str =  date("Y-m-d (D) H:i:s",$list_data[$i]);
		$html_data .= "<li>". WikiCommonLib::make_link_html($str,"read_history",$pagename,$namespace,"","ts=".$list_data[$i]). "</li>\n";
	}
	$html_data .= "</ol>";
	return $html_data;
}

//////////////////////////////////////////
// ڡɽ
function render_history_page($timestamp,$pagename,$namespace="")
{
	$now_data = new PageData();
	$this->wiki_db->load_header( $now_data,$pagename,$namespace );
	
	if( $this->auth->check_target_page_permission($now_data,"read") )
	{
		$history_data = new PageData();
		$this->wiki_db->load_history_data( $history_data,$pagename,$namespace,$timestamp );
		$this->base_template_data['MD']        = "read";
		$this->base_template_data['PG']        = urlencode( $pagename );
		$this->base_template_data['NS']        = urlencode( $namespace );
		$this->base_template_data['PAGE_NAME'] = $pagename;
		$this->base_template_data['NAME_SPACE'] = $namespace;
		$this->base_template_data['NUMBER']    = $number;
		$this->base_template_data['PAGE_PATH'] = $this->page_path($pagename,$namespace);
		$main  = join( "\n",$this->wiki_renderer->process($history_data) );
		$title = $pagename;
		return $this->call_smarty( $main,$title );
	}
	return $this->render_login_page($pagename,$namespace,"read");

}


//////////////////////////////////////////
// ɽ
function render_search_form_page( $standard_namespace="" )
{
	$namespace_list = $this->wiki_db->get_namespace_list($standard_namespace);
	$title = $this->message_manager->get( 'TITLE_SEARCH_FORM' );
	$html  = $this->system_menu_renderer->search_form($namespace_list);
	return $this->call_smarty( $html,$title );
}

//////////////////////////////////////////
// ʸɽ
function render_grep_result( $word,$name_space="" )
{
	if( $word == "" )
	{
		return $this->render_search_form_page($name_space);
	}
	
	$this->base_template_data['MD']        = "read";
	$this->base_template_data['PG']        = urlencode( $pagename );
	$this->base_template_data['NS']        = urlencode( $namespace );
	$this->base_template_data['PAGE_NAME'] = $pagename;
	$this->base_template_data['NAME_SPACE'] = $namespace;

	$display_data = array();
	$grep_result  = array();
	
	if( strlen($word) > 1 )
	{
		$grep_result    = $this->wiki_db->grep($word,$name_space);
	}
	
	$namespace_list = $this->wiki_db->get_namespace_list($name_space);
	$search_form    = $this->system_menu_renderer->search_form($namespace_list,$word);

	array_push($display_data,$search_form);
	array_push($display_data,"".count($grep_result)."ҥåȤޤ<br />");
	array_push($display_data,"<ol>");
	for( $i=0;$i<count($grep_result);$i++ )
	{
		$display_link_text = WikiCommonLib::marge_namespace($grep_result[$i]['namespace'],$grep_result[$i]['pagename']) . "".$grep_result[$i]['number']."";
		$url = $_SERVER['PHP_SELF']."?md=read&amp;word=".urlencode($word)."&amp;number=".$grep_result[$i]['number']."&amp;pg=".urlencode($grep_result[$i]['pagename'])."&amp;ns=".urlencode($grep_result[$i]['namespace'])."#point";
		
		$link_text = "<a href=\"".$url."\">" . $display_link_text ."</a>";
		$view_text = preg_replace("/$word/i","<span class=\"point\">$word</span>",$grep_result[$i]['text']);
		
		array_push($display_data,"<li>");
		array_push($display_data,"$link_text");
		array_push($display_data,"<blockquote class=\"depth1\">$view_text</blockquote>");
		array_push($display_data,"</li>");
	}
	array_push($display_data,"</ol>");
	
	$title = $this->message_manager->get( 'TITLE_SEARCH_FORM' );
	$html  = join("\n",$display_data);
	return $this->call_smarty( $html,$title );
}



//////////////////////////////////////////
// ץ饰ƽ
function call_plugin($pagename,$namespace,$plugin_name,&$post_array)
{
	/*
	  $_POST['page_name'], $_POST['name_space'] ϥץ饰
	  ɤ߹ޤڡˤʤޤ(ƥץ饰ϤΤȤƧޤ
	  POSTǡμԤäƤ)
	  ޤ $_POST['pg'], $_POST[ns'] ץ饰ǽڡ
	  ˤʤޤ(âΰϳƥץ饰˰ޤ)
	*/
	if(isset($post_array['page_name'])){
		$pagename  =
		  WikiCommonLib::convert_control_char($post_array['page_name']);
	}
	if(isset($post_array['name_space'])){
		$namespace =
		  WikiCommonLib::convert_control_char($post_array['name_space']);
	}
	
	$olddata  = new PageData();
	//if($this->wiki_db->load_header( $olddata ,$pagename,$namespace ))
	if($this->wiki_db->load( $olddata ,$pagename,$namespace ))
	{
		if( $this->auth->check_target_page_permission($olddata,"plugin") )
		{
			$result = $this->plugin_manager->call_post_handler_function($plugin_name,$olddata,$post_array);
			if($result == "ok")
			{
				return $this->render_normal_page( $pagename,$namespace );
				exit;
			}
		}
		return $this->render_login_page( $page_name,$name_space,"read" );
	}
	
}


//////////////////////////////////////////
// Ϥ줿̾ǡ
function regulate_input_name( $pagename ,$namespace )
{
	$namespace = preg_replace("/\/{2,}/","/",$namespace);
	$pagename  = preg_replace("/\/{2,}/","",$pagename);
	$namespace = preg_replace("/^\//","",$namespace);
	$pagename  = preg_replace("/^\//","",$pagename);
	
	$namedata = WikiCommonLib::marge_namespace( $namespace,$pagename );
	
	if( preg_match("/(.*?)\/([^\/]*)$/",$namedata,$match_data) )
	{
		return array( $match_data[2],$match_data[1] );
	}
	else
	{
		return array( $namedata ,"" );
	}
}


//////////////////////////////////////////
// ѡߥå
function process_permission_manager( &$request )
{
	$sub_mode = $request['sub_mode'];
	
	$html = "";
	$title = $this->message_manager->get('TITLE_PERMISSION');
	
	$data_obj = "";
	$namespace_flag = false;
	if( $request['pg_mode'] )
	{
		$data_obj = new PageData();
		$this->wiki_db->load($data_obj,$request['pg'],$request['ns']);
	}
	else
	{
		$namespace_flag = true;
		$data_obj = new NamespaceData();
		$this->wiki_db->load_namespace($data_obj,$request['ns']);
	}
	
	switch( $sub_mode )
	{
	
	case('delete'):
		$html = $this->system_menu_renderer->delete_dialog_form( $data_obj,$namespace_flag );
		break;
	
	case('delete_post'):
		if( $namespace_flag )
		{
			if($this->wiki_db->delete_namespace( $request['ns'] ))
			{
				$html  = $this->message_manager->get('MESSAGE_NAMESPACE_DELETE_SUCESS');
			}
		}
		else
		{
			if($this->wiki_db->delete_page( $data_obj ))
			{
				$html  = $this->message_manager->get('MESSAGE_DELETE_SUCESS');
			}
		}
		
		
		break;
	
	case('chmod'):
		$data_obj->data['permit_group'] = $this->join_permission_str($request['group']);
		$data_obj->data['permit_guest'] = $this->join_permission_str($request['guest']);
		$data_obj->data['permit_other'] = $this->join_permission_str($request['other']);
		
		if( $namespace_flag )
		{
			$this->wiki_db->make_namespace($data_obj);
			$html = $this->system_menu_renderer->permission_form( $data_obj,"namespace" );
		}
		else
		{
			$this->wiki_db->save($data_obj);
			$html = $this->system_menu_renderer->permission_form( $data_obj );
		}
		break;
	
	default:
		if( $namespace_flag )
		{
			$html = $this->system_menu_renderer->permission_form( $data_obj,"namespace" );
		}
		else
		{
			$html = $this->system_menu_renderer->permission_form( $data_obj );
		}
		break;
		
	}
	
	return $this->call_smarty( $html ,$title );
}

//////////////////////////////////////////
// ѡߥåʸ
function join_permission_str( $data_array )
{
	$str = "";
	while(list($key_name,$value)= each($data_array) )
	{
		if($value == "true")
		{
			$str .= $key_name .",";
		}
	}
	return preg_replace("/\,$/","",$str);
}

//////////////////////////////////////////
// ե
function process_file_manager( &$postdata )
{
	require_once( 'Wiki/SystemMenuRenderer.php' );
	require_once( 'Wiki/FileManager.php' );
	$system_renderer = new SystemMenuRenderer( $this->config );
	$file_manager    = new FileManager( $this->config ); 
	
	$sub_mode = $postdata['smd'];
	$html  = "";
	$title = $this->message_manager->get('TITLE_FILE_MANAGER');
	
	switch( $sub_mode )
	{
	case('upload'):
		if($file_manager->upload('upload'))
		{
			$file_list = $file_manager->get_relative_file_list();
			$html = $system_renderer->upload_form($file_list,$this->message_manager->get('MESSAGE_UPLOAD_SUCCESS'));
		}
		else
		{
			$file_list = $file_manager->get_relative_file_list();
			$html = $system_renderer->upload_form($file_list,$this->message_manager->get('ERROR_UPLOAD_FAIL'));
		}
		break;
	
	case('delete'):
		if($file_manager->delete_file($postdata['image_select']))
		{
			$file_list = $file_manager->get_relative_file_list();
			$html = $system_renderer->upload_form($file_list,$this->message_manager->get('MESSAGE_FILE_DELETE_SUCCESS'));
		}
		else
		{
			$file_list = $file_manager->get_relative_file_list();
			$html = $system_renderer->upload_form($file_list,$this->message_manager->get('MESSAGE_FILE_DELETE_ERROR'));
		}
		break;
	
	
	default:
		$file_list = $file_manager->get_relative_file_list();
		$html = $system_renderer->upload_form($file_list);
		break;
	}
	
	return $this->call_smarty( $html,$title );

}


//////////////////////////////////////////
// ڡѥ
function page_path($pagename,$namespace)
{
	$path_html = "";
	$path_array = split("/",$namespace);
	
	if( $namespace )
	{
		$path_html .= "<a href=\"".WikiCommonLib::make_myself_url("read","","")."\">/</a>";
	}
	
	for( $i=0;$i<count($path_array);$i++ )
	{
		$path_html .= "<a href=\"".WikiCommonLib::make_myself_url("read","",join("/",array_slice($path_array,0,$i+1)))."\">".$path_array[$i]."</a>";
		$path_html .= "<a href=\"".WikiCommonLib::make_myself_url("list","",join("/",array_slice($path_array,0,$i+1)))."\">/</a>";
	}
	
	if("" != $pagename )
	{
		$path_html .= "<a href=\"".WikiCommonLib::make_myself_url("read",$pagename,$namespace)."\">".$pagename."</a>";
	}
	return $path_html;
}


//////////////////////////////////////////
// Smarty¹
function call_smarty( $main,$title )
{
	$this->base_template_data['PAGE_TITLE'] = $title;
	
	$this->smarty->assign('DATA',$this->base_template_data );
	$this->smarty->assign('USER_DATA',$this->auth->user_data );
	$this->smarty->assign('CONFIG',$this->config->data );
	$this->smarty->assign('MAIN_BODY',$main );
	$this->smarty->assign('SIDE_MENU',$this->render_side_menu($this->config->data['side_menu_page']) );
	
	if( $this->config->data['side_menu_page2'] != "" )
	{
		$this->smarty->assign('SIDE_MENU2',$this->render_side_menu($this->config->data['side_menu_page2']) );
	}
	
	return $this->smarty->fetch( $this->use_template_name."/wiki.html" );
}

//////////////////////////////////////////
// ɥ˥塼
function render_side_menu( $side_menu_name )
{
	$page_data = new PageData();
	if( $this->wiki_db->load($page_data,$side_menu_name,"") )
	{
		if( $this->auth->check_target_page_permission($page_data,"read") )
		{
			return join("\n",$this->wiki_renderer->process($page_data));
		}
	}
}




}

?>
