<?php
/*----------------------------------------------------

  PluginManagerClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/BasicDefinition.php' );

class PluginManager
{

var $core;
var $config;
var $wiki_db;
var $auth;

//////////////////////////////////////////
// 󥹥ȥ饯
function PluginManager( &$core,&$config_obj )
{
	$this->core    = &$core;
	$this->config  = &$config_obj;
	$this->wiki_db = "";
}

//////////////////////////////////////////
// ǡ١ǽ
function database_connection_initialize()
{
	$db_plugin_name = $this->config->get('db_plugin_name');

	if( $this->load_plugin( $db_plugin_name ) )
	{
		$this->wiki_db = new $db_plugin_name( $this->config );
		return true;
	}
	return false;
}

//////////////////////////////////////////
// ץ饰ե̾μ
function get_plugin_filename( $plugin_name )
{
	return $this->config->get('plugin_dir') ."/". $plugin_name .".plugin.php";
}

//////////////////////////////////////////
// ץ饰¸ߥå
function check_plugin_exists( $plugin_name )
{
	return is_file( $this->get_plugin_filename( $plugin_name ) );
}

//////////////////////////////////////////
// оݥץ饰ɤ߹
function load_plugin( $plugin_name )
{
	if($this->check_plugin_exists($plugin_name))
	{
		$plugin_filename = $this->get_plugin_filename($plugin_name);
		require_once( $plugin_filename );
		return true;
	}
	return false;
}

//////////////////////////////////////////
// ץ饰ƤӽФɽʬ̾ȰФ
function get_plugin_call_data($call_text,&$name,&$number_array)
{
	if( preg_match("/(?:\#|\&amp\;)([A-Za-z0-9\_]+)(.*)/",$call_text,$hitdata ))
	{
		$name = $hitdata[1];
		if(preg_match("/(?<!".ESCAPE_CODE.")\((.+)(?<!".ESCAPE_CODE.")\)/",$hitdata[2],$hit_number))
		{
			$number_array = preg_split("/(?<!".ESCAPE_CODE.")\,/",$hit_number[1]);
			for($i=0;$i<count($number_array);$i++)
			{
				$number_array[$i] = preg_replace("/(?<=".ESCAPE_CODE.")\,/",",",$number_array[$i]);
				$number_array[$i] = trim($number_array[$i]);
			}
		}
	}
}

//////////////////////////////////////////
// ץץƤӽФ
function call_preprocess_function( &$wiki_renderer,$line_num ,&$row_line_array )
{
	$plugin_name = "";
	$argument    = array();
	
	$this->get_plugin_call_data($row_line_array[$line_num],$plugin_name,$argument);
	
	if( $plugin_name )
	{
		if( $this->load_plugin($plugin_name) )
		{
			$plugin_obj = new $plugin_name($this->core,$this->config,$this->wiki_db);
			return $plugin_obj->preprocess_function( $wiki_renderer,$line_num ,$row_line_array,$argument );
		}
	}
	return false;
}


//////////////////////////////////////////
// ¹Իץ饰ǽCALL
function call_runtime_function($line_number,&$row_line_array,&$add_line_array,&$page_data)
{
	$plugin_name = "";
	$argument_array = array();
	$this->get_plugin_call_data($row_line_array[$line_number],$plugin_name,$argument_array);
	
	if( $this->load_plugin($plugin_name) )
	{
		$plugin_obj = new $plugin_name($this->core,$this->config,$this->wiki_db);
		$add_line_array[] = $plugin_obj->runtime_function($line_number,$row_line_array,$argument_array,$page_data);
		return true;
	}
	$add_line_array[] = "<span class='nopage'>Runtime Error : can't load &quot;${plugin_name}&quot; plug-in</span>";
	return false;
}

//////////////////////////////////////////
// ¹Ի饤ץ饰ǽCALL
function call_runtime_inline_function( $command )
{
	$plugin_name = "";
	$argument_array = array();
	$this->get_plugin_call_data($command,$plugin_name,$argument_array);
	
	if( $this->load_plugin($plugin_name) )
	{
		$plugin_obj = new $plugin_name( $this->core,$this->config,$this->wiki_db );
		return $plugin_obj->runtime_inline_function( $argument_array );
	}
	return "<span class='nopage'>Runtime Error : can't load &quot;${plugin_name}&quot; plug-in</span>";
}

//////////////////////////////////////////
// ƻִ
function call_text_replace_function( $command )
{
	$plugin_name = "";
	$argument_array = array();
	$this->get_plugin_call_data($command,$plugin_name,$argument_array);
	
	if( $this->load_plugin($plugin_name) )
	{
		$plugin_obj = new $plugin_name( $this->core,$this->config,$this->wiki_db );
		$replace_text = "";
		if( $plugin_obj->text_replace_function($argument_array,$replace_text) )
		{
			return $replace_text;
		}
	}
	return $command;
}
//////////////////////////////////////////
// ץ饰ƽ
function call_post_handler_function(
  $plugin_name,&$page_data,&$post_data_array,$rendering_html=null
){
	if( $plugin_name )
	{
		if( $this->load_plugin($plugin_name) )
		{
			reset($post_data_array);
			$escaped_data = WikiCommonLib::convert_control_char_in_array($post_data_array);
			$plugin_obj = new $plugin_name($this->core,$this->config,$this->wiki_db);
			return $plugin_obj->post_handler_function( $page_data,$escaped_data ,&$rendering_html);
		}
	}
	return "error";

}





}


?>
