<?php  //$Id: upgrade.php,v 1.2 2007/08/08 22:36:54 stronk7 Exp $
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

// This file keeps track of upgrades to the mplayer module
//
// The commands in here will all be database-neutral, using the functions defined in lib/ddllib.php

function xmldb_mplayer_upgrade($oldversion=0) {

// edit by Codia (2013/05/31)
    global $CFG, $THEME, $DB;
// end

    $result = true;

	//if ($result && $oldversion < 2009112500) { //New version in version.php
	//     $result = result of "/lib/ddllib.php" function calls
	//}

/// For each upgrade block, the file mplayer/version.php

/// To know more about how to write correct DB upgrade scripts it's
/// highly recommended to read information available at:
///   http://docs.moodle.org/en/Development:XMLDB_Documentation
/// and to play with the XMLDB Editor (in the admin menu) and its
/// PHP generation posibilities.

/// First example, some fields were added to the module on 20090900
    /*if ($result && $oldversion < 2009012800) {

    /// Define field course to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $field = new XMLDBField('course');
        $field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'id');
    /// Launch add field course
        $result = $result && add_field($table, $field);

    /// Define field intro to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $field = new XMLDBField('intro');
        $field->setAttributes(XMLDB_TYPE_TEXT, 'medium', null, null, null, null, null, null, 'name');
    /// Launch add field intro
        $result = $result && add_field($table, $field);

    /// Define field introformat to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $field = new XMLDBField('introformat');
        $field->setAttributes(XMLDB_TYPE_INTEGER, '4', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'intro');
    /// Launch add field introformat
        $result = $result && add_field($table, $field);
    }*/

/// Second example, some hours later, the same day 20090901
/// two more fields and one index were added (note the increment
/// "01" in the last two digits of the version
    /*if ($result && $oldversion < 2009012801) {

    /// Define field timecreated to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $field = new XMLDBField('timecreated');
        $field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'introformat');
    /// Launch add field timecreated
        $result = $result && add_field($table, $field);

    /// Define field timemodified to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $field = new XMLDBField('timemodified');
        $field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'timecreated');
    /// Launch add field timemodified
        $result = $result && add_field($table, $field);

    /// Define index course (not unique) to be added to mplayer
        $table = new XMLDBTable('mplayer');
        $index = new XMLDBIndex('course');
        $index->setAttributes(XMLDB_INDEX_NOTUNIQUE, array('course'));
    /// Launch add index course
        $result = $result && add_index($table, $index);
    }

/// Third example, the next day, 20090128 (with the trailing 00), some inserts were performed, related with the module
    if ($result && $oldversion < 2009012800) {
    /// Add some actions to get them properly displayed in the logs
        $rec = new stdClass;
        $rec->module = 'mplayer';
        $rec->action = 'add';
        $rec->mtable = 'mplayer';
        $rec->filed  = 'name';
    /// Insert the add action in log_display
        $result = insert_record('log_display', $rec);
    /// Now the update action
        $rec->action = 'update';
        $result = insert_record('log_display', $rec);
    /// Now the view action
        $rec->action = 'view';
        $result = insert_record('log_display', $rec);
    }*/


// edit by Codia (2013/05/31)
    // 管理テーブルがない場合は行わない
    if(!array_key_exists('local_ties_modules', $DB->get_tables())){
        return true;
    }

    // モジュール管理テーブル更新
    require(dirname(__FILE__) . '/../version.php');
    if(!empty($plugin->version)){
        $version = $plugin->version;
    }else if(!empty($module->version)){
        $version = $module->version;
    }
    if(!empty($module->dispversion)){
        $dispversion = $module->dispversion;
    }else if(!empty($plugin->dispversion)){
        $dispversion = $plugin->dispversion;
    }
    $module_result = $DB->get_records_select("local_ties_modules", "name = ?", array('mplayer'));
    if(empty($module_result)) {
        $module_info               = new stdClass();
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $module_info->name         = "mplayer";
        $DB->insert_record('local_ties_modules', $module_info);
    }else{
        $module_info               = reset($module_result);
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $DB->update_record('local_ties_modules', $module_info);
    }
// end
	
	return $result;
}
?>
