/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn_winmm.c
        Copyright (c) 2003 Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c

*/

#ifdef HAVE_CONFIG_H
#include "timip_config.h"
#endif /* HAVE_CONFIG_H */
#include "timip_interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef	TIMIP_HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef	TIMIP_TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "timip_server_defs.h"

#ifdef TIMIP___W32__
#include <windows.h>
#include <mmsystem.h>
#endif

#include "timip_timidity.h"
#include "timip_common.h"
#include "timip_controls.h"
#include "timip_instrum.h"
#include "timip_playmidi.h"
#include "timip_readmidi.h"
#include "timip_recache.h"
#include "timip_output.h"
#include "timip_aq.h"
#include "timip_timer.h"

#include "timip_rtsyn.h"

int timip_rtsyn_portnumber=1;
unsigned int timip_portID[MAX_PORT];
char timip_rtsyn_portlist[32][80];
int timip_rtsyn_nportlist;

#define MAX_EXBUF 20
#define BUFF_SIZE 512

UINT timip_InNum;
HMIDIIN  timip_hMidiIn[MAX_PORT];
HMIDIOUT timip_hMidiOut[MAX_PORT];
MIDIHDR *timip_IMidiHdr[MAX_PORT][MAX_EXBUF];

char timip_sIMidiHdr[MAX_PORT][MAX_EXBUF][sizeof(MIDIHDR)];
char timip_sImidiHdr_data[MAX_PORT][MAX_EXBUF][BUFF_SIZE];

struct evbuf_t{
	int status;
	UINT wMsg;
	DWORD	dwInstance;
	DWORD	dwParam1;
	DWORD	dwParam2;
};
#define EVBUFF_SIZE 512
struct evbuf_t timip_evbuf[EVBUFF_SIZE];
UINT  timip_evbwpoint=0;
UINT  timip_evbrpoint=0;
UINT timip_evbsysexpoint;
UINT  timip_mvbuse=0;
enum{B_OK, B_WORK, B_END};

void CALLBACK timip_MidiInProc(HMIDIIN,UINT,DWORD,DWORD,DWORD);

void timip_rtsyn_get_port_list(){
	int i;
	MIDIINCAPS InCaps;
	timip_InNum = midiInGetNumDevs();
	for (i=1;i <=timip_InNum && i<=32;i++){
		midiInGetDevCaps(i-1,(LPMIDIINCAPSA) &InCaps,sizeof(InCaps));
		sprintf(timip_rtsyn_portlist[i-1],"%d:%s",i,(LPSTR)InCaps.szPname);
	}
	timip_rtsyn_nportlist=i-1;
}

int timip_rtsyn_synth_start(){
	int i;
	UINT port;
	MidiEvent timip_ev;
#ifdef TIMIP___W32__
	DWORD processPriority;
	processPriority = GetPriorityClass(GetCurrentProcess());
#endif

	timip_rtsyn_reset();
	timip_rtsyn_system_mode=DEFAULT_SYSTEM_MODE;
	timip_change_system_mode(timip_rtsyn_system_mode);
	timip_ev.type=ME_RESET;
	timip_ev.a=GS_SYSTEM_MODE; //GM is mor better ???
	timip_rtsyn_play_event(&timip_ev);
	
	port=0;

	for(port=0;port<timip_rtsyn_portnumber;port++){
		for (i=0;i<MAX_EXBUF;i++){
			timip_IMidiHdr[port][i] = (MIDIHDR *)timip_sIMidiHdr[port][i];
			memset(timip_IMidiHdr[port][i],0,sizeof(MIDIHDR));
			timip_IMidiHdr[port][i]->lpData = timip_sImidiHdr_data[port][i];
			memset((timip_IMidiHdr[port][i]->lpData),0,BUFF_SIZE);
			timip_IMidiHdr[port][i]->dwBufferLength = BUFF_SIZE;
		}
	}
	timip_evbuf[0].status=B_END;
	timip_evbwpoint=0;
	timip_evbrpoint=0;
	timip_mvbuse=0;

	for(port=0;port<timip_rtsyn_portnumber;port++){
		midiInOpen(&timip_hMidiIn[port],timip_portID[port],(DWORD)timip_MidiInProc,(DWORD)port,CALLBACK_FUNCTION);
		for (i=0;i<MAX_EXBUF;i++){
			midiInUnprepareHeader(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
			midiInPrepareHeader(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
			midiInAddBuffer(timip_hMidiIn[port],timip_IMidiHdr[port][i],sizeof(MIDIHDR));
		}
	}

#ifdef TIMIP___W32__
	// HACK:midiInOpen()ŃZbgĂ܂߁AĐݒ
	SetPriorityClass(GetCurrentProcess(), processPriority);
#endif

	for(port=0;port<timip_rtsyn_portnumber;port++){
		if(MMSYSERR_NOERROR !=midiInStart(timip_hMidiIn[port])){
			int i;
			for(i=0;i<port;i++){
				midiInStop(timip_hMidiIn[i]);
				midiInReset(timip_hMidiIn[i]);
				midiInClose(timip_hMidiIn[i]);
			}
			goto winmmerror;
		}
	}

	return ~0;

winmmerror:
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "midiInStarterror\n" );
	return 0;
}

void timip_rtsyn_synth_stop(){
	timip_rtsyn_stop_playing();
	//	timip_play_mode->close_output();
	timip_rtsyn_midiports_close();

	return;
}
void timip_rtsyn_midiports_close(void){
	UINT port;
	
	for(port=0;port<timip_rtsyn_portnumber;port++){
		if( MMSYSERR_NOERROR!=midiInStop(timip_hMidiIn[port]) )
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Stop Error\n");
		if( MMSYSERR_NOERROR!=midiInReset(timip_hMidiIn[port]) ) 
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Rest Error\n");
		if( MMSYSERR_NOERROR!=midiInClose(timip_hMidiIn[port]) ) 
			timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIDI Close Error\n");
	}
}

int timip_rtsyn_buf_check(void){
	if( (timip_evbuf[timip_evbrpoint].status==B_OK)&&(timip_evbrpoint!=timip_evbwpoint) ){
		return ~0;
	}else{
		return 0;
	}
}

int timip_rtsyn_play_some_data(void){
	UINT wMsg;
	DWORD	dwInstance;
	DWORD	dwParam1;
	DWORD	dwParam2;
	MidiEvent timip_ev;
	MidiEvent evm[260];
	int port;
	UINT evbpoint;
	MIDIHDR *IIMidiHdr;
	int exlen;
	char *sysexbuffer;
	int ne,i,j,chk,played;
	
	played=0;
#ifndef USE_WINSYN_TIMER_I
	do{
		Sleep(1);
#endif
		if( !(timip_evbuf[timip_evbrpoint].status==B_OK)&&(timip_evbrpoint!=timip_evbwpoint) ) played=~0;
		while( (timip_evbuf[timip_evbrpoint].status==B_OK)&&(timip_evbrpoint!=timip_evbwpoint) ){

			evbpoint=timip_evbrpoint;
			if (++timip_evbrpoint >= EVBUFF_SIZE)
					timip_evbrpoint -= EVBUFF_SIZE;

			wMsg=timip_evbuf[evbpoint].wMsg;
			dwInstance=timip_evbuf[evbpoint].dwInstance;
			dwParam1=timip_evbuf[evbpoint].dwParam1;
			dwParam2=timip_evbuf[evbpoint].dwParam2;

			port=(UINT)dwInstance;
			switch (wMsg) {
			case MIM_DATA:
				timip_rtsyn_play_one_data (port, dwParam1);
				break;
			case MIM_LONGDATA:
				IIMidiHdr = (MIDIHDR *) dwParam1;
				exlen=(int)IIMidiHdr->dwBytesRecorded;
				sysexbuffer=IIMidiHdr->lpData;
				timip_rtsyn_play_one_sysex (sysexbuffer,exlen );
				if (MMSYSERR_NOERROR != midiInUnprepareHeader(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error1\n");
				if (MMSYSERR_NOERROR != midiInPrepareHeader(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error5\n");
				if (MMSYSERR_NOERROR != midiInAddBuffer(
						timip_hMidiIn[port], IIMidiHdr, sizeof(MIDIHDR)))
					timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"error6\n");
				break;
			}
		}	
#ifndef USE_WINSYN_TIMER_I
	}while(timip_rtsyn_reachtime>timip_get_current_calender_time());
#endif 
	return played;
}

void CALLBACK timip_MidiInProc(HMIDIIN hMidiInL, UINT wMsg, DWORD dwInstance,
		DWORD dwParam1, DWORD dwParam2)
{
	UINT evbpoint;
	UINT port;
	
	port=(UINT)dwInstance;
	switch (wMsg) {
	case MIM_DATA:
	case MIM_LONGDATA:
		evbpoint = timip_evbwpoint;
		if (++timip_evbwpoint >= EVBUFF_SIZE)
			timip_evbwpoint -= EVBUFF_SIZE;
		timip_evbuf[timip_evbwpoint].status = B_END;
		timip_evbuf[evbpoint].status = B_WORK;
		timip_evbuf[evbpoint].wMsg = wMsg;
		timip_evbuf[evbpoint].dwInstance = dwInstance;
		timip_evbuf[evbpoint].dwParam1 = dwParam1;
		timip_evbuf[evbpoint].dwParam2 = dwParam2;
		timip_evbuf[evbpoint].status = B_OK;
		break;
	case MIM_OPEN:
//		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_OPEN\n");
		break;
	case MIM_CLOSE:
//		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_CLOSE\n");
		break;
	case MIM_LONGERROR:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_LONGERROR\n");
		break;
	case MIM_ERROR:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_ERROR\n");
		break;
	case MIM_MOREDATA:
		timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL,"MIM_MOREDATA\n");
		break;
	}
}
