/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMIP_VT100_H_
#define __TIMIP_VT100_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

#define VT100_COLS 80
#define VT100_ROWS 24

#define VT100_ATTR_UNDERLINE	000000400000
#define VT100_ATTR_REVERSE	000001000000
#define VT100_ATTR_BOLD		000010000000

/* vt100 utility functions */
extern void timip_vt100_init_screen(void);
extern void timip_vt100_refresh(void);
extern void timip_vt100_clrtoeol(void);
extern void timip_vt100_move(int row, int col);
extern void timip_vt100_set_attr(int attr);
extern void timip_vt100_reset_attr(void);

#endif /* __TIMIP_VT100_H_ */
