# $Id: diceTree.rb,v 1.1.1.1 2002/09/10 12:07:22 ray_aero Exp $

=begin
ĥ꡼饹

TODO
=end

require 'dice'

class DiceTree

  class DiceTreeException < StandardError; end

  DICE, PAREN = "D", "()"
  ADD, SUB, MUL, DIV = "+", "-", "*", "/"
  POW, MOD = "^", "%"

  Type = Array.new.push( DICE, PAREN, ADD, SUB, MUL, DIV, POW, MOD ).freeze

  def initialize( op, left, right = nil, separater = " " )
    raise( DiceTreeException, "Op type error" ) unless Type.include?( op )
    raise( DiceTreeException, "Left !=== DiceTree or Numeric" ) if ( left and !( DiceTree === left or Numeric === left ) )
    raise( DiceTreeException, "Right !=== DiceTree or Numeric" ) if ( right and !( DiceTree === right or Numeric === right ) )
    @op = op
    @left = left
    @right = right
    @diceres = nil
    @separater = separater
  end
  attr_reader( :op, :left, :right, :diceres )
  attr_accessor( :separater )

=begin
return dice equation expand result( replace DICE value if call with block )
 depth : expand level ( counts paren and dice operator )
         if nil then expand all level ( same as 'to_i' )
         >0 : counts dice op only.
         <0 : counts paren and dice op.
 dproc : replace DICE type result with block eval value if given
         dproc args are 'total diceres, depth, lres, rres'
         total   : dice roll total value
         diceres : Dice::DiceResult
         depth   : call-timing's depth value
         lres    : @left expand result
         rres    : @right expand result
     *** if block returns nil then the 'expand' returns total ***
 results : [ level:Integer, value:String or Integer ]
   level : expandable level ( for recursive call )
   value : full expand -> Integer, else -> String
=end
  def expand( depth = nil, &dproc )
    (ld, lr), (rd, rr) = ctree_do( [ [depth, @left], [depth, @right] ] ){
      |x| x.expand( depth, &dproc ) # recursive
    }

    if depth
      depth = ( ld.abs < rd.abs ? ld : rd ) # depth = absmin( ld, rd )
      if @op == DICE and depth != 0
	depth = ( depth > 0 ? depth - 1 : depth + 1 )
	bDepthChange = true # ʹߤ depth ѹΥåѤ
      elsif @op == PAREN and depth < 0
	depth += 1
	bDepthChange = true # ʹߤ depth ѹΥåѤ
      end
    end

    case
    when PAREN === @op
      if depth == 0 and !bDepthChange then lr = lr.to_s end
      if rr == -1
	ret = ( String === lr ? ( '-(' + lr + ')' ) : -lr )
      else
	ret = ( String === lr ? ( '(' + lr + ')' ) : lr )
      end
    when ( DICE === @op and block_given? )
      total = value
      ret = yield( total, @diceres, depth, lr, rr )
      ret = total unless ret # if block returns nil
    else
      if String === lr or String === rr or ( depth == 0 and !bDepthChange )
	ret = [lr.to_s, op, rr.to_s].join(@separater)
      else
	ret = value
      end
    end

    [depth, ret]
  end

  # returns dice equation calculate value
  def value()
    lr, rr = ctree_do() {|subtree| subtree.value() }

    case @op
    when PAREN
      (rr == -1) ? -lr : lr
    when DICE
      @diceres = Dice.roll( lr, rr ) unless @diceres
      @diceres.total
    when POW
      lr.__send__( '**'.intern, rr )
    else
      lr.__send__( @op.intern, rr )
    end
  end
  alias val value

  def to_int(); value().to_int(); end
  alias to_i to_int
  def to_f(); value().to_f(); end

  # return dice equation string ( literally )
  def to_s(separater = nil)
    oldsep = nil
    if separater
      oldsep = @separater
      @separater = separater
    end
    ret = case @op
	  when PAREN
	    if @right == -1
	      '-(' + @left.to_s + ')'
	    else
	      '(' + @left.to_s + ')'
	    end
	  else
	    "%s#{@separater}%s#{@separater}%s" % [ @left, @op, @right ]
	  end

    @separater = oldsep if oldsep

    ret
  end

  # returns @op's Priority as Integer
  def opPriority( op = nil )
    op = @op unless op
    case op
    when PAREN then 1
    when POW then 2
    when DICE then 3
    when MUL, DIV, MOD then 4
    when ADD, SUB then 5
    end
  end

  # validate dice equation tree( destructive function )
  def validate!( bTop = true )
    # lop, rop ... nil -> nil, false -> Numeric, TYPE -> DiceTree
    @left, @right = ctree_do{ |subtree| subtree.validate!( false ) }
    lop, rop = ctree_do( [false, ( @right.nil?() ? nil : false )] ){ |x| x.op }

    ret = self
    if @op == PAREN
      if lop == PAREN # '(( exp ))' state
	@right = ( @right == @left.right ? nil : -1 ) # sign check
	@left = @left.left
      elsif Numeric === @left # '( num )' state
	if @right == -1
	  @left = - @left
	  @right = nil
	end
	ret = @left
      end
    elsif @left == 0
      case @op
      when ADD # '0 + exp' state
	ret = @right
      when SUB # '0 - exp' state
	ret = DiceTree.new( DT::PAREN, @right, -1 ).validate!
      when MUL, DIV, MOD, POW # '0 * / % ** exp' state
	ret = 0
      end
    elsif @right == 0
      case @op
      when ADD, SUB # 'exp +- 0' state
	ret = @left
      when MUL # 'exp * 0' state
	ret = 0
      when POW # 'exp ** 0' state
	ret = 1
      end
    elsif @left == 1
      case @op
      when MUL # '1 * exp' state
	ret = @right
      when POW # '1 ** exp' state
	ret = 1
      end
    elsif @right == 1
      case @op
      when MUL, DIV, POW # 'exp * / ** 1' state
	ret = @left
      when MOD # 'exp % 1' state
	ret = 0
      end
    elsif @left == -1
      case @op
      when MUL # '-1 * exp' state
	@op = PAREN
	@left = @right
	@right = -1
	ret = validate!( false ) # including Numeric === @right
      when POW # '-1 ** exp' state
	ret = ( @right.to_i[0] == 1 ? -1 : 1 ) if (@right.dlevel == 0 and Integer === @right)
      end
    elsif @right == -1
      case @op
      when MUL, DIV # 'exp */ -1' state
	@op = PAREN
	ret = validate!( false ) # including Numeric === @left
      when POW
	@op = DIV
	@right = @left
	@left = 1
	ret = validate!( false ) # recursive
      when MOD # 'exp % -1' state
	ret = 0
      end
    end

    # self֤褦ˤʤäƤϡΤޤ޽
    return self if ret == self
    # ƵΥȥåפǤʤпƤǥ֥ȤꤵΤǡΤޤ
    return ret unless bTop

    # ƵΥȥåפξϻʤΤǼʬPARENפˤͤ@left
    # ν򤷤ʤȡƽФΥȥåפΥ֥ȤΤޤޤˤʤ
    # 㤨С(3 + 0)פΥĥ꡼ξʤɤˤʤ
    @op = PAREN
    @left = ret
    @right = nil
    return self
  end

  # non-destructive validation ( copy recursively and validate it )
  def validate()
    Marshal.load( Marshal.dump( self ) ).validate!(false)
  end

  # leaf-node check( returns 'true' if both @left and @right are non DiceTree )
  def leaf?(); not( DiceTree === @left or DiceTree === @right ); end

  # returns Dice nesting level
  def dlevel()
    l , r = ctree_do( 0 ) { |subt| subt.dlevel } # recursive

    ret = ( l < r ? r : l ) # ret == max( l, r )
    ret += 1 if @op == DICE
    ret
  end

  def to_a(); [ @left.to_a, @op, @right.to_a ]; end
  def ==( other ); DiceTree === other ? rpn == other.rpn : false; end
  def inspect(); '#<%s:0x%x exp="%s">' % [ type, id, to_s ]; end

  # returns Reverse Porland Notation array
  def rpn
    l, r = ctree_do{ |subt| subt.rpn }

    [@op == PAREN ? [(@right == -1 ? "-(" : "("),l,")"] : [l,r,@op] ].flatten!
  end

  # reroll all Dice part( recursive function )
  def reroll()
    lr, rr = ctree_do(){ |subtree| subtree.reroll.value }

    if @op == DICE then @diceres = Dice.roll( lr, rr ) end
    self
  end

  # do block if DiceTree === @left. else return arg 'ret'
  # if block is not given then return @left when DiceTree === @left
  # block has 1 arg. it is @left.
  def ltree_do( ret = @left )
    if DiceTree === @left
      if block_given?
	yield @left
      else
	@left
      end
    else
      ret
    end
  end

  # same as 'ltree_do' but using @right
  def rtree_do( ret = @right )
    if DiceTree === @right
      if block_given?
	yield @right
      else
	@right
      end
    else
      ret
    end
  end

  # 'ltree_do' and 'rtree_do' execution
  def ctree_do( ret = [@left, @right], &block )
    if Array === ret
      arr = ret.dup
      larg = arr.shift
      rarg = arr.shift
    else
      larg = rarg = ret
    end
    lret = ltree_do( larg, &block )
    rret = rtree_do( rarg, &block )

    [ lret, rret ]
  end
end

module DiceTreeExpand
  def recursiveExpand( dt, dseparater = " + " )
    str = dt.expand{ |t, d, l, lr, rr|
      "#{t}(= #{lr}D#{rr} : #{d.stream.join(dseparater)})"
    }[1]

    total = dt.value

    if dt.op == DiceTree::DICE
      str
    elsif str.to_s == total.to_s
      total
    else
      "#{total} = #{str}"
    end
  end

  def topDiceExpand( dt, dseparater = " + " )
    expstr = dt.expand{ |t, d, others| "(#{d.stream.join(dseparater)})" }[1]
    expstr = expstr[1..-2] if dt.op == DiceTree::DICE

    ret = String === expstr ? "#{dt.value} = #{expstr}" : dt.value.to_s
    ret += " : #{dt}"
  end

  def stageExpand( dt )
    ret = dt.to_s
    dt.dlevel.times do |level|
      ret += " = #{dt.expand(level+1)[1]}"
    end

    ret
  end
end
