--[[
ȈՔŃ}bvT[o

N玟̂悤Ȗ߂ɂă}bv̏sĂB
u%MAP INITMAP }bv^Cv }bv }bv Rgv
Ń}bv^Cv́uSQ-4vuSQ-8vuHEX-XvuHEX-Yv̂ǂꂩłB

1FXNGA410x20}bvu%MAP INITMAP SQ-4 10 20v
2FwNXY15x20}bvu%MAP INITMAP HEX-Y 15 20v
]]

module( "map", package.seeall )

function prefixes()
  return "MAP"
end

dataTable = {}
cellColors = {}
mapType = nil

function put(key, x, y, d, notice)
  dataTable[key] = { x, y, d }
  return notice .. "%MAP CHARPOS " .. key .. " " .. x .. " " .. y .. " " .. d
end

function get(key, notice)
  local val = dataTable[key]
  if val then
    return notice .. "%MAP CHARPOS " .. key .. " " .. val[1] .. " " .. val[2] .. " " .. val[3]
  end
  return ""
end

function setColor( x, y, r, g, b, notice )
  cellColors[{x,y}] = { r, g, b }
  return notice .. "%MAP CELLLIST " .. x .. ":" .. y .. ":" .. r .. ":" .. g .. ":" .. b
end

function getColor( x, y, notice )
  local val = cellColors[{x,y}]
  if val then
    return notice .. "%MAP CELLLIST " .. x .. ":" .. y .. ":" .. val[1] .. ":" .. val[2] .. ":" .. val[3]
  end
  return ""
end

function getAllColors( notice )
  arr = {}
  for k,v in pairs(cellColors) do
    table.insert( arr, k[1] .. ":" .. k[2] .. ":" .. v[1] .. ":" .. v[2] .. ":" .. v[3] )
  end
  local str = table.concat( arr, "," )
  if string.len( str ) == 0 then
    return ""
  end
  return notice .. "%MAP CELLLIST " .. str
end

function on_msg(prefix, command, rest, notice)
  if string.match( prefix, "MAP" ) then
    if string.match( command, "SETCHARPOS" ) then
      name, x, y, d = string.match( rest, " *([^ ]+) *([0-9]+) *([0-9]+) *([0-9-]+)" )
      if name and x and y and d then
        return put( name, x, y, d, notice )
      end
    elseif string.match( command, "GETMAPINFO" ) then
      if mapType then
        return notice .. "%MAP MAPINFO " .. mapType[1] .. " " .. mapType[2] .. " " .. mapType[3] .. " " .. mapType[4]
      end
    elseif string.match( command, "GETCHARLIST" ) then
      arr = {}
      for k,v in pairs(dataTable) do
        table.insert( arr, k )
      end
      return notice .. "%MAP CHARLIST " .. table.concat( arr, "," )
    elseif string.match( command, "GETCHARPOS" ) then
      m = string.match( rest, " *([^ ]+)" )
      if m then
        return get( m, notice )
      end
    elseif string.match( command, "INITMAP" ) then
      type, xs, ys, etc = string.match( rest, " *([^ ]+) *([0-9]+) *([0-9]+) *(.*)" )
      if mapType then
        return notice .. "Already initialized."
      else
        mapType = { type, xs, ys, etc }
      end
    elseif string.match( command, "RESIZE" ) then
      xs, ys = string.match( rest, " *([0-9]+) *([0-9]+)" )
      if mapType and xs and ys then
        mapType[2] = xs
        mapType[3] = ys
      end
    elseif string.match( command, "SETCELLCOLOR" ) then
      x, y, r, g, b = string.match( rest, " *([0-9]+) *([0-9]+) *([0-9-]+) *([0-9]+) *([0-9]+)" )
      if name and x and y and r and g and b then
        return setColor( x, y, r, g, b, notice )
      end
    elseif string.match( command, "GETCELLCOLOR" ) then
      x, y = string.match( rest, " *([0-9]+) *([0-9]+)" )
      if x and y then
        return getColor( x, y, notice )
      end
    elseif string.match( command, "GETCELLLIST" ) then
      return getAllColors( notice )
    else
      return notice .. "UNKNOWN command '" .. command .. "'."
    end
  elseif string.match( prefix, "SYS" ) then
    if string.match( command, "LIST" ) then
      return notice .. prefixes() .. " luaServer(map-server)"
    end
  end
  return ""
end
