/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CORE_ACPI_H
#define __CORE_ACPI_H

#include <core/types.h>

#define ACPI_SYSTEM_MEMORY		0
#define ACPI_SYSTEM_IO			1
#define ACPI_PCI_CONFIGURATION_SPACE	2
#define ACPI_EMBEDDED_CONTROLLER	3

struct acpi_desc_header {
	u8	signature[4];
	u32	length;
	u8	revision;
	u8	checksum;
	u8	oemid[6];
	u8	oem_table_id[8];
	u8	oem_revision[4];
	u8	creator_id[4];
	u8	creator_revision[4];
} __attribute__ ((packed));

struct acpi_generic_address {
	u8	space_id;
	u8	bit_width;
	u8	bit_offset;
	u8	access_size;
	u64	address;
} __attribute__ ((packed));

typedef void (acpi_parser_t)(void *table, u32 length);
void acpi_register_parser(char *signature, acpi_parser_t *func);

#endif /* __CORE_ACPI_H */
