/*
 * Copyright (c) 2013 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <core/panic.h>
#include <core/spinlock.h>
#include <core/time.h>
#include <core/types.h>
#include <core/wait.h>
#include "asm.h"

void
wait_init(struct wait *wait)
{
	spinlock_init(&wait->lock);
	wait->count = 0;
	wait->serial = 0;
}

void
wait(struct wait *wait, int count)
{
	int serial;
	u64 expire = 0;
	bool detect_lockup = time_initialized ();

	if (detect_lockup) {
		expire = get_cpu_time() + 30 * 1000 * 1000; /* 30 sec */
	}

	spinlock_lock(&wait->lock);
	if (wait->count == 0) {
		wait->count = count;
		wait->serial++;
	}
	wait->count--;
	serial = wait->serial;

	while (wait->count > 0 && serial == wait->serial) {
		spinlock_unlock(&wait->lock);
		asm_pause ();
		if (detect_lockup) {
			if (time_after (get_cpu_time (), expire)) {
				panic ("Other cpu does not come.");
			}
		}
		spinlock_lock(&wait->lock);
	}
	spinlock_unlock(&wait->lock);
}
