/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 */

#include <core/vm.h>

#ifndef _PCI_INTERNAL_H
#define _PCI_INTERNAL_H

#define PCI_NOT_ASSIGNED		0
#define PCI_ASSIGNED			1
#define PCI_DUMMY_FUNC0			2

struct pci_config_mmio_data {
	struct pci_config_mmio_data *next;
	u64 base;
	u16 seg_group;
	u8 bus_start;
	u8 bus_end;
	phys_t phys;
	uint len;
	void *map;
};

struct pci_vm_data {
	pci_config_address_t config_addr;
	LIST2_DEFINE_HEAD(vm_pci_device_list,
			  struct pci_device,
			  vm_pci_device_list);
};

extern drvdata_hdl_t pci_handle;

/********************************************************************************
 * PCI internal definitions and interfaces
 ********************************************************************************/
#define PCI_CONFIG_ADDR_PORT	0x0CF8
#define PCI_CONFIG_DATA_PORT	0x0CFC

u8 pci_read_config_data8(pci_config_address_t addr, int offset);
u16 pci_read_config_data16(pci_config_address_t addr, int offset);
u32 pci_read_config_data32(pci_config_address_t addr, int offset);
void pci_write_config_data8(pci_config_address_t addr, int offset, u8 data);
void pci_write_config_data16(pci_config_address_t addr, int offset, u16 data);
void pci_write_config_data32(pci_config_address_t addr, int offset, u32 data);
struct pci_config_mmio_data * pci_search_config_mmio (u16 seg_group, u8 bus_no);

extern int pci_config_data_handler(core_io_t io, union mem *data, void *arg);
extern int pci_config_addr_handler(core_io_t io, union mem *data, void *arg);
void pci_save_config_addr(void);
void pci_restore_config_addr(void);
extern void pci_append_device(struct pci_device *dev);
int pci_config_mmio_handler (void *data, phys_t gphys, bool wr, void *buf,
			     uint len, u32 flags);

extern struct pci_config_mmio_data *pci_config_mmio_data_head;
extern struct list pci_device_list_head;
void pci_print_device(pci_config_address_t addr, struct pci_config_space *cs);

void pci_init_root_resources(void);
struct pci_device *pci_next_device_on_root_bus(struct pci_device *cur);
void pci_insert_device(struct pci_device *parent, struct pci_device *dev);
vmmerr_t pci_alloc_resource(struct pci_device *dev, struct resource *resource,
			    size_t size, phys_t align, u32 type, u32 data);
u32 pci_get_bar_mask(struct pci_device *dev, int offset);

int pci_check_assignment(u8 bus_no, u8 devfn);
int pci_dummy_func0(pci_off_t offset, pci_off_t size, bool wr, void *data);
void pci_assign_all_devices(void);

#endif
