/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import tinytoolkits.weboard.Item;
import tinytoolkits.weboard.ItemList;
import tinytoolkits.weboard.MemoDialog;
import tinytoolkits.weboard.MousePoint;

public class DrawPane
extends Component {
    private static final long serialVersionUID = 1L;
    private Frame _parent;
    private ItemList _list;
    private DrawPaneListner _listner;
    private PopupMenu popMenu = new PopupMenu();
    private MenuItem menu_addItemPiece = new MenuItem("\u30e1\u30e2\u8ffd\u52a0");
    private MenuItem menu_removeItemPiece = new MenuItem("\u30e1\u30e2\u524a\u9664");
    private MenuItem menu_changeText = new MenuItem("\u30e1\u30e2\u5909\u66f4");
    private MousePoint _mousePoint = new MousePoint();
    private MemoDialog _inputDialog;
    private static final int TEXT_MARGIN = 2;

    public DrawPane(ItemList itemList, DrawPaneListner drawPaneListner, Frame frame) {
        this._parent = frame;
        this._list = itemList;
        this._listner = drawPaneListner;
        this._inputDialog = new MemoDialog(this._parent);
        this.popMenu.add(this.menu_addItemPiece);
        this.popMenu.add(this.menu_removeItemPiece);
        this.popMenu.addSeparator();
        this.popMenu.add(this.menu_changeText);
        this.add(this.popMenu);
        this.menu_changeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawPane.this.changeText();
            }
        });
        this.menu_addItemPiece.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawPane.this.addItem();
            }
        });
        this.menu_removeItemPiece.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawPane.this.removeItem();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DrawPane.this.panel_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DrawPane.this.panel_mouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                DrawPane.this.panel_mouseDragged(mouseEvent);
            }
        });
    }

    private boolean isRightClick(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public void panel_mousePressed(MouseEvent mouseEvent) {
        this._mousePoint.click(mouseEvent.getX(), mouseEvent.getY());
        if (this.isRightClick(mouseEvent)) {
            this.popMenu.show(this, this._mousePoint.getClickX(), this._mousePoint.getClickY());
            return;
        }
        if (this._mousePoint.existDragItem() && this._mousePoint.getHandle().isInRect(mouseEvent.getX(), mouseEvent.getY())) {
            this._mousePoint.dragHandle();
            return;
        }
        this._mousePoint.setDragItem(this._list.getInRect(mouseEvent.getX(), mouseEvent.getY()));
        this.repaint();
    }

    public void panel_mouseDragged(MouseEvent mouseEvent) {
        if (!this._mousePoint.isClick()) {
            return;
        }
        this._mousePoint.drag(mouseEvent.getX(), mouseEvent.getY());
        if (this._mousePoint.isDragHandle()) {
            Item item = this._mousePoint.getDragItem();
            int n = item.getW() + this._mousePoint.getMoveX();
            int n2 = item.getH() + this._mousePoint.getMoveY();
            if (n < 10 || n2 < 10) {
                return;
            }
            item.setW(n);
            item.setH(n2);
            this._mousePoint.resetDragPoint();
            this.repaint();
            return;
        }
        if (this._mousePoint.existDragItem()) {
            Item item = this._mousePoint.getDragItem();
            item.setX(item.getX() + this._mousePoint.getMoveX());
            item.setY(item.getY() + this._mousePoint.getMoveY());
            this._mousePoint.resetDragPoint();
            this.repaint();
        }
    }

    public void panel_mouseReleased(MouseEvent mouseEvent) {
        this._mousePoint.released();
        if (this._mousePoint.isMove() && this._mousePoint.getDragItem() != null) {
            this._listner.listnerCall_changeItem(this._mousePoint.getDragItem());
        }
    }

    public void paint(Graphics graphics) {
        Item item;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this._list.size(); ++i) {
            item = this._list.get(i);
            graphics2D.setColor(item.getBackColor());
            graphics2D.fillRect(item.getX(), item.getY(), item.getW(), item.getH());
            graphics2D.setColor(item.getLineColor());
            graphics2D.drawRect(item.getX(), item.getY(), item.getW(), item.getH());
            graphics2D.setColor(item.getForeColor());
            graphics2D.drawString(item.getText(), item.getX() + 2, item.getY() + graphics2D.getFont().getSize() + 2);
        }
        if (this._mousePoint.existDragItem()) {
            graphics2D.setColor(Color.BLUE);
            Item item2 = this._mousePoint.getDragItem();
            graphics2D.drawRect(item2.getX() - 1, item2.getY() - 1, item2.getW() + 2, item2.getH() + 2);
            item = this._mousePoint.getHandle();
            graphics2D.fillRect(item.getX(), item.getY(), item.getW(), item.getH());
        }
    }

    public void changeText() {
        Item item = this._list.getInRect(this._mousePoint.getClickX(), this._mousePoint.getClickY());
        if (item == null) {
            return;
        }
        Point point = this.getLocationOnScreen();
        this._inputDialog.setLocation(point.x + item.getX() + 10, point.y + item.getY() + 10);
        this._inputDialog.setItem(item);
        this._inputDialog.setVisible(true);
        if (!this._inputDialog.isChanged()) {
            return;
        }
        this._listner.listnerCall_changeItem(item);
    }

    public void addItem() {
        this._mousePoint.setDragItem(null);
        Item item = new Item(-1, this._mousePoint.getClickX(), this._mousePoint.getClickY(), 200, 15, "\u65b0\u898f\u30e1\u30e2");
        this._listner.listnerCall_addItem(item);
    }

    public void removeItem() {
        if (!this._mousePoint.existDragItem()) {
            return;
        }
        this._listner.listnerCall_removeItem(this._mousePoint.getDragItem());
    }

    public static interface DrawPaneListner {
        public void listnerCall_addItem(Item var1);

        public void listnerCall_removeItem(Item var1);

        public void listnerCall_changeItem(Item var1);
    }
}

