/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import tinytoolkits.weboard.Item;

public class HTTPGate {
    URL _url;
    HttpURLConnection _urlconn;

    public HTTPGate(String string) throws MalformedURLException, IOException {
        this._url = new URL(string + "/cgi-bin/items.rb");
    }

    private void reset() throws IOException {
        this._urlconn = (HttpURLConnection)this._url.openConnection();
        this._urlconn.setRequestMethod("POST");
        this._urlconn.setDoOutput(true);
    }

    public String getAll() throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=getAll");
        printWriter.close();
        return this.post();
    }

    public String addItem(Item item) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=addItem");
        printWriter.print("&");
        this.addItemAttributes(printWriter, item);
        printWriter.close();
        return this.post();
    }

    public String removeItem(Item item) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=removeItem");
        printWriter.print("&");
        printWriter.print("itemID=" + item.getID());
        printWriter.close();
        return this.post();
    }

    public String changeItem(Item item) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=changeItem");
        printWriter.print("&");
        this.addItemAttributes(printWriter, item);
        printWriter.close();
        return this.post();
    }

    private void addItemAttributes(PrintWriter printWriter, Item item) {
        printWriter.print("itemID=" + item.getID());
        printWriter.print("&");
        printWriter.print("x=" + item.getX());
        printWriter.print("&");
        printWriter.print("y=" + item.getY());
        printWriter.print("&");
        printWriter.print("w=" + item.getW());
        printWriter.print("&");
        printWriter.print("h=" + item.getH());
        printWriter.print("&");
        printWriter.print("text=" + item.getText());
        printWriter.print("&");
        printWriter.print("fColor=" + item.getForeColor().getRGB());
        printWriter.print("&");
        printWriter.print("bColor=" + item.getBackColor().getRGB());
        printWriter.print("&");
        printWriter.print("lColor=" + item.getLineColor().getRGB());
    }

    public String post() throws IOException {
        String string;
        this._urlconn.connect();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._urlconn.getInputStream(), Charset.forName("UTF-8")));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public void disconnect() {
        this._urlconn.disconnect();
    }
}

