/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import tinytoolkits.weboard.Item;
import tinytoolkits.weboard.SelectColorDialog;

public class MemoDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private Item _currnetItem;
    private Color _tmpForeColor;
    private Color _tmpBackColor;
    private Color _tmpLineColor;
    private TextField _inputText = new TextField();
    private Panel _foreColorPanel = new Panel();
    private Panel _backColorPanel = new Panel();
    private Panel _lineColorPanel = new Panel();
    private boolean _changedItem;
    private SelectColorDialog _dialog;

    public MemoDialog(Frame frame) {
        super(frame, true);
        this._dialog = new SelectColorDialog(frame);
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MemoDialog.this.setVisible(false);
            }
        });
        this.setSize(400, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this._inputText, "Center");
        Panel panel = new Panel();
        Button button = new Button("OK");
        Button button2 = new Button("\u30ad\u30e3\u30f3\u30bb\u30eb");
        panel.add(button);
        panel.add(button2);
        this.add((Component)panel, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoDialog.this.resetItem();
                MemoDialog.this.setVisible(false);
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoDialog.this._changedItem = false;
                MemoDialog.this.setVisible(false);
            }
        });
        panel = new Panel();
        button = new Button("\u524d\u666f\u8272");
        button2 = new Button("\u80cc\u666f\u8272");
        Button button3 = new Button("\u67a0\u8272");
        panel.add(this._foreColorPanel);
        this._foreColorPanel.add(button);
        panel.add(this._backColorPanel);
        this._backColorPanel.add(button2);
        panel.add(this._lineColorPanel);
        this._lineColorPanel.add(button3);
        this.add((Component)panel, "North");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoDialog.this._dialog.setSelectedColor(MemoDialog.this._tmpForeColor);
                MemoDialog.this.moveAndShow();
                MemoDialog.this._tmpForeColor = MemoDialog.this._dialog.getSelectedColor();
                MemoDialog.this.repaintText();
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoDialog.this._dialog.setSelectedColor(MemoDialog.this._tmpBackColor);
                MemoDialog.this.moveAndShow();
                MemoDialog.this._tmpBackColor = MemoDialog.this._dialog.getSelectedColor();
                MemoDialog.this.repaintText();
            }
        });
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoDialog.this._dialog.setSelectedColor(MemoDialog.this._tmpLineColor);
                MemoDialog.this.moveAndShow();
                MemoDialog.this._tmpLineColor = MemoDialog.this._dialog.getSelectedColor();
                MemoDialog.this.repaintText();
            }
        });
    }

    private void moveAndShow() {
        Point point = this.getLocationOnScreen();
        this._dialog.setLocation(point.x, point.y);
        this._dialog.setVisible(true);
    }

    public void setItem(Item item) {
        this._changedItem = false;
        this._currnetItem = item;
        this._inputText.setText(item.getText());
        this._tmpForeColor = item.getForeColor();
        this._tmpBackColor = item.getBackColor();
        this._tmpLineColor = item.getLineColor();
        this.repaintText();
    }

    private void repaintText() {
        this._inputText.setForeground(this._tmpForeColor);
        this._inputText.setBackground(this._tmpBackColor);
        this._foreColorPanel.setBackground(this._tmpForeColor);
        this._backColorPanel.setBackground(this._tmpBackColor);
        this._lineColorPanel.setBackground(this._tmpLineColor);
    }

    private void resetItem() {
        if (this._currnetItem.getText().equals(this._inputText.getText()) && this._currnetItem.getForeColor().getRGB() == this._tmpForeColor.getRGB() && this._currnetItem.getBackColor().getRGB() == this._tmpBackColor.getRGB() && this._currnetItem.getLineColor().getRGB() == this._tmpLineColor.getRGB()) {
            return;
        }
        this._changedItem = true;
        this._currnetItem.setText(this._inputText.getText());
        this._currnetItem.setForeColor(this._tmpForeColor);
        this._currnetItem.setBackColor(this._tmpBackColor);
        this._currnetItem.setLineColor(this._tmpLineColor);
    }

    public boolean isChanged() {
        return this._changedItem;
    }
}

