/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import tinytoolkits.color.SVGColors;
import tinytoolkits.color.TinyNamedColor;

public class SelectColorDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final TinyNamedColor[] COLORS = SVGColors.getAllColors();
    private Panel _btnPanel = new Panel();
    private Color _selectedColor = Color.WHITE;
    private boolean _okEnd;
    private static final int COL_LENGTH = 4;

    public SelectColorDialog(Frame frame) {
        super(frame, true);
        this.init();
    }

    public void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SelectColorDialog.this.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.setSize(300, 50 + COLORS.length / 4 * 13);
        Component component = new Panel();
        this.add(component, "Center");
        ((Container)component).setLayout(new GridLayout(0, 4));
        for (int i = 0; i < COLORS.length; ++i) {
            Label label = new Label(COLORS[i].getName());
            label.setBackground(COLORS[i].getColor());
            ((Container)component).add(label);
            label.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    SelectColorDialog.this.panel_mousePressed(mouseEvent);
                }
            });
        }
        component = new Button("OK");
        Button button = new Button("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this._btnPanel.add(component);
        this._btnPanel.add(button);
        this.add((Component)this._btnPanel, "South");
        ((Button)component).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectColorDialog.this._okEnd = true;
                SelectColorDialog.this.setVisible(false);
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectColorDialog.this._okEnd = false;
                SelectColorDialog.this.setVisible(false);
            }
        });
    }

    private void panel_mousePressed(MouseEvent mouseEvent) {
        String string = ((Label)mouseEvent.getSource()).getText();
        for (int i = 0; i < COLORS.length; ++i) {
            if (!COLORS[i].getName().equals(string)) continue;
            this.setSelectedColor(COLORS[i].getColor());
            return;
        }
    }

    public void setSelectedColor(Color color) {
        this._selectedColor = color;
        this._btnPanel.setBackground(this._selectedColor);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public boolean isOKEnd() {
        return this._okEnd;
    }
}

