package tinytoolkits.color;

import java.awt.Color;

public class TinyNamedColor {
	private final String _name;
	private final Color _color;

	public TinyNamedColor(String name, Color color) {
		_name = name;
		_color = color;
	}

	public String getName() {
		return _name;
	}

	public Color getColor() {
		return _color;
	}

	public int hashCode() {
		return _name.hashCode() + _color.hashCode();
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof TinyNamedColor)) {
			return false;
		}

		TinyNamedColor another = (TinyNamedColor) obj;

		return (_name.equals(another._name) && _color.equals(another._color));
	}

	public String toString() {
		return "[" + _name + "(" + _color + ")]";
	}
}
