package tinytoolkits.weboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class DrawPane extends Component {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Frame _parent;

	private ItemList _list;
	private DrawPaneListner _listner;

	private PopupMenu popMenu = new PopupMenu();
	private MenuItem menu_addItemPiece = new MenuItem("ǉ");
	private MenuItem menu_removeItemPiece = new MenuItem("폜");
	private MenuItem menu_changeText = new MenuItem("ύX");

	private MousePoint _mousePoint = new MousePoint();

	private MemoDialog _inputDialog;
	private static final int TEXT_MARGIN = 2;

	public DrawPane(ItemList list, DrawPaneListner listner, Frame parent) {
		_parent = parent;
		_list = list;
		_listner = listner;

		_inputDialog = new MemoDialog(_parent);

		popMenu.add(menu_addItemPiece);
		popMenu.add(menu_removeItemPiece);
		popMenu.addSeparator();
		popMenu.add(menu_changeText);

		this.add(popMenu);

		menu_changeText.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				changeText();
			}
		});

		menu_addItemPiece.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				addItem();
			}
		});

		menu_removeItemPiece.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				removeItem();
			}
		});

		this.addMouseListener(new MouseAdapter() {

			public void mousePressed(MouseEvent e) {
				panel_mousePressed(e);
			}

			public void mouseReleased(MouseEvent e) {
				panel_mouseReleased(e);
			}
		});

		this.addMouseMotionListener(new MouseMotionAdapter() {

			public void mouseMoved(MouseEvent e) {
			}

			public void mouseDragged(MouseEvent e) {
				panel_mouseDragged(e);
			}
		});

	}

	private boolean isRightClick(MouseEvent e) {
		return (e.getModifiers() & MouseEvent.BUTTON3_MASK) != 0;
	}

	public void panel_mousePressed(MouseEvent e) {

		_mousePoint.click(e.getX(), e.getY());

		if (isRightClick(e)) {
			popMenu.show(this, _mousePoint.getClickX(), _mousePoint.getClickY());
			return;
		}

		if (_mousePoint.existDragItem() && _mousePoint.getHandle().isInRect(e.getX(), e.getY())) {
			_mousePoint.dragHandle();
			return;
		}

		_mousePoint.setDragItem(_list.getInRect(e.getX(), e.getY()));
		repaint();
	}

	public void panel_mouseDragged(MouseEvent e) {

		if (!_mousePoint.isClick()) {
			return;
		}

		_mousePoint.drag(e.getX(), e.getY());

		if (_mousePoint.isDragHandle()) {

			Item item = _mousePoint.getDragItem();
			int w = item.getW() + _mousePoint.getMoveX();
			int h = item.getH() + _mousePoint.getMoveY();

			if (w < 10 || h < 10) {
				return;
			}

			item.setW(w);
			item.setH(h);

			_mousePoint.resetDragPoint();

			repaint();

			return;
		}

		if (_mousePoint.existDragItem()) {
			Item item = _mousePoint.getDragItem();

			item.setX(item.getX() + _mousePoint.getMoveX());
			item.setY(item.getY() + _mousePoint.getMoveY());

			_mousePoint.resetDragPoint();

			repaint();
		}

	}

	public void panel_mouseReleased(MouseEvent e) {
		_mousePoint.released();

		if (_mousePoint.isMove() && _mousePoint.getDragItem() != null) {
			_listner.listnerCall_changeItem(_mousePoint.getDragItem());
		}

	}

	public void paint(Graphics g) {

		Graphics2D g2 = (Graphics2D) g;

		g2.clearRect(0, 0, this.getWidth(), this.getHeight());
		for (int i = 0; i < _list.size(); i++) {
			Item item = _list.get(i);

			g2.setColor(item.getBackColor());
			g2.fillRect(item.getX(), item.getY(), item.getW(), item.getH());

			g2.setColor(item.getLineColor());
			g2.drawRect(item.getX(), item.getY(), item.getW(), item.getH());

			g2.setColor(item.getForeColor());
			g2.drawString(item.getText(), item.getX() + TEXT_MARGIN, item.getY() + g2.getFont().getSize() + TEXT_MARGIN);
		}

		if (_mousePoint.existDragItem()) {
			g2.setColor(Color.BLUE);

			Item item = _mousePoint.getDragItem();
			g2.drawRect(item.getX() - 1, item.getY() - 1, item.getW() + 2, item.getH() + 2);

			Item handle = _mousePoint.getHandle();
			g2.fillRect(handle.getX(), handle.getY(), handle.getW(), handle.getH());
		}
	}

	public void changeText() {
		Item item = _list.getInRect(_mousePoint.getClickX(), _mousePoint.getClickY());

		if (item == null) {
			return;
		}

		Point compCoords = getLocationOnScreen();
		_inputDialog.setLocation(compCoords.x + item.getX() + 10, compCoords.y + item.getY() + 10);
		_inputDialog.setItem(item);

		_inputDialog.setVisible(true);

		if (!_inputDialog.isChanged()) {
			return;
		}

		_listner.listnerCall_changeItem(item);
	}

	public void addItem() {

		_mousePoint.setDragItem(null);

		Item item = new Item(-1, _mousePoint.getClickX(), _mousePoint.getClickY(), 200, 15, "VK");

		_listner.listnerCall_addItem(item);
	}

	public void removeItem() {

		if (!_mousePoint.existDragItem()) {
			return;
		}

		_listner.listnerCall_removeItem(_mousePoint.getDragItem());
	}

	public static interface DrawPaneListner {
		public void listnerCall_addItem(Item item);

		public void listnerCall_removeItem(Item item);

		public void listnerCall_changeItem(Item item);
	}
}
