package tinytoolkits.weboard;

import java.awt.Color;

public class Item {

	private int _id;
	private int _x;
	private int _y;
	private int _w;
	private int _h;
	private String _text;
	private Color _foreColor = Color.BLACK;
	private Color _backColor = Color.WHITE;
	private Color _lineColor = Color.BLACK;

	public Item(int id, int x, int y, int w, int h, String text) {
		_id = id;
		_x = x;
		_y = y;
		_w = w;
		_h = h;
		_text = text;
	}

	public int getID() {
		return _id;
	}

	public int getX() {
		return _x;
	}

	public void setX(int x) {
		this._x = x;
	}

	public int getY() {
		return _y;
	}

	public void setY(int y) {
		this._y = y;
	}

	public int getW() {
		return _w;
	}

	public void setW(int w) {
		this._w = w;
	}

	public int getH() {
		return _h;
	}

	public void setH(int h) {
		this._h = h;
	}

	public String getText() {
		return _text;
	}

	public void setText(String text) {
		this._text = text;
	}

	public Color getForeColor() {
		return _foreColor;
	}

	public void setForeColor(Color color) {
		this._foreColor = color;
	}

	public Color getBackColor() {
		return _backColor;
	}

	public void setBackColor(Color color) {
		this._backColor = color;
	}

	public Color getLineColor() {
		return _lineColor;
	}

	public void setLineColor(Color color) {
		this._lineColor = color;
	}

	public boolean isInRect(int x, int y) {
		return (_x <= x && _y <= y && x <= _x + _w && y <= _y + _h);
	}

	public String toString() {
		return "id=" + _id + ",(" + _x + "," + _y + "," + _w + "," + _h + //
				",Color=" + _foreColor.getRGB() + "," + _backColor.getRGB() + "," + _lineColor.getRGB() + //
				")[" + _text + "]";
	}

}
