package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MemoDialog extends Dialog {

	private static final long serialVersionUID = 1L;

	private Item _currnetItem;

	private Color _tmpForeColor;
	private Color _tmpBackColor;
	private Color _tmpLineColor;

	private TextField _inputText = new TextField();
	private Panel _foreColorPanel = new Panel();
	private Panel _backColorPanel = new Panel();
	private Panel _lineColorPanel = new Panel();

	private boolean _changedItem;

	private SelectColorDialog _dialog;

	public MemoDialog(Frame owner) {
		super(owner, true);
		_dialog = new SelectColorDialog(owner);

		init();
	}

	private void init() {
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
			}
		});

		this.setSize(400, 200);

		this.setLayout(new BorderLayout());
		this.add(_inputText, BorderLayout.CENTER);

		{
			Panel panel = new Panel();
			Button okBtn = new Button("OK");
			Button cancelBtn = new Button("LZ");

			panel.add(okBtn);
			panel.add(cancelBtn);
			this.add(panel, BorderLayout.SOUTH);

			okBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					resetItem();
					setVisible(false);
				}
			});

			cancelBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_changedItem = false;
					setVisible(false);
				}
			});
		}

		{
			Panel panel = new Panel();
			Button foreColorBtn = new Button("OiF");
			Button backColorBtn = new Button("wiF");
			Button lineColorBtn = new Button("gF");

			panel.add(_foreColorPanel);
			_foreColorPanel.add(foreColorBtn);

			panel.add(_backColorPanel);
			_backColorPanel.add(backColorBtn);

			panel.add(_lineColorPanel);
			_lineColorPanel.add(lineColorBtn);

			this.add(panel, BorderLayout.NORTH);

			foreColorBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_dialog.setSelectedColor(_tmpForeColor);
					moveAndShow();

					_tmpForeColor = _dialog.getSelectedColor();

					repaintText();
				}
			});

			backColorBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_dialog.setSelectedColor(_tmpBackColor);
					moveAndShow();

					_tmpBackColor = _dialog.getSelectedColor();

					repaintText();
				}
			});

			lineColorBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_dialog.setSelectedColor(_tmpLineColor);
					moveAndShow();

					_tmpLineColor = _dialog.getSelectedColor();

					repaintText();
				}
			});

		}
	}

	private void moveAndShow() {
		Point compCoords = getLocationOnScreen();
		_dialog.setLocation(compCoords.x, compCoords.y);
		_dialog.setVisible(true);
	}

	public void setItem(Item item) {
		_changedItem = false;

		_currnetItem = item;
		_inputText.setText(item.getText());
		_tmpForeColor = item.getForeColor();
		_tmpBackColor = item.getBackColor();
		_tmpLineColor = item.getLineColor();

		repaintText();
	}

	private void repaintText() {
		_inputText.setForeground(_tmpForeColor);
		_inputText.setBackground(_tmpBackColor);

		_foreColorPanel.setBackground(_tmpForeColor);
		_backColorPanel.setBackground(_tmpBackColor);
		_lineColorPanel.setBackground(_tmpLineColor);
	}

	private void resetItem() {
		if (_currnetItem.getText().equals(_inputText.getText()) && //
				_currnetItem.getForeColor().getRGB() == _tmpForeColor.getRGB() && //
				_currnetItem.getBackColor().getRGB() == _tmpBackColor.getRGB() && //
				_currnetItem.getLineColor().getRGB() == _tmpLineColor.getRGB()) {
			return;
		}
		_changedItem = true;

		_currnetItem.setText(_inputText.getText());
		_currnetItem.setForeColor(_tmpForeColor);
		_currnetItem.setBackColor(_tmpBackColor);
		_currnetItem.setLineColor(_tmpLineColor);
	}

	public boolean isChanged() {
		return _changedItem;
	}
}
