package tinytoolkits.weboard;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;

import tinytoolkits.weboard.DrawPane;
import tinytoolkits.weboard.HTTPGate;
import tinytoolkits.weboard.Item;
import tinytoolkits.weboard.ItemList;
import tinytoolkits.weboard.DrawPane.DrawPaneListner;

public class TinyWEBoardApplet extends Applet implements DrawPaneListner {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ItemList _list = new ItemList();

	private DrawPane _main_panel;
	private HTTPGate _httpGate;

	public void init() {
		initLayout();

		try {

			String address;
			if (System.getProperty("address") != null) {
				address = System.getProperty("address");
			} else {
				address = getParameter("servaerpath");
			}

			_httpGate = new HTTPGate(address);

			String ret = _httpGate.getAll();
			loadAndRepaint(ret);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	private void initLayout() {
		this.setSize(800, 600);
		this.setVisible(true);

		Component co = this;
		while (!((co = co.getParent()) instanceof Frame)) {
		}
		Frame frm = (Frame) co;

		_main_panel = new DrawPane(_list, this, frm);

		this.setLayout(new BorderLayout());
		this.add(_main_panel, BorderLayout.CENTER);
	}

	public void destory() {
		_httpGate.disconnect();
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_addItem(Item item) {
		try {
			String ret = _httpGate.addItem(item);
			loadAndRepaint(ret);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_removeItem(Item item) {
		try {
			String ret = _httpGate.removeItem(item);
			loadAndRepaint(ret);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_changeItem(Item item) {
		try {
			String ret = _httpGate.changeItem(item);
			loadAndRepaint(ret);
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	private void loadAndRepaint(String serverData) {

		_list.clear();
		StringTokenizer st = new StringTokenizer(serverData, "\t");

		try {
			while (st.hasMoreTokens()) {
				String id = st.nextToken();

				if (!st.hasMoreTokens()) {
					break;
				}

				int x = Integer.parseInt(st.nextToken());
				int y = Integer.parseInt(st.nextToken());
				int w = Integer.parseInt(st.nextToken());
				int h = Integer.parseInt(st.nextToken());

				//eLXg󕶎̎̑΍̂߁A1ڂ"@"ǉĂ
				String text = st.nextToken().substring(1);

				Color fColor = new Color(Integer.parseInt(st.nextToken()));
				Color bColor = new Color(Integer.parseInt(st.nextToken()));
				Color lColor = new Color(Integer.parseInt(st.nextToken()));

				Item item = new Item(Integer.parseInt(id), x, y, w, h, text);
				item.setForeColor(fColor);
				item.setBackColor(bColor);
				item.setLineColor(lColor);

				_list.add(item);
			}
		} catch (NumberFormatException e) {
			System.out.println(serverData);
			e.printStackTrace();
		}

		repaint();
	}
}
