/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.StringTokenizer;
import tinytoolkits.weboard.Board;
import tinytoolkits.weboard.BoardDialog;
import tinytoolkits.weboard.MemoDialog;
import tinytoolkits.weboard.MemoItem;
import tinytoolkits.weboard.MousePoint;
import tinytoolkits.weboard.RectangleItem;
import tinytoolkits.weboard.WEBoardDomain;

public class DrawView
extends Component {
    private static final long serialVersionUID = 1L;
    private Image _boardImage;
    private Frame _parent;
    private WEBoardDomain _domain;
    private DrawPaneListner _listner;
    private PopupMenu popMenu = new PopupMenu();
    private MenuItem menu_addItemPiece = new MenuItem("\u30e1\u30e2\u8ffd\u52a0");
    private MenuItem menu_removeItemPiece = new MenuItem("\u30e1\u30e2\u524a\u9664");
    private MenuItem menu_changeText = new MenuItem("\u30e1\u30e2\u5909\u66f4");
    private MenuItem menu_addBoard = new MenuItem("\u30dc\u30fc\u30c9\u8ffd\u52a0");
    private MenuItem menu_changeBoard = new MenuItem("\u30dc\u30fc\u30c9\u540d\u5909\u66f4");
    private MenuItem menu_goBoard = new MenuItem("\u30dc\u30fc\u30c9\u79fb\u52d5");
    private MenuItem menu_backBoard = new MenuItem("\u30dc\u30fc\u30c9\u623b\u308b");
    private MousePoint _mousePoint = new MousePoint();
    private BoardDialog _boardDialog;
    private MemoDialog _memoDialog;
    private static final int TEXT_MARGIN = 2;

    public DrawView(WEBoardDomain wEBoardDomain, DrawPaneListner drawPaneListner, Frame frame) {
        this._parent = frame;
        this._domain = wEBoardDomain;
        this._listner = drawPaneListner;
        this._boardDialog = new BoardDialog(this._parent);
        this._memoDialog = new MemoDialog(this._parent);
        this.popMenu.add(this.menu_changeText);
        this.popMenu.add(this.menu_addItemPiece);
        this.popMenu.add(this.menu_removeItemPiece);
        this.popMenu.addSeparator();
        this.popMenu.add(this.menu_addBoard);
        this.popMenu.add(this.menu_changeBoard);
        this.popMenu.addSeparator();
        this.popMenu.add(this.menu_goBoard);
        this.popMenu.add(this.menu_backBoard);
        this.add(this.popMenu);
        this.menu_changeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.panel_doubleClick();
            }
        });
        this.menu_addItemPiece.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.addItem();
            }
        });
        this.menu_removeItemPiece.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.removeItem();
            }
        });
        this.menu_addBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.addBoard();
            }
        });
        this.menu_changeBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.changeBoard();
            }
        });
        this.menu_goBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.goBoard();
            }
        });
        this.menu_backBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawView.this.backBoard();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DrawView.this.panel_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DrawView.this.panel_mouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                DrawView.this.panel_mouseDragged(mouseEvent);
            }
        });
        URL uRL = this.getClass().getResource("board.png");
        this._boardImage = Toolkit.getDefaultToolkit().createImage(uRL);
    }

    private boolean isRightClick(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public void panel_mousePressed(MouseEvent mouseEvent) {
        this._mousePoint.click(mouseEvent.getX(), mouseEvent.getY());
        if (this.isRightClick(mouseEvent)) {
            this.popMenu.show(this, this._mousePoint.getClickX(), this._mousePoint.getClickY());
            return;
        }
        if (1 < mouseEvent.getClickCount()) {
            this.panel_doubleClick();
        }
        if (this._mousePoint.existDragItem() && this._mousePoint.getHandle().isInRect(mouseEvent.getX(), mouseEvent.getY())) {
            this._mousePoint.dragHandle();
            return;
        }
        this._mousePoint.setDragItem(this._domain.getCurrentBoardItemList().getInRect(mouseEvent.getX(), mouseEvent.getY()));
        this.repaint();
    }

    public void panel_mouseDragged(MouseEvent mouseEvent) {
        if (!this._mousePoint.isClick()) {
            return;
        }
        this._mousePoint.drag(mouseEvent.getX(), mouseEvent.getY());
        if (this._mousePoint.isDragHandle()) {
            RectangleItem rectangleItem = this._mousePoint.getDragItem();
            int n = rectangleItem.getW() + this._mousePoint.getMoveX();
            int n2 = rectangleItem.getH() + this._mousePoint.getMoveY();
            if (n < 10 || n2 < 10) {
                return;
            }
            rectangleItem.setW(n);
            rectangleItem.setH(n2);
            this._mousePoint.resetDragPoint();
            this.repaint();
            return;
        }
        if (this._mousePoint.existDragItem()) {
            RectangleItem rectangleItem = this._mousePoint.getDragItem();
            rectangleItem.setX(rectangleItem.getX() + this._mousePoint.getMoveX());
            rectangleItem.setY(rectangleItem.getY() + this._mousePoint.getMoveY());
            this._mousePoint.resetDragPoint();
            this.repaint();
        }
    }

    public void panel_mouseReleased(MouseEvent mouseEvent) {
        this._mousePoint.released();
        if (this._mousePoint.isMove() && this._mousePoint.getDragItem() != null) {
            RectangleItem rectangleItem = this._mousePoint.getDragItem();
            if (rectangleItem instanceof MemoItem) {
                this._listner.listnerCall_changeItem((MemoItem)rectangleItem);
            } else if (rectangleItem instanceof Board) {
                this._listner.listnerCall_changeBoard((Board)rectangleItem);
            }
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = graphics2D.getFont().getSize();
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._domain.getBoardList().size(); ++i) {
            if (0 < i) {
                stringBuffer.append(" > ");
            }
            stringBuffer.append("[");
            stringBuffer.append(((Board)this._domain.getBoardList().get(i)).getName());
            stringBuffer.append("]");
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawString(stringBuffer.toString(), 0, n);
        for (int i = 0; i < this._domain.getCurrentBoardItemList().size(); ++i) {
            RectangleItem.AbstractRectangleItem abstractRectangleItem;
            RectangleItem rectangleItem = this._domain.getCurrentBoardItemList().get(i);
            if (rectangleItem instanceof MemoItem) {
                abstractRectangleItem = (MemoItem)rectangleItem;
                graphics2D.setColor(((MemoItem)abstractRectangleItem).getBackColor());
                graphics2D.fillRect(rectangleItem.getX(), rectangleItem.getY(), rectangleItem.getW(), rectangleItem.getH());
                graphics2D.setColor(((MemoItem)abstractRectangleItem).getLineColor());
                graphics2D.drawRect(rectangleItem.getX(), rectangleItem.getY(), rectangleItem.getW(), rectangleItem.getH());
                graphics2D.setColor(((MemoItem)abstractRectangleItem).getForeColor());
                StringTokenizer stringTokenizer = new StringTokenizer(((MemoItem)abstractRectangleItem).getText(), "\n");
                int n2 = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    graphics2D.drawString(stringTokenizer.nextToken(), rectangleItem.getX() + 2, rectangleItem.getY() + n * n2 + 2);
                    ++n2;
                }
                continue;
            }
            if (!(rectangleItem instanceof Board)) continue;
            abstractRectangleItem = (Board)rectangleItem;
            graphics2D.drawImage(this._boardImage, abstractRectangleItem.getX(), abstractRectangleItem.getY(), this);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(((Board)abstractRectangleItem).getName(), abstractRectangleItem.getX(), abstractRectangleItem.getY() + 16 + n);
        }
        if (this._mousePoint.existDragItem()) {
            graphics2D.setColor(Color.BLUE);
            RectangleItem rectangleItem = this._mousePoint.getDragItem();
            graphics2D.drawRect(rectangleItem.getX() - 1, rectangleItem.getY() - 1, rectangleItem.getW() + 2, rectangleItem.getH() + 2);
            MemoItem memoItem = this._mousePoint.getHandle();
            graphics2D.fillRect(memoItem.getX(), memoItem.getY(), memoItem.getW(), memoItem.getH());
        }
    }

    public void panel_doubleClick() {
        RectangleItem rectangleItem = this._domain.getCurrentBoardItemList().getInRect(this._mousePoint.getClickX(), this._mousePoint.getClickY());
        if (rectangleItem instanceof MemoItem) {
            this.showDrawDialog((MemoItem)rectangleItem);
            if (!this._memoDialog.isChanged()) {
                return;
            }
            this._listner.listnerCall_changeItem((MemoItem)rectangleItem);
            return;
        }
        if (rectangleItem instanceof Board) {
            this.goBoard();
        }
    }

    public void addItem() {
        this._mousePoint.setDragItem(null);
        MemoItem memoItem = new MemoItem(-1, this._mousePoint.getClickX(), this._mousePoint.getClickY(), 200, 15, "");
        this.showDrawDialog(memoItem);
        if (!this._memoDialog.isChanged()) {
            return;
        }
        this._listner.listnerCall_addItem(memoItem);
    }

    private void showDrawDialog(MemoItem memoItem) {
        Point point = this.getLocationOnScreen();
        this._memoDialog.setLocation(point.x + memoItem.getX() + 10, point.y + memoItem.getY() + 10);
        this._memoDialog.setItem(memoItem);
        this._memoDialog.setVisible(true);
    }

    public void removeItem() {
        if (!this._mousePoint.existDragItem()) {
            return;
        }
        RectangleItem rectangleItem = this._mousePoint.getDragItem();
        if (!(rectangleItem instanceof MemoItem)) {
            return;
        }
        this._mousePoint.setDragItem(null);
        this._listner.listnerCall_removeItem((MemoItem)rectangleItem);
    }

    private void showBoardDialog(Board board) {
        this._boardDialog.setBoard(board);
        Point point = this.getLocationOnScreen();
        this._boardDialog.setLocation(point.x + board.getX() + 10, point.y + board.getY() + 10);
        this._boardDialog.setBoard(board);
        this._boardDialog.setVisible(true);
    }

    public void addBoard() {
        Board board = new Board(-1, this._mousePoint.getClickX(), this._mousePoint.getClickY(), "New Board");
        this.showBoardDialog(board);
        if (!this._boardDialog.isChanged()) {
            return;
        }
        this._listner.listnerCall_addBoard(board);
    }

    public void changeBoard() {
        if (!this._mousePoint.existDragItem()) {
            return;
        }
        RectangleItem rectangleItem = this._mousePoint.getDragItem();
        if (!(rectangleItem instanceof Board)) {
            return;
        }
        Board board = (Board)rectangleItem;
        this.showBoardDialog(board);
        if (!this._boardDialog.isChanged()) {
            return;
        }
        this._listner.listnerCall_changeBoard(board);
    }

    public void goBoard() {
        if (!this._mousePoint.existDragItem()) {
            return;
        }
        RectangleItem rectangleItem = this._mousePoint.getDragItem();
        if (!(rectangleItem instanceof Board)) {
            return;
        }
        Board board = (Board)rectangleItem;
        this._domain.setCurrentBoard(board);
        this._listner.listnerCall_getAllItem();
    }

    public void backBoard() {
        if (!this._domain.backCurrentBoard()) {
            return;
        }
        this._listner.listnerCall_getAllItem();
    }

    public static interface DrawPaneListner {
        public void listnerCall_getAllItem();

        public void listnerCall_addBoard(Board var1);

        public void listnerCall_changeBoard(Board var1);

        public void listnerCall_addItem(MemoItem var1);

        public void listnerCall_removeItem(MemoItem var1);

        public void listnerCall_changeItem(MemoItem var1);
    }
}

