/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import tinytoolkits.weboard.Board;
import tinytoolkits.weboard.DrawView;
import tinytoolkits.weboard.HTTPGate;
import tinytoolkits.weboard.MemoItem;
import tinytoolkits.weboard.WEBoardDomain;
import tinytoolkits.weboard.WEBoardView;

public class WEBoardController
implements DrawView.DrawPaneListner {
    private HTTPGate _httpGate;
    private WEBoardDomain _domain;
    private WEBoardView _view;

    public WEBoardController(HTTPGate hTTPGate, WEBoardDomain wEBoardDomain, Frame frame) {
        this._httpGate = hTTPGate;
        this._domain = wEBoardDomain;
        this._view = new WEBoardView(this._domain, this, frame);
    }

    public Component getMainPanel() {
        return this._view.getCurrentView();
    }

    public void disconnect() {
        this._httpGate.disconnect();
    }

    public void listnerCall_getAllItem() {
        try {
            this._httpGate.getAll();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._view.repaint();
    }

    public void listnerCall_addBoard(Board board) {
        try {
            this._httpGate.addBoard(board);
            this._view.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void listnerCall_changeBoard(Board board) {
        try {
            this._httpGate.changeBoard(board);
            this._view.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void listnerCall_addItem(MemoItem memoItem) {
        try {
            this._httpGate.addMemo(memoItem);
            this._view.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void listnerCall_removeItem(MemoItem memoItem) {
        try {
            this._httpGate.removeMemo(memoItem);
            this._view.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void listnerCall_changeItem(MemoItem memoItem) {
        try {
            this._httpGate.changeMemo(memoItem);
            this._view.repaint();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

