package tinytoolkits.weboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.StringTokenizer;

public class DrawView extends Component {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Image _boardImage;

	private Frame _parent;

	private WEBoardDomain _domain;
	private DrawPaneListner _listner;

	private PopupMenu popMenu = new PopupMenu();
	private MenuItem menu_addItemPiece = new MenuItem("ǉ");
	private MenuItem menu_removeItemPiece = new MenuItem("폜");
	private MenuItem menu_changeText = new MenuItem("ύX");
	private MenuItem menu_addBoard = new MenuItem("{[hǉ");
	private MenuItem menu_changeBoard = new MenuItem("{[hύX");
	private MenuItem menu_goBoard = new MenuItem("{[hړ");
	private MenuItem menu_backBoard = new MenuItem("{[h߂");

	private MousePoint _mousePoint = new MousePoint();

	private BoardDialog _boardDialog;
	private MemoDialog _memoDialog;
	private static final int TEXT_MARGIN = 2;

	public DrawView(WEBoardDomain domain, DrawPaneListner listner, Frame parent) {
		_parent = parent;
		_domain = domain;
		_listner = listner;

		_boardDialog = new BoardDialog(_parent);
		_memoDialog = new MemoDialog(_parent);

		popMenu.add(menu_changeText);
		popMenu.add(menu_addItemPiece);
		popMenu.add(menu_removeItemPiece);
		popMenu.addSeparator();
		popMenu.add(menu_addBoard);
		popMenu.add(menu_changeBoard);
		popMenu.addSeparator();
		popMenu.add(menu_goBoard);
		popMenu.add(menu_backBoard);

		this.add(popMenu);

		menu_changeText.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel_doubleClick();
			}
		});

		menu_addItemPiece.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				addItem();
			}
		});

		menu_removeItemPiece.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				removeItem();
			}
		});

		menu_addBoard.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				addBoard();
			}
		});

		menu_changeBoard.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				changeBoard();
			}
		});
		
		menu_goBoard.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				goBoard();
			}
		});

		menu_backBoard.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				backBoard();
			}
		});

		this.addMouseListener(new MouseAdapter() {

			public void mousePressed(MouseEvent e) {
				panel_mousePressed(e);
			}

			public void mouseReleased(MouseEvent e) {
				panel_mouseReleased(e);
			}
		});

		this.addMouseMotionListener(new MouseMotionAdapter() {

			public void mouseMoved(MouseEvent e) {
			}

			public void mouseDragged(MouseEvent e) {
				panel_mouseDragged(e);
			}
		});

		URL url = this.getClass().getResource("board.png");
		_boardImage = Toolkit.getDefaultToolkit().createImage(url);
	}

	private boolean isRightClick(MouseEvent e) {
		return (e.getModifiers() & MouseEvent.BUTTON3_MASK) != 0;
	}

	public void panel_mousePressed(MouseEvent e) {

		_mousePoint.click(e.getX(), e.getY());

		if (isRightClick(e)) {
			popMenu.show(this, _mousePoint.getClickX(), _mousePoint.getClickY());
			return;
		}

		if (1 < e.getClickCount()) {
			panel_doubleClick();
		}

		if (_mousePoint.existDragItem() && _mousePoint.getHandle().isInRect(e.getX(), e.getY())) {
			_mousePoint.dragHandle();
			return;
		}

		_mousePoint.setDragItem(_domain.getCurrentBoardItemList().getInRect(e.getX(), e.getY()));
		repaint();
	}

	public void panel_mouseDragged(MouseEvent e) {

		if (!_mousePoint.isClick()) {
			return;
		}

		_mousePoint.drag(e.getX(), e.getY());

		if (_mousePoint.isDragHandle()) {

			RectangleItem item = _mousePoint.getDragItem();
			int w = item.getW() + _mousePoint.getMoveX();
			int h = item.getH() + _mousePoint.getMoveY();

			if (w < 10 || h < 10) {
				return;
			}

			item.setW(w);
			item.setH(h);

			_mousePoint.resetDragPoint();

			repaint();

			return;
		}

		if (_mousePoint.existDragItem()) {
			RectangleItem item = _mousePoint.getDragItem();

			item.setX(item.getX() + _mousePoint.getMoveX());
			item.setY(item.getY() + _mousePoint.getMoveY());

			_mousePoint.resetDragPoint();

			repaint();
		}

	}

	public void panel_mouseReleased(MouseEvent e) {
		_mousePoint.released();

		if (_mousePoint.isMove() && _mousePoint.getDragItem() != null) {
			RectangleItem item = _mousePoint.getDragItem();

			if (item instanceof MemoItem) {
				_listner.listnerCall_changeItem((MemoItem) item);
			} else if (item instanceof Board) {
				_listner.listnerCall_changeBoard((Board) item);
			}

		}

	}

	public void paint(Graphics g) {

		Graphics2D g2 = (Graphics2D) g;

		int fontHeight = g2.getFont().getSize();

		g2.clearRect(0, 0, this.getWidth(), this.getHeight());

		{
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < _domain.getBoardList().size(); i++) {
				if (0 < i) {
					sb.append(" > ");
				}

				sb.append("[");
				sb.append(((Board)_domain.getBoardList().get(i)).getName());
				sb.append("]");
			}
			g2.setColor(Color.GRAY);
			g2.drawString(sb.toString(), 0, fontHeight);
		}

		for (int i = 0; i < _domain.getCurrentBoardItemList().size(); i++) {
			RectangleItem item = _domain.getCurrentBoardItemList().get(i);

			if (item instanceof MemoItem) {
				//Item`
				MemoItem memo = (MemoItem) item;

				g2.setColor(memo.getBackColor());
				g2.fillRect(item.getX(), item.getY(), item.getW(), item.getH());

				g2.setColor(memo.getLineColor());
				g2.drawRect(item.getX(), item.getY(), item.getW(), item.getH());

				g2.setColor(memo.getForeColor());
				StringTokenizer st = new StringTokenizer(memo.getText(), "\n");
				int h = 1;
				while (st.hasMoreTokens()) {
					g2.drawString(st.nextToken(), item.getX() + TEXT_MARGIN, item.getY() + fontHeight * h + TEXT_MARGIN);
					h++;
				}
			} else if (item instanceof Board) {
				//Board`
				Board board = (Board) item;

				g2.drawImage(_boardImage, board.getX(), board.getY(), this);

				g2.setColor(Color.BLACK);
				g2.drawString(board.getName(), board.getX(), board.getY() + Board.HEIGHT + fontHeight);
			}

		}

		if (_mousePoint.existDragItem()) {
			g2.setColor(Color.BLUE);

			RectangleItem item = _mousePoint.getDragItem();
			g2.drawRect(item.getX() - 1, item.getY() - 1, item.getW() + 2, item.getH() + 2);

			MemoItem handle = _mousePoint.getHandle();
			g2.fillRect(handle.getX(), handle.getY(), handle.getW(), handle.getH());
		}
	}

	public void panel_doubleClick() {
		RectangleItem item = _domain.getCurrentBoardItemList().getInRect(_mousePoint.getClickX(), _mousePoint.getClickY());

		if (item instanceof MemoItem) {
			showDrawDialog((MemoItem) item);

			if (!_memoDialog.isChanged()) {
				return;
			}

			_listner.listnerCall_changeItem((MemoItem) item);

			return;

		} else if (item instanceof Board) {
			goBoard();
		}

	}

	public void addItem() {

		_mousePoint.setDragItem(null);

		MemoItem item = new MemoItem(-1, _mousePoint.getClickX(), _mousePoint.getClickY(), 200, 15, "");

		showDrawDialog(item);

		if (!_memoDialog.isChanged()) {
			return;
		}

		_listner.listnerCall_addItem(item);
	}

	private void showDrawDialog(MemoItem item) {
		Point compCoords = getLocationOnScreen();
		_memoDialog.setLocation(compCoords.x + item.getX() + 10, compCoords.y + item.getY() + 10);
		_memoDialog.setItem(item);
		_memoDialog.setVisible(true);
	}

	public void removeItem() {

		if (!_mousePoint.existDragItem()) {
			return;
		}

		RectangleItem item = _mousePoint.getDragItem();
		if (!(item instanceof MemoItem)) {
			return;
		}

		_mousePoint.setDragItem(null);

		_listner.listnerCall_removeItem((MemoItem) item);
	}

	private void showBoardDialog(Board board) {
		_boardDialog.setBoard(board);

		Point compCoords = getLocationOnScreen();
		_boardDialog.setLocation(compCoords.x + board.getX() + 10, compCoords.y + board.getY() + 10);
		_boardDialog.setBoard(board);
		_boardDialog.setVisible(true);
	}

	public void addBoard() {
		Board board = new Board(-1, _mousePoint.getClickX(), _mousePoint.getClickY(), "New Board");
		showBoardDialog(board);
		if (!_boardDialog.isChanged()) {
			return;
		}

		_listner.listnerCall_addBoard(board);
	}
	
	public void changeBoard() {
		if (!_mousePoint.existDragItem()) {
			return;
		}

		RectangleItem item = _mousePoint.getDragItem();
		if (!(item instanceof Board)) {
			return;
		}
		
		Board board = (Board) item;
		
		showBoardDialog(board);
		if (!_boardDialog.isChanged()) {
			return;
		}

		_listner.listnerCall_changeBoard(board);
	}

	public void goBoard() {
		if (!_mousePoint.existDragItem()) {
			return;
		}

		RectangleItem item = _mousePoint.getDragItem();
		if (!(item instanceof Board)) {
			return;
		}

		Board board = (Board) item;
		_domain.setCurrentBoard(board);

		_listner.listnerCall_getAllItem();
	}

	public void backBoard() {
		if (!_domain.backCurrentBoard()) {
			return;
		}

		_listner.listnerCall_getAllItem();
	}

	public static interface DrawPaneListner {

		public void listnerCall_getAllItem();

		public void listnerCall_addBoard(Board board);

		public void listnerCall_changeBoard(Board board);

		public void listnerCall_addItem(MemoItem item);

		public void listnerCall_removeItem(MemoItem item);

		public void listnerCall_changeItem(MemoItem item);
	}
}
