package tinytoolkits.weboard;

public interface RectangleItem {
	public int getX();
	public void setX(int x);
	public int getY();
	public void setY(int y);
	public int getW();
	public void setW(int w);
	public int getH();
	public void setH(int h);

	public boolean isInRect(int x, int y);

	public static abstract class AbstractRectangleItem implements RectangleItem {
		private int _id;
		private int _x;
		private int _y;

		public AbstractRectangleItem(int id, int x, int y) {
			_id = id;
			_x = x;
			_y = y;
		}

		public int getID() {
			return _id;
		}

		public int getX() {
			return _x;
		}

		public void setX(int x) {
			this._x = x;
		}

		public int getY() {
			return _y;
		}

		public void setY(int y) {
			this._y = y;
		}

		public boolean isInRect(int x, int y) {
			return (_x <= x && _y <= y && x <= _x + getW() && y <= _y + getH());
		}

	}
}
