package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SelectBoardDialog extends Dialog {

	private static final long serialVersionUID = 1L;

	private List _list;

	private Panel _btnPanel = new Panel();
	private boolean _okEnd;
	private boolean _addEnd;

	private TextField _nameText = new TextField("ǉꍇ͂ɖO͂Ă");

	private Board[] _boards;

	public SelectBoardDialog(Frame owner, Board[] boards) {
		super(owner, true);
		_boards = (Board[]) (boards.clone());
		init();
	}

	public void init() {
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
			}
		});

		this.setLayout(new BorderLayout());
		this.setSize(600, 400);
		{
			_list = new List();
			this.add(_list, BorderLayout.CENTER);
			resetBoardsList();
		}

		{
			Button addBtn = new Button("VK{[hǉ");
			Button okBtn = new Button("OK");
			Button cancelBtn = new Button("LZ");

			_btnPanel.add(_nameText);
			_btnPanel.add(addBtn);
			_btnPanel.add(okBtn);
			_btnPanel.add(cancelBtn);
			this.add(_btnPanel, BorderLayout.SOUTH);

			addBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (_nameText.getText().trim().length() == 0) {
						setTitle("O͂Ă܂");
						return;
					}
					_addEnd = true;
					_okEnd = false;
					setVisible(false);
				}
			});

			okBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (_list.getSelectedIndex() < 0) {
						setTitle("IĂ܂");
						return;
					}
					_addEnd = false;
					_okEnd = true;
					setVisible(false);
				}
			});

			cancelBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_addEnd = false;
					_okEnd = false;
					setVisible(false);
				}
			});
		}

	}

	public void setBoards(Board[] boards) {
		_boards = (Board[]) (boards.clone());
		resetBoardsList();
	}

	private void resetBoardsList() {
		_okEnd = false;
		_addEnd = false;

		for (int i = 0; i < _boards.length; i++) {
			_list.add(_boards[i].getName());
		}

		if (0 < _list.getItemCount()) {
			_list.select(0);
		}
	}

	public Board getSelectedBoard() {
		if (!_okEnd || _list.getSelectedIndex() < 0) {
			return null;
		}

		return _boards[_list.getSelectedIndex()];
	}

	public boolean isAddEnd() {
		return _addEnd;
	}

	public String getNewBoardName() {
		return _nameText.getText();
	}

	public boolean isOKEnd() {
		return _okEnd;
	}

}
