package tinytoolkits.weboard;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessControlException;

public class TinyWEBoardApplet extends Applet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private WEBoardDomain _domain = new WEBoardDomain();
	private WEBoardController _controller;

	/**
	 * Applet.
	 */
	public void init() {

		try {
			HTTPGate httpGate;

			String address;
			if (System.getProperty("address") != null) {
				address = System.getProperty("address");
			} else {
				address = getParameter("servaerpath");
			}

			httpGate = new HTTPGate(address, _domain);

			Component co = this;
			while (!((co = co.getParent()) instanceof Frame)) {
			}
			_controller = new WEBoardController(httpGate, _domain, (Frame) co);

			System.out.println(getCodeBase().getPath());
			System.out.println(getDocumentBase().getPath());

			httpGate.getBoard(Board.ROOT_ID);
			_controller.listnerCall_getAllItem();

		} catch (MalformedURLException e) {
			setErrPanel(e, "MalformedURLException");
			e.printStackTrace();
		} catch (IOException e) {
			setErrPanel(e, "IOException");
			e.printStackTrace();
		} catch (AccessControlException e) {
			setErrPanel(e, "JavãZLeB[G[łBܑΉłB܂ɒĂ݂ĂB");
			e.printStackTrace();
		} catch (Exception e) {
			setErrPanel(e, "");
			e.printStackTrace();
		}

		initLayout();

	}

	private void setErrPanel(Exception e, String word) {
		this.add(new Label("Err!!         " + word + " [" + e.getClass().getName() + "]"), BorderLayout.CENTER);
	}

	private void initLayout() {
		this.setSize(800, 600);
		this.setVisible(true);

		this.setLayout(new BorderLayout());
		this.add(_controller.getMainPanel(), BorderLayout.CENTER);
	}

	/**
	 * Applet.
	 */
	public void destory() {
		_controller.disconnect();
	}

}
