/* fbasis.c */

#include	"tazel.h"

/************************************************************************************************/
extern dbl fmod2p(dbl x){				// It returns x%(2.0*M_PI).
int		i;
	i =x/(2.0*M_PI);
	x-=i*(2.0*M_PI);
	if(x<0.0)
		x+=(2.0*M_PI);
	return(x);
}

/************************************************************************************************/
extern dbl rad(dbl x){					// It converts [Deg]->[Rad].
	return((2.0*M_PI)*x/360.0);
}

/************************************************************************************************/
extern dbl deg(dbl x){					// It converts [Rad]->[Deg].
	return(360.0*x/(2.0*M_PI));
}

/************************************************************************************************/
extern void kvec(dbl k,vec_t *p_vec){	// K*Vector
	p_vec->x*=k;
	p_vec->y*=k;
	p_vec->z*=k;
	vmag(p_vec);
}

/************************************************************************************************/
extern void vmag(vec_t *p_vec){			// |Vector|
	p_vec->r=sqrt(pow(p_vec->x,2.0)+pow(p_vec->y,2.0)+pow(p_vec->z,2.0));
}

/************************************************************************************************/
extern char *substr(char *ptr,int s,int e){
										// It returns strdupped substring. ( ptr[s] to ptr[e] )
char	buf[BUFSIZ];
int		d;
	for( d=0 ; s<=e ; s++,d++ )
		buf[d]=ptr[s];
	buf[d]='\0';
	return(strdup(buf));
}

/************************************************************************************************/
extern tle_t *tledup(tle_t tle){		// It returns strdupped tle.

tle_t	*ptr;
	if( (ptr=malloc(sizeof(tle_t)))==NULL ){
		fprintf(stderr,"Error[tledup()]: Cannot MALLOC() Memory!!\n");
		exit(1);
	}
	*ptr=tle;
	return(ptr);
}
