/* fdisp.c */

#include	"tazel.h"

/************************************************************************************************/
// This function displays TAZEL format information.
/************************************************************************************************/
extern void disp_format(FILE *fp,int flag_tledump){

//	fprintf(fp,"# Date&Time[UTC]        UnixTime   CatNo IntrDesg SatName(10)  Lon[deg] Lat[deg]     Alt[km]    Vel[m/s]   Az[deg]  El[deg]   Range[km]  rRate[m/s]       X[km]       Y[km]       Z[km]   XDOT[m/s]   YDOT[m/s]   ZDOT[m/s] # SatName(Full)            TLE-Epoch[UTC]          SetNo  Elapse[*]");
	fprintf(fp,"# Date&Time[UTC]        UnixTime     CatNo IntrDesg SatName(10)  Lon[deg] Lat[deg]     Alt[km]    Vel[m/s]   Az[deg]  El[deg]   Range[km]  rRate[m/s]       X[km]       Y[km]       Z[km]   XDOT[m/s]   YDOT[m/s]   ZDOT[m/s] # SatName(Full)            TLE-Epoch[UTC]          SetNo  Elapse[*]");
	if( flag_tledump==TRUE )			/* Include TLE-Data Dump Information					*/
		fprintf(fp," TLE(1)                                                                TLE(2)                                                               ");
	fprintf(fp,"\n");

}

/************************************************************************************************/
// This function displays TAZEL result data.
/************************************************************************************************/
extern void disp_result(time_t t_abs,int t_off,dbl t_msec,tle_t tle_main,sat_t sat_main,char *buf_datetime,char *buf_satcname,char *buf_tleepoch,int flag_tledump){

char	d_frac[BUFSIZ];					/* Buffer for Decimal Fraction							*/
dbl		elapse;							/* Elapsed Time [day] ( Since TLE-Epoch )				*/

/* Display "Date&Time/UnixTime" */
	sprintf(d_frac,"%.3f",t_msec);											// "0.123"
	printf("%s%s 0x%010"PRIX64" ",buf_datetime,&d_frac[1],(int64_t)t_abs);	// " .123"

/* Display "CatNo/IntrDesg/SatName(Concise)" */
	printf("%05d %-8s %s ",tle_main.catno,tle_main.idesg,buf_satcname);

/* Display "Lon/Lat/Alt" */
	printf("%+9.3f %+8.3f ",sat_main.lon,sat_main.lat);
	if(fabs(sat_main.alt)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.alt);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.alt);

/* Display "Vel" */
	if(fabs(sat_main.vel)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.vel);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.vel);

/* Display "Az/El/Range/rRate" */
	printf("%+9.3f %+8.3f ",sat_main.az,sat_main.el);
	if(fabs(sat_main.range)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.range);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.range);
	if(fabs(sat_main.rrate)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.rrate);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.rrate);

/* Display "X/Y/Z" */
	if(fabs(sat_main.x)<99999.9995)					/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.x);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.x);
	if(fabs(sat_main.y)<99999.9995)					/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.y);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.y);
	if(fabs(sat_main.z)<99999.9995)					/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.z);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.z);

/* Display "XDOT/YDOT/ZDOT" */
	if(fabs(sat_main.xdot)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.xdot);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.xdot);
	if(fabs(sat_main.ydot)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.ydot);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.ydot);
	if(fabs(sat_main.zdot)<99999.9995)				/* +0.000 -  +99999.999	*/
		printf("%+11.3f ",sat_main.zdot);
	else											/*        - +1.2345E+99	*/
		printf("%+11.4E ",sat_main.zdot);

/* Display "# SatName(Full)" */
	printf("# %-24s ",tle_main.name);

/* Display "TLE-Epoch/EleNo/Elapse" */
	printf("%s %5s ",buf_tleepoch,substr(tle_main.line1,64,67));
	elapse=diff_epoch2utc(tle_main.epoch,t_abs,t_off);
	if( -365.0<elapse && elapse<+365.0 )
		printf("%+9.3fD",elapse);
	else
		printf("%+9.3fY",elapse/365.0);

/* Display TLE Line1&Line2 */
	if( flag_tledump==TRUE ){
		printf(" %-69s",tle_main.line1);
		printf(" %-69s",tle_main.line2);
	}

/* Display "\n" */
	printf("\n");

}

/************************************************************************************************/
// This function displays TAZEL version information.
/************************************************************************************************/
extern void disp_version(){

	fprintf(stderr,"\n");
	fprintf(stderr,"TAZEL - A Keep it Simple & Small TLE Propagator ( Ver.%s GPL&LGPL )\n",VER_TAZEL);
	fprintf(stderr,"Copyright (C) 2005-2018 \"NekoMimi\" <twintail@angelmode.net>\n");
	fprintf(stderr,"This is a GPL and/or LGPL free software; see the COPYING documents in detail.\n");
	fprintf(stderr,"\n");

}

/************************************************************************************************/
// This function displays TAZEL usage information.
/************************************************************************************************/
extern void disp_usage(){

	fprintf(stderr,"\n");
	fprintf(stderr,"Usage: tazel [-Option] TLE_FileName YYYY-MM-DD hh:mm:ss [LoopTick]\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"< Options, Default -p0 >\n");
	fprintf(stderr,"  -p[0-9] - Insert 0-9 empty line(s) between output data in Parallel Mode\n");
	fprintf(stderr,"  -s[0-9] - Insert 0-9 empty line(s) between output data in Serial   Mode\n");
	fprintf(stderr,"  -gXXX   - Change ground location to XXX\n");
	fprintf(stderr,"  -list   - List available ground locations & Exit\n");
	fprintf(stderr,"  -h | -? - Display help message & Exit\n");
	fprintf(stderr,"  -v      - Display version info & Exit\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"< Command Line Parameters, Default LoopTick=1 >\n");
	fprintf(stderr,"  TLE_FileName : Use \"-\" for <STDIN>\n");
	fprintf(stderr,"  YYYY-MM-DD   : Use \"0\" for 1970-01-01, \"e\" for TLE-Epoch, or  \".\" for *Today*\n");
	fprintf(stderr,"  hh:mm:ss     : Use \"0\" for 00:00:00  , \"e\" for TLE-Epoch, or  \".\" for *Now*  \n");
	fprintf(stderr,"  LoopTick     : Example = 100y, 12M, 365d, 240h, 1440m, 3600s, ... etc.\n");
	fprintf(stderr,"               : Example = 365*1d, 240*3h, 1440*15m, 3600*15s,  ... etc.\n");
	fprintf(stderr,"\n");

}
