/* fparam.c */

#include	"tazel.h"

/************************************************************************************************/
// This function sets command line options & parameters.
/************************************************************************************************/
extern void set_optparam(char *argv[] /* => */ ,int *tledump,int *exemode,int *gapline,char **p_gname,char **p_fname,char **p_date,char **p_time,char **p_looptick){

int		idx;							/* Index Value for ARGV[]								*/

/* Check Option ( Loop for all ARGV[] ) */
	*p_gname=NULL;						// Default = No Data ( Ground Location )
	for( idx=1 ; argv[idx]!=NULL ; idx++ ){

	/* >File Name ( -> End Of Option ) */
		if( strcasecmp(argv[idx],"-")==0 || argv[idx][0]!='-' )
			break;

	/* >Check Option (1/3) */
		if( strcasecmp(argv[idx],"-h")==0 || strcasecmp(argv[idx],"-?")==0 ){
			disp_usage();   exit(0);		// Display help message & Exit
		}
		if( strcasecmp(argv[idx],"-v")==0                                  ){
			disp_version(); exit(0);		// Display version info & Exit
		}

	/* >Check Option (2/3) */
		if( strcasecmp(argv[idx],"-list")==0 ){
			list_obsdata(); exit(0);	// List Available Ground Location & Exit
		}

	/* >Check Option (3/3) */
		if( strcasecmp(argv[idx],"-dump")==0 )
			*tledump=TRUE;				// Display TLE-DataDump on Output
		else if( argv[idx][1]=='g' || argv[idx][1]=='G' )
			*p_gname=&argv[idx][2];		// Ground Location	"-g###"
		else if( argv[idx][1]=='p' || argv[idx][1]=='P' ){
			*exemode='P';				// Parallel Mode	"-p###" ; "-p"=="-p0"
			*gapline=atoi(&argv[idx][2]);
		}
		else if( argv[idx][1]=='s' || argv[idx][1]=='S' ){
			*exemode='S';				// Serial   Modea	"-s###" ; "-s"=="-s0"
			*gapline=atoi(&argv[idx][2]);
		}
		else{
			fprintf(stderr,"Error: Illegal Option [%s]\n",argv[idx]);
			exit(1);
		}

	}

/* Set TLE_FileName */
	if( argv[idx]==NULL ){ disp_usage(); exit(1); }
	*p_fname   =argv[idx++];

/* Set YYYY-MM-DD */
	if( argv[idx]==NULL ){ disp_usage(); exit(1); }
	*p_date    =argv[idx++];

/* Set hh:mm:ss */
	if( argv[idx]==NULL ){ disp_usage(); exit(1); }
	*p_time    =argv[idx++];

/* Set [LoopTick] */
	*p_looptick=argv[idx++];		/* Or NULL	*/

}

/************************************************************************************************/
// This function sets looptick parameters.
/************************************************************************************************/
extern void set_looptick(char *p_looptick /* => */ ,int *loop,int *mult,int *tick){

char	*ptr;							/* Pointer to Char ( STRTOL(3) )						*/

// Basic  Format: LOOP        TICK
// Extend Format: LOOP * MULT TICK

/* No Parameter ( Default = 1s ) */
	if(p_looptick==NULL){
		*loop=1; *mult=1; *tick='s';
		return;
	}

/* Set Parameter ( LOOP ) */
	*loop=strtol(p_looptick,&ptr,10);
	if( *loop<0 || strchr("YyMmDdHhMmSs*",*ptr)==NULL ){
		fprintf(stderr,"Error: Illegal LoopTick [%s]\n",p_looptick);
		exit(1);
	}

/* Set Parameter ( MULT & TICK ) */
	if( *ptr=='*' ){					// Extend Format: e.g. 144*10m ( 1 Day )
		*mult=strtol(ptr+1,&ptr,10);
		if( *mult==0 )					//                e.g. 144*m => 144*1m
			*mult=1;
		if( strchr("YyMmDdHhMmSs",*ptr)==NULL ){
			fprintf(stderr,"Error: Illegal LoopTick [%s]\n",p_looptick);
			exit(1);
		}
		*tick=*ptr;
	}
	else{								// Basic  Format: e.g. 1440m   ( 1 Day )
		*mult=1;
		*tick=*ptr;
	}
	return;

}

/************************************************************************************************/
// This function sets date & time.
/************************************************************************************************/
extern void set_datetime(char *p_date,char *p_time /* => */ ,struct tm *tm_init,dbl *msec){

time_t	t_abs;							/* Unix Time ( Epoch = 1970-01-01 00:00:00 [sec] )		*/
//time_t	t_off;						/* LTZ_Time - UTC_Time [sec]							*/

char	buf_datetime[BUFSIZ];			/* Date&Time String Buffer								*/
char	*ptr;							/* ARG: sss(.sss)										*/

/* Set LTZ_Time - UTC_Time [sec] */
	t_abs=time(NULL);							/*** Today & Now [UTC]	***/
//	t_off=t_abs-mktime(gmtime(&t_abs));			/*** 09*60*60 in [JST]	***/

/* Set Initial Date & Time [UTC] */
	if(strcmp(p_date,"0")==0)					/*** "0" = 1970-01-01	***/
		strcpy(buf_datetime,"1970-01-01");
	else if(strcmp(p_date,".")==0)				/*** "." = Today [UTC]	***/
#ifdef MinGW
		strftime(buf_datetime+00,BUFSIZ-00,  "%Y-%m-%d",gmtime(&t_abs));
#else
		strftime(buf_datetime+00,BUFSIZ-00,"%04Y-%m-%d",gmtime(&t_abs));
#endif
	else if(strcmp(p_date,"e")==0)				/*** "e" = TLE-Epoch	***/	// Set Later!! //
		strcpy(buf_datetime,"1970-01-01");
	else										/*** YYYY-MM-DD			***/
		strcpy(buf_datetime,p_date);

	strcat(buf_datetime," ");

	if(strcmp(p_time,"0")==0)					/*** "0" = 00:00:00		***/
		strcat(buf_datetime,"00:00:00");
	else if(strcmp(p_time,".")==0)				/*** "." = Now   [UTC]	***/
		strftime(buf_datetime+11,BUFSIZ-11,"%H:%M:%S",gmtime(&t_abs));
	else if(strcmp(p_time,"e")==0)				/*** "e" = TLE-Epoch	***/	// Set Later!! //
		strcat(buf_datetime,"00:00:00");
	else										/*** hh:mm:ss(.sss)		***/
		strcat(buf_datetime,p_time);

/* Convert & Set struct TM ( with Normalization ) */
#ifdef MinGW
	sscanf(buf_datetime,"%d-%d-%d %d:%d:%d",\
	&(tm_init->tm_year),&(tm_init->tm_mon),&(tm_init->tm_mday),\
	&(tm_init->tm_hour),&(tm_init->tm_min),&(tm_init->tm_sec ));
	tm_init->tm_year-= 1900;			/* Since 1900			*/
	tm_init->tm_mon -= 1;				/* Range 0-11			*/
	tm_init->tm_isdst=-1;				/* Not Available (<0)	*/
	mktime(tm_init);					/* Normalize it			*/
#else
	if(strptime(buf_datetime,"%Y-%m-%d %H:%M:%S",tm_init)==NULL){
		fprintf(stderr,"Error: Illegal Date&Time\n");
		exit(1);
	}
	mktime(tm_init);					/* Normalize it			*/
#endif

/* Set MSEC */
	ptr=strchr(buf_datetime,'.');
	if(ptr==NULL)
		*msec=0.000;
	else
		*msec=atof(ptr);

}
