/*
    charlist
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_CHARLIST_H__
#define __MISC_CHARLIST_H__


#include "common.h"
#include "misc_charset.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_CHARLIST            (misc_charlist_get_type ())
#define MISC_CHARLIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_CHARLIST, MiscCharlist))
#define MISC_CHARLIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_CHARLIST, MiscCharlistClass))
#define MISC_IS_CHARLIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_CHARLIST))
#define MISC_IS_CHARLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_CHARLIST))
#define MISC_CHARLIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_CHARLIST, MiscCharlistClass))


typedef struct _MiscCharlist      MiscCharlist;
typedef struct _MiscCharlistClass MiscCharlistClass;

struct _MiscCharlist
{
  /*< private >*/
  GtkWindow parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *new_button;    /* ja:新規 */
  GtkWidget *remove_button; /* ja:削除 */
  GtkWidget *up_button;     /* ja:上へ */
  GtkWidget *down_button;   /* ja:下へ */
  GtkWidget *charset;       /* ja:文字符号化方式 */
  GtkWidget *tview;         /* ja:リスト */
  GtkListStore *store;      /* ja:リスト */
  GtkTreeSelection *select; /* ja:リスト */
};

struct _MiscCharlistClass
{
  GtkWindowClass parent_class;

  /* -- signals -- */
  void (*close) (MiscCharlist *charlist);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_charlist_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:文字符号化方式リスト関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
misc_charlist_new (void);


/*  ja:文字符号化方式のリストを取得する
    charlist,ウィジェット
         RET,文字符号化方式のリスト                                         */
gchar *
misc_charlist_get_charlist (MiscCharlist *charlist);


/*  ja:文字符号化方式のリストを設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
misc_charlist_set_charlist (MiscCharlist *charlist,
                            const gchar  *list);


/*  ja:文字符号化方式を取得する
    charlist,ウィジェット
         RET,文字符号化方式                                                 */
#define misc_charlist_get_charset(charlist)                                 \
((charlist)?misc_charset_get_charset(MISC_CHARLIST(charlist)->charset):NULL)


/*  ja:文字符号化方式を設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
misc_charlist_set_charset (MiscCharlist *charlist,
                           const gchar  *charset);


/*  ja:文字符号化方式の候補を取得する
    charlist,ウィジェット
         RET,文字符号化方式の候補                                           */
#define misc_charlist_get_candidate(charlist)                               \
((charlist)?misc_charset_get_candidate                                      \
                        (MISC_CHARSET(MISC_CHARLIST(charlist)->charset)):NULL)


/*  ja:文字符号化方式の候補を追加する
     charlist,ウィジェット
    candidate,文字符号化方式の候補
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
misc_charlist_add_candidate (MiscCharlist *charlist,
                             const gchar  *candidate);


/*  ja:文字符号化方式の候補を削除する
     charlist,ウィジェット
    candidate,文字符号化方式の候補,NULL:すべて削除
          RET,TRUE:正常終了,FALSE:エラー                                    */
#define misc_charlist_remove_candidate (charlist,candidate)                 \
((charlist)?misc_charset_remove_candidate                                   \
            (MISC_CHARSET(MISC_CHARLIST(charlist)->charset),candidate):FALSE)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_CHARLIST_H__ */
