/*
    Argument
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ARGUMENT_H__
#define __ARGUMENT_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ARGUMENT_TYPE_BOOL 0
#define ARGUMENT_TYPE_VALUE 1
#define ARGUMENT_TYPE_ARRAY 2
#define ARGUMENT_TYPE_STRING 3
#define ARGUMENT_TYPE_EXIT 4
#define ARGUMENT_TYPE_HELP 5


typedef struct _ArgumentBool
{
  gboolean flag;
  gboolean def;
} ArgumentBool;
typedef struct _ArgumentValue
{
  gint val;
  gint def;
} ArgumentValue;
typedef struct _ArgumentArray
{
  gsize leng;
  gint *array;
  gint *def;
} ArgumentArray;
typedef struct _ArgumentString
{
  gchar *str;
  gchar *def;
} ArgumentString;
typedef struct _ArgumentExit
{
  gchar *str;
} ArgumentExit, ArgumentHelp;
typedef struct _ArgumentList
{
  const gchar *name;
  const gchar key;
  const gchar *opt;
  const gchar *doc;
  const guint type;
  gpointer data;
} ArgumentList;


/******************************************************************************
*                                                                             *
* ja:引数解析関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:引数を解析する
        argv,引数
    arg_opts,オプション
         RET,ファイル配列                                                   */
gboolean *
arg_analyse (gchar              **argv,
             const ArgumentList  *arg_opts);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ARGUMENT_H__ */
