/*
    license
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "license.h"
#include "misc.h"


/******************************************************************************
*                                                                             *
* ja:ライセンス関数群                                                         *
*                                                                             *
******************************************************************************/
typedef struct _LicenseDlg
{
  gboolean *display;
  gint count;
  GtkWidget *textview, *radio0, *radio1;
} LicenseDlg;


/* ja:表示領域をチェック */
static gboolean
license_dialog_timeout (LicenseDlg *ld)
{
  gint i, st, ed;
  GtkTextIter iter;
  GdkRectangle visible_rect;

#ifdef USE_THREAD
  gdk_threads_enter ();
#endif /* USE_THREAD */
  gtk_text_view_get_visible_rect (GTK_TEXT_VIEW (ld->textview), &visible_rect);
  gtk_text_view_get_iter_at_location (GTK_TEXT_VIEW (ld->textview), &iter,
                                            visible_rect.x, visible_rect.y);
  st = gtk_text_iter_get_line (&iter);
  gtk_text_view_get_iter_at_location (GTK_TEXT_VIEW (ld->textview), &iter,
    visible_rect.x + visible_rect.width, visible_rect.y + visible_rect.height);
  ed = gtk_text_iter_get_line (&iter);
  for (i = st; i <= ed; i++)
    ld->display[i] = TRUE;
  for (i = ld->count - 1; i >= 0; i--)
    if (!ld->display[i])
      break;
  if (i < 0)
    {
      gtk_widget_show (ld->radio0);
      gtk_widget_show (ld->radio1);
#ifdef USE_THREAD
      gdk_threads_leave ();
#endif /* USE_THREAD */
      return FALSE;
    }
#ifdef USE_THREAD
  gdk_threads_leave ();
#endif /* USE_THREAD */
  return TRUE;
}


/*  ja:ライセンス表示
    text:ライセンス
     RET,ハッシュ値(ライセンス同意),-1:ライセンス拒否                       */
gint
license_dialog (const gchar *text)
{
  gboolean result;
  guint timer_id;
  GtkRequisition req0, req1;
  GtkTextBuffer *buffer;
  GtkWidget *dialog, *vbox, *scroll, *fixed;
  LicenseDlg ld;

  if (!text)
    return -1;
  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("License"),
                            NULL,
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            NULL);
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_CANCEL);
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                                            0, gdk_screen_height () * 2 / 3);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:テキスト */
  ld.textview = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (ld.textview));
  gtk_text_buffer_set_text (buffer, text, -1);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (ld.textview), FALSE);
  ld.count = gtk_text_buffer_get_line_count (buffer);
  ld.display = g_malloc0 (ld.count * sizeof (gboolean));
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), ld.textview);
  /* ja:ラジオボタン */
  ld.radio0 = gtk_radio_button_new_with_label (NULL, _("I agree."));
  ld.radio1 = gtk_radio_button_new_with_label_from_widget
                                (GTK_RADIO_BUTTON (ld.radio0), _("I deny."));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ld.radio1), TRUE);
  /* ja:フィクスト */
  gtk_widget_size_request (ld.radio0, &req0);
  gtk_widget_size_request (ld.radio1, &req1);
  fixed = gtk_fixed_new ();
  gtk_widget_set_size_request (fixed, req0.width + req1.width + SPACING,
                                      MAX (req0.height, req1.height));
  gtk_fixed_put (GTK_FIXED (fixed), ld.radio0, 0, 0);
  gtk_fixed_put (GTK_FIXED (fixed), ld.radio1, req0.width + SPACING, 0);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), fixed, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show (scroll);
  gtk_widget_show (ld.textview);
  gtk_widget_show (fixed);
  gtk_widget_show (vbox);

  timer_id = g_timeout_add (100, (GSourceFunc)license_dialog_timeout, &ld);
#ifdef USE_THREAD
  gdk_threads_enter ();
#endif /* USE_THREAD */
  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK;
#ifdef USE_THREAD
  gdk_threads_leave ();
#endif /* USE_THREAD */
  g_source_remove (timer_id);
  g_free (ld.display);
  if (result)
    result = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ld.radio0));
  gtk_widget_destroy (dialog);

  return result ? ABS ((gint)g_str_hash (text)) : -1;
}
