/*
    orzcomm
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ORZ_COMM_H__
#define __ORZ_COMM_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_COMM            (orz_comm_get_type ())
#define ORZ_COMM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_COMM, OrzComm))
#define ORZ_COMM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_COMM, OrzCommClass))
#define ORZ_IS_COMM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_COMM))
#define ORZ_IS_COMM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_COMM))
#define ORZ_COMM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_COMM, OrzCommClass))


typedef struct _OrzComm      OrzComm;
typedef struct _OrzCommClass OrzCommClass;


struct _OrzComm
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gulong     handler_destroy;
  GtkWidget *window;
#ifdef G_OS_WIN32
  DWORD      ddeInst;
  HSZ        hszService;
  HSZ        hszTopic;
  HCONV      hConv;
#else /* not G_OS_WIN32 */
  gssize     instance;
  gboolean   first;
  gchar     *arg;
  gulong     handler_get;
  gulong     handler_received;
  GdkAtom    atom0;
  GdkAtom    atom1;
  GdkAtom    atom2;
#endif /* not G_OS_WIN32 */
};
struct _OrzCommClass
{
  GObjectClass parent_class;

  /* -- signals -- */
  void (*recv) (OrzComm     *comm,
                const gchar *argv[]);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_comm_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:プロセス間通信関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    window,ウィジェット
    unique,ユニークな文字列
       RET,オブジェクト                                                     */
GObject*
orz_comm_new (GtkWidget   *window,
              const gchar *unique);


/*  ja:プロセスが最初のインスタンスか確認する
    comm,オブジェクト
     RET,TRUE:最初のプロセス,FALSE:2つ目以降のプロセス                      */
#ifdef G_OS_WIN32
# define orz_comm_is_first(comm) ((comm)?!((comm)->hConv):TRUE)
#else /* not G_OS_WIN32 */
# define orz_comm_is_first(comm) ((comm)?(comm)->first:TRUE)
#endif /* not G_OS_WIN32 */


/*  ja:引数を最初のプロセスに送信する
    comm,オブジェクト
    argc,引数の数
    argv,引数                                                               */
#define orz_comm_send(comm,argc,argv)                                       \
                                orz_comm_send_with_files(comm,argc,argv,NULL)


/*  ja:引数を最初のプロセスに送信する(ファイルの変換あり)
    comm,オブジェクト
    argc,引数の数
    argv,引数                                                               */
void
orz_comm_send_with_files (OrzComm         *comm,
                          const gint       argc,
                          gchar          **argv,
                          const gboolean  *files);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_COMM_H__ */
