/*
    Text maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "reload.h"
#include "orz/orzcharset.h"


/******************************************************************************
*                                                                             *
* ja:リロードダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:OKボタンの表示/非表示を判定 */
static void
reload_dialog_ok_sensitive (GtkWidget *widget,
                            GtkWidget *dialog)
{
  GtkWidget *charset;

  charset = g_object_get_data (G_OBJECT (dialog), "user_data");
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_ACCEPT,
                                orz_charset_is_valid (ORZ_CHARSET (charset)));
}


/* ja:コンボボックスでリターンが押された */
static void
reload_dialog_activate (GtkWidget *widget,
                        GtkWidget *dialog)
{
  GtkWidget *charset;

  charset = g_object_get_data (G_OBJECT (dialog), "user_data");
  if (orz_charset_is_valid (ORZ_CHARSET (charset)))
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_ACCEPT);
}


/*  ja:リロードダイアログ表示
      ft,ファイルタイプ
    text,説明文
     RET,TRUE:OK,FALSE:Cancel                                               */
gboolean
reload_dialog (FileType    *ft,
               const gchar *text)
{
  gboolean result;
  gchar *title;
  gint i;
#if ! GTK_CHECK_VERSION(2,4,0)
  GList *glist;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  GtkStockItem stock_item;
  GtkWidget *dialog, *check0, *check1, *combo, *charset, *vbox;

  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_REVERT_TO_SAVED, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ボタン */
  if (text)
    gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                            GTK_STOCK_NO, GTK_RESPONSE_REJECT,
                            GTK_STOCK_YES, GTK_RESPONSE_ACCEPT,
                            NULL);
  else
    gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                            GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
                            GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                            NULL);
  /* ja:チェックボタン */
  check0 = gtk_check_button_new_with_mnemonic
                                    (_("_HTML Numeric character reference"));
  check1 = gtk_check_button_new_with_mnemonic (_("_Escape sequence"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check0), ft->html);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check1), ft->esc);
  g_signal_connect (G_OBJECT (check0), "toggled",
                            G_CALLBACK (reload_dialog_ok_sensitive), dialog);
  g_signal_connect (G_OBJECT (check1), "toggled",
                            G_CALLBACK (reload_dialog_ok_sensitive), dialog);
  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
  combo = gtk_combo_box_new_text ();
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "CR+LF");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "CR");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "LF");
  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), ft->crlf);
  g_signal_connect (G_OBJECT (combo), "changed",
                            G_CALLBACK (reload_dialog_ok_sensitive), dialog);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  glist = g_list_append (NULL, "CR+LF");
  glist = g_list_append (glist, "CR");
  glist = g_list_append (glist, "LF");
  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry),
                                            g_list_nth_data (glist, ft->crlf));
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo)->entry), FALSE);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "activate",
                                G_CALLBACK (reload_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                            G_CALLBACK (reload_dialog_ok_sensitive), dialog);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  /* ja:文字符号化方式 */
  charset = orz_charset_new ();
  for (i = 0; i < ftnum; i++)
    orz_charset_add_candidate (ORZ_CHARSET (charset), ftype[i].charset);
  orz_charset_set_charset (ORZ_CHARSET (charset), ft->charset);
  g_signal_connect (G_OBJECT (charset), "activate",
                                G_CALLBACK (reload_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (charset), "edited",
                            G_CALLBACK (reload_dialog_ok_sensitive), dialog);
  g_object_set_data (G_OBJECT (dialog), "user_data", charset);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  if (text)
    gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (text), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), combo, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), charset, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check1, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show_all (vbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT;
  if (result)
    {
#if ! GTK_CHECK_VERSION(2,4,0)
      const gchar *str;
      GList *glist;
#endif /* not GTK_CHECK_VERSION(2,4,0) */

      g_free (ft->charset);
      ft->html = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check0));
      ft->esc = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check1));
#if GTK_CHECK_VERSION(2,4,0)
      ft->crlf = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      str = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
      glist = gtk_container_children (GTK_CONTAINER (GTK_COMBO (combo)->list));
      for (ft->crlf = g_list_length (glist) - 1; ft->crlf >= 0; ft->crlf--)
        if (g_strcmp (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                    (GTK_BIN (g_list_nth_data (glist, ft->crlf))))), str) == 0)
          break;
      g_list_free (glist);
      if (ft->crlf < 0)
        ft->crlf = 0;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      ft->charset = orz_charset_get_charset (ORZ_CHARSET (charset));
    }
  gtk_widget_destroy (dialog);

  return result;
}
