/*
    Text maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include "common.h"
#include "misc/misc.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define TMAID_VERSION_NOTICE "Text maid "VERSION" ("BUILD_ENVIRONMENT")"
#define TMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2006 Kazuki IWAMOTO"

#define MENUFILE 12


typedef struct _FileType
{
  gint ft_id;               /* ja:ファイルタイプのID(-1:無所属) */
  gint crlf;                /* ja:0:CR+LF,1:CR,2:LF,3:自動 */
  gint margin;              /* ja:右マージンの数 */
  gint tab;                 /* ja:タブの数 */
  gint writemode;           /* ja:0:Abort,1:'?',2:HTML,3:Escape */
  gboolean autoindent;      /* ja:TRUE:自動字下げ */
  gboolean associate;       /* ja:TRUE:関連づける */
  gboolean code;            /* ja:TRUE:タブのコードを表示する */
  gboolean eof;             /* ja:TRUE:1Ahをファイルの末尾に書き加える */
  gboolean hexcase;         /* ja:TRUE:大文字,FALSE:小文字 */
  gboolean html;            /* ja:TRUE:HTML数値文字参照を変換する */
  gboolean esc;             /* ja:TRUE:エスケープシーケンスを変換する */
  gboolean limit;           /* ja:TRUE:右マージンで折り返す */
  gboolean overwrite;       /* ja:TRUE:ファイルを上書きするときに確認する */
  gboolean space;           /* ja:TRUE:スペースを灰色の四角で表示 */
  gboolean syscol;          /* ja:TRUE:システム色を使う */
  gboolean tabconv;         /* ja:TRUE:タブをスペースに変換する */
  gboolean gline;           /* ja:TRUE:グリッド線表示 */
  gboolean mline;           /* ja:TRUE:右マージンを表示 */
  gboolean nline;           /* ja:TRUE:改行コードを表示する */
  gboolean uline;           /* ja:TRUE:タブ下線表示 */
  gboolean vline;           /* ja:TRUE:タブ縦線表示 */
  gchar *charset;           /* ja:キャラクターセット */
  gchar *font_name;         /* ja:フォント名 */
  gchar *text, *ext;        /* ja:名前,拡張子 */
  GdkColor color[12];       /* ja:色 */
} FileType;
typedef struct _TmaidHistory
{
  gboolean caret;
  gchar *text;
  gint length;              /* ja:文字数 */
  GdkPoint cursor, select;
  struct _TmaidHistory *next;
} TmaidHistory;
typedef struct _LineBuffer
{
  gboolean margin;          /* ja:TRUE:右マージン,FALSE:通常の改行 */
  gchar *text;
  gint length;              /* ja:文字数 */
  struct _LineBuffer *prev, *next;
} LineBuffer;
typedef struct _TmaidWindow
{
  gint font_width;          /* ja:フォントの横幅 */
  gint font_height;         /* ja:フォントの高さ */
  gint max;                 /* ja:行数 */
  gint off;                 /* ja:startが参照する行 */
  gint same;                /* ja:-1:重複なし,0?:番号 */
  guint timer_id;           /* ja:スクロール用タイマ */
  guint8 font_buf[65536];   /* ja:文字幅のバッファ */
  FileType ft;              /* ja:ファイルタイプ */
  LineBuffer *start;        /* ja:線形リスト */
  PangoLayout *layout;      /* ja:レイアウト */
  TmaidHistory *undo, *redo;/* ja:編集履歴 */
  GdkPoint top;             /* ja:ウインドウの先頭 */
  GdkPoint cursor;          /* ja:キャレットの位置 */
  GdkPoint select;          /* ja:選択開始位置,-1:選択なし */
  GtkWidget *drawing;       /* ja:描画領域 */
  GtkWidget *hscroll;       /* ja:水平スクロールバー */
  GtkWidget *vscroll;       /* ja:垂直スクロールバー */
  GtkIMContext *im_context; /* ja:Input Method */
#ifndef G_OS_WIN32
  GtkWidget *preedit;       /* ja:描画領域(未確定文字列) */
#endif /* not G_OS_WIN32 */
} TmaidWindow;


enum
{
  TARGET_STRING,
  TARGET_TEXT,
  TARGET_COMPOUND_TEXT,
  TARGET_UTF8
};


extern gboolean caret;                  /* ja:キャレットの形 */
extern gboolean ins;                    /* ja:TRUE:挿入,FALSE:上書き */
extern gboolean newfile;                /* ja:TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* ja:TRUE:新規,FALSE:既存 */
extern gchar *open_path;                /* ja:開くのパス */
extern gchar *save_path;                /* ja:名前を付けて保存のパス */
extern gchar *clipboard_text;           /* ja:クリップボードのテキスト */
extern gint def_width, def_height;      /* ja:デフォルトのウインドウのサイズ */
extern gint ftnum;                      /* ja:ファイルタイプの数 */
#if GTK_CHECK_VERSION(2,4,0) || defined (G_OS_WIN32)
extern gint findex;                     /* ja:ファイルタイプのフィルタ */
#endif /* GTK_CHECK_VERSION(2,4,0) || defined (G_OS_WIN32) */
extern gint tcount;                     /* ja:ファイルタイプのカウンタ */
extern guint timer_id;                  /* ja:タイマID */
extern FileType *ftype;                 /* ja:ファイルタイプ */
extern GObject *history;                /* ja:ファイルの履歴 */
extern GdkAtom atom_targets;            /* ja:ターゲット */
extern GdkAtom atom_text;               /* ja:テキスト */
extern GdkAtom atom_compound;           /* ja:コンパウンド */
extern GdkAtom atom_utf8;               /* ja:UTF-8 */
extern GtkWidget *window;               /* ja:ウインドウ */
extern GtkWidget *mdi;                  /* en:MDI */
extern GtkWidget *status;               /* ja:ステータスウインドウ */
extern GtkWidget *label_cursor;         /* ja:カーソル座標 */
extern GtkPositionType n_pos;           /* ja:ノートブックの位置 */
extern PangoFontDescription *system_font;
extern GdkColor system_color[12];
extern GtkTargetEntry targets[4];   /* ja:Text maidが提供可能なセレクション */
extern MiscCreateMenuEntry menu_entries[];
extern MiscCreateMenuEntry popup_entries[];
extern MiscCreateToolbarEntry toolbar_entries[];


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __TMAID_H__ */
/*
ja:表示色
 0,文字
 1,背景
 2,コントロールコード
 3,全角スペース
 4,改行コード
 5,タブ下線
 6,右マージン
 7,グリッド
 8,選択された文字
 9,選択された背景
10,文字(印刷)
11,コントロールコード(印刷)
*/
