/*
    profile
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __PROFILE_H__
#define __PROFILE_H__


#include "gcommon.h"


G_BEGIN_DECLS


#define PROFILE_VALUE_TYPE_BOOL   0
#define PROFILE_VALUE_TYPE_INT    1
#define PROFILE_VALUE_TYPE_STRING 2
#define PROFILE_VALUE_TYPE_ARRAY  3


typedef struct _Profile Profile;


/******************************************************************************
*                                                                             *
* ja:t@C֐Q(Ǝ)                                               *
*                                                                             *
******************************************************************************/
/*  ja:t@CJ
    file,t@C
     RET,vt@C                                                       */
Profile *
profile_open (const gchar *file);


/*  ja:t@C
    profile,vt@C
        RET,TRUE:I,FALSE:G[                                      */
gboolean
profile_close (Profile *profile);


/*  ja:t@Cl̃TCY擾
    profile,vt@C
    section,ZNV
        key,L[
       type,^Cv
        RET,oCg,0:G[                                               */
gsize
profile_get_size (Profile     *profile,
                  const gchar *section,
                  const gchar *key,
                  const guint  type);


/*  ja:t@C當擾
    profile,vt@C
    section,ZNV
        key,L[
        RET,,NULL:G[                                              */
gchar *
profile_get_string (Profile     *profile,
                    const gchar *section,
                    const gchar *key);


/*  ja:t@Cl擾
    profile,vt@C
    section,ZNV
        key,L[
      value,lobt@
       size,lobt@̃TCY
       type,^Cv
        RET,TRUE:I,FALSE:G[                                      */
gboolean
profile_get_value (Profile     *profile,
                   const gchar *section,
                   const gchar *key,
                   gpointer     value,
                   const gsize  size,
                   const guint  type);


/*  ja:t@Cɒlݒ肷
    profile,vt@C
    section,ZNV
        key,L[
      value,lĂobt@
       size,lĂobt@̃TCY
       type,^Cv
        RET,TRUE:I,FALSE:G[                                      */
gboolean
profile_set_value (Profile       *profile,
                   const gchar   *section,
                   const gchar   *key,
                   gconstpointer  value,
                   const gsize    size,
                   const guint    type);


/*  ja:t@C̃ZNV폜
    profile,vt@C
    section,ZNV
        RET,TRUE:I,FALSE:G[                                      */
gboolean
profile_delete_section (Profile     *profile,
                        const gchar *section);


/*  ja:t@C̃L[폜
    profile,vt@C
    section,ZNV
        key,L[
        RET,TRUE:I,FALSE:G[                                      */
gboolean
profile_delete_key (Profile     *profile,
                    const gchar *section,
                    const gchar *key);


/*  ja:t@C̃ZNV񋓂
    profile,vt@C
        RET,ZNṼXg,NULL:G[                                  */
GList *
profile_enum_section (Profile *profile);


/*  ja:t@C̃L[񋓂
    profile,vt@C
    section,ZNV
        RET,ZNṼXg,NULL:G[                                  */
GList *
profile_enum_key (Profile     *profile,
                  const gchar *section);


/******************************************************************************
*                                                                             *
* ja:t@C֐Q(݊)                                               *
*                                                                             *
******************************************************************************/
#ifndef USE_KEYFILE_EMULATE
# if GLIB_CHECK_VERSION(2,12,8)
#  define USE_KEYFILE_EMULATE 0
# elif GLIB_CHECK_VERSION(2,12,5)
#  define USE_KEYFILE_EMULATE 1
# elif GLIB_CHECK_VERSION(2,6,0)
#  define USE_KEYFILE_EMULATE 0
# else /* not GLIB_CHECK_VERSION(2,6,0) */
#  define USE_KEYFILE_EMULATE 1
# endif /* not GLIB_CHECK_VERSION(2,6,0) */
#endif /* not USE_KEYFILE_EMULATE */
#if USE_KEYFILE_EMULATE
# define GKeyFile Profile
# define GKeyFileError guint
# define GKeyFileFlags guint
# define G_KEY_FILE_NONE              0
# define G_KEY_FILE_KEEP_COMMENTS     1
# define G_KEY_FILE_KEEP_TRANSLATIONS 2
# define g_key_file_new              profile_keyfile_new
# define g_key_file_free             profile_keyfile_free
# define g_key_file_load_from_file   profile_keyfile_load_from_file
# define g_key_file_load_from_data   profile_keyfile_load_from_data
# define g_key_file_to_data          profile_keyfile_to_data
# define g_key_file_get_groups       profile_keyfile_get_groups
# define g_key_file_get_keys         profile_keyfile_get_keys
# define g_key_file_has_group        profile_keyfile_has_group
# define g_key_file_has_key          profile_keyfile_has_key
# define g_key_file_get_value        profile_keyfile_get_value
# define g_key_file_get_string       profile_keyfile_get_string
# define g_key_file_get_boolean      profile_keyfile_get_boolean
# define g_key_file_get_integer      profile_keyfile_get_integer
# define g_key_file_get_integer_list profile_keyfile_get_integer_list
# define g_key_file_set_value        profile_keyfile_set_value
# define g_key_file_set_string       profile_keyfile_set_string
# define g_key_file_set_boolean      profile_keyfile_set_boolean
# define g_key_file_set_integer      profile_keyfile_set_integer
# define g_key_file_set_integer_list profile_keyfile_set_integer_list
# define g_key_file_remove_group     profile_keyfile_remove_group
# define g_key_file_remove_key       profile_keyfile_remove_key
#endif /* USE_KEYFILE_EMULATE */


Profile *
profile_keyfile_new (void);


void
profile_keyfile_free (Profile *profile);


gboolean
profile_keyfile_load_from_file (Profile      *profile,
                                const gchar  *file,
                                guint         flags,
                                GError      **error);


gboolean
profile_keyfile_load_from_data (Profile      *profile,
                                const gchar  *data,
                                gsize         length,
                                guint         flags,
                                GError      **error);


gchar *
profile_keyfile_to_data (Profile  *profile,
                         gsize    *length,
                         GError  **error);


gchar **
profile_keyfile_get_groups (Profile *profile,
                            gsize   *length);


gchar **
profile_keyfile_get_keys (Profile      *profile,
                          const gchar  *section,
                          gsize        *length,
                          GError      **error);


gboolean
profile_keyfile_has_group (Profile     *profile,
                           const gchar *section);


gboolean
profile_keyfile_has_key (Profile      *profile,
                         const gchar  *section,
                         const gchar  *key,
                         GError      **error);


gchar *
profile_keyfile_get_value (Profile      *profile,
                           const gchar  *section,
                           const gchar  *key,
                           GError      **error);


gchar *
profile_keyfile_get_string (Profile      *profile,
                            const gchar  *section,
                            const gchar  *key,
                            GError      **error);


gboolean
profile_keyfile_get_boolean (Profile      *profile,
                             const gchar  *section,
                             const gchar  *key,
                             GError      **error);


gint
profile_keyfile_get_integer (Profile      *profile,
                             const gchar  *section,
                             const gchar  *key,
                             GError      **error);


gint *
profile_keyfile_get_integer_list (Profile      *profile,
                                  const gchar  *section,
                                  const gchar  *key,
                                  gsize        *length,
                                  GError      **error);


void
profile_keyfile_set_value (Profile     *profile,
                           const gchar *section,
                           const gchar *key,
                           const gchar *string);


void
profile_keyfile_set_string (Profile     *profile,
                            const gchar *section,
                            const gchar *key,
                            const gchar *string);


void
profile_keyfile_set_boolean (Profile     *profile,
                             const gchar *section,
                             const gchar *key,
                             gboolean     value);


void
profile_keyfile_set_integer (Profile     *profile,
                             const gchar *section,
                             const gchar *key,
                             gint         value);


void
profile_keyfile_set_integer_list (Profile     *profile,
                                  const gchar *section,
                                  const gchar *key,
                                  gint         list[],
                                  gsize        length);


void
profile_keyfile_remove_group (Profile      *profile,
                              const gchar  *section,
                              GError      **error);


void
profile_keyfile_remove_key (Profile      *profile,
                            const gchar  *section,
                            const gchar  *key,
                            GError      **error);


G_END_DECLS


#endif /* __PROFILE_H__ */
