/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "find.h"
#include "panel.h"
#include "repinfo.h"
#include "replace.h"
#include "misc/misc.h"
#include "orz/orzmdi.h"
#include <gdk/gdkkeysyms.h>


GtkWidget *find_box = NULL;
GtkWidget *find_entry;
GtkWidget *replace_combo;
GtkWidget *replace_entry;


/******************************************************************************
*                                                                             *
* ja:検索/置換ボックス関数群                                                  *
*                                                                             *
******************************************************************************/
static GtkWidget *find_button;
static GtkWidget *find_check;
static GtkWidget *find_combo;
static GtkWidget *find_radio0, *find_radio1;
static GtkWidget *replace_button0, *replace_button1;
static GtkWidget *replace_label;


/* ja:入力内容を取得する */
static void
find_box_get_contents (void)
{
  const gchar *text;
  gint i;
#if ! GTK_CHECK_VERSION(2,4,0)
  GList *glist = NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */

  find_ignorecase = gtk_toggle_button_get_active
                                            (GTK_TOGGLE_BUTTON (find_check));
  find_arrow = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (find_radio1));
  text = gtk_entry_get_text (GTK_ENTRY (find_entry));
  for (i = 0; i < FIND_TEXT - 1 && find_text[i]; i++)
    if (g_strcmp (find_text[i], text) == 0)
      break;
#if GTK_CHECK_VERSION(2,4,0)
  if (find_text[i])
    gtk_combo_box_remove_text (GTK_COMBO_BOX (find_combo), i);
  gtk_combo_box_prepend_text (GTK_COMBO_BOX (find_combo), text);
#endif /* GTK_CHECK_VERSION(2,4,0) */
  g_free (find_text[i]);
  g_memmove (find_text + 1, find_text, i * sizeof (gchar *));
  find_text[0] = g_strdup (text);
#if ! GTK_CHECK_VERSION(2,4,0)
  for (i = 0; i < FIND_TEXT && find_text[i]; i++)
    glist = g_list_append (glist, find_text[i]);
  if (glist)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (find_combo), glist);
      g_list_free (glist);
    }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  if (GTK_WIDGET_VISIBLE (replace_combo))
    {
      text = gtk_entry_get_text (GTK_ENTRY (replace_entry));
      for (i = 0; i < REPLACE_TEXT - 1 && replace_text[i]; i++)
        if (g_strcmp (replace_text[i], text) == 0)
          break;
#if GTK_CHECK_VERSION(2,4,0)
      if (replace_text[i])
        gtk_combo_box_remove_text (GTK_COMBO_BOX (replace_combo), i);
      gtk_combo_box_prepend_text (GTK_COMBO_BOX (replace_combo), text);
#endif /* GTK_CHECK_VERSION(2,4,0) */
      g_free (replace_text[i]);
      g_memmove (replace_text + 1, replace_text, i * sizeof (gchar *));
      replace_text[0] = g_strdup (text);
#if ! GTK_CHECK_VERSION(2,4,0)
      for (i = 0; i < REPLACE_TEXT && replace_text[i]; i++)
        glist = g_list_append (glist, replace_text[i]);
      if (glist)
        {
          gtk_combo_set_popdown_strings (GTK_COMBO (replace_combo), glist);
          g_list_free (glist);
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
    }
}


/* ja:検索ボタンが押された */
static void
find_box_clicked (GtkWidget *widget,
                  gpointer   user_data)
{
  find_box_get_contents ();
  command_next (widget, GINT_TO_POINTER (TRUE));
}


/* ja:置換ボタンが押された */
static void
replace_box_clicked_0 (GtkWidget *widget,
                       gpointer   user_data)
{
  find_box_get_contents ();
  replace_operation (REPLACE_OK);
}


/* ja:すべて置換ボタンが押された */
static void
replace_box_clicked_1 (GtkWidget *widget,
                       gpointer   user_data)
{
  find_box_get_contents ();
  replace_operation (REPLACE_ALL);
}


/* ja:エントリーでリターンが押された */
static void
find_box_activate (GtkWidget *widget,
                   gpointer   user_data)
{
  if (g_strlen (gtk_entry_get_text (GTK_ENTRY (widget))) > 0)
    gtk_button_clicked (GTK_WIDGET_VISIBLE (find_button)
                    ? GTK_BUTTON (find_button) : GTK_BUTTON (replace_button0));
}


/* ja:エントリーが変更された */
static void
find_box_changed (GtkWidget *widget,
                  gpointer   user_data)
{
  gboolean sensitive;

  sensitive = g_strlen (gtk_entry_get_text (GTK_ENTRY (widget))) > 0;
  gtk_widget_set_sensitive (find_button, sensitive);
  gtk_widget_set_sensitive (replace_button0, sensitive);
  gtk_widget_set_sensitive (replace_button1, sensitive);
}


/* ja:ESCが押されたとき */
static gboolean
find_key_press (GtkWidget   *widget,
                GdkEventKey *event,
                gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    find_box_end ();
  return FALSE;
}


/*  ja:検索/置換ボックス取得
    RET,検索/置換ボックス                                                   */
GtkWidget *
find_box_get_widget (void)
{
  if (!find_box)
    {
      gint i;
#if ! GTK_CHECK_VERSION(2,4,0)
      GList *glist = NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      GtkWidget *button, *frame, *hbox, *vbox;

      find_box = gtk_hbox_new (FALSE, SPACING);
      g_signal_connect (G_OBJECT (find_box), "key-press-event",
                                            G_CALLBACK (find_key_press), NULL);
      /* ja:ボタン */
      find_button = gtk_button_new_from_stock (GTK_STOCK_FIND);
      g_signal_connect (G_OBJECT (find_button), "clicked",
                                    G_CALLBACK (find_box_clicked), NULL);
      gtk_widget_set_sensitive (find_button, find_text[0] != NULL);
      replace_button0 = gtk_button_new_from_stock (GTK_STOCK_FIND_AND_REPLACE);
      g_signal_connect (G_OBJECT (replace_button0), "clicked",
                                    G_CALLBACK (replace_box_clicked_0), NULL);
      gtk_widget_set_sensitive (replace_button0, find_text[0] != NULL);
      replace_button1 = gtk_button_new_with_mnemonic (_("_All Replace"));
      g_signal_connect (G_OBJECT (replace_button1), "clicked",
                                    G_CALLBACK (replace_box_clicked_1), NULL);
      gtk_widget_set_sensitive (replace_button1, find_text[0] != NULL);
      button = misc_close_button ();
      g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (find_box_end), NULL);
      /* ja:チェックボタン */
      find_check = gtk_check_button_new_with_mnemonic (_("Enable _Case"));
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (find_check),
                                                            find_ignorecase);
      /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
      find_combo = gtk_combo_box_entry_new_text ();
      for (i = 0; i < FIND_TEXT && find_text[i]; i++)
        gtk_combo_box_append_text (GTK_COMBO_BOX (find_combo), find_text[i]);
      if (find_text[0])
        gtk_combo_box_set_active (GTK_COMBO_BOX (find_combo), 0);
      find_entry = gtk_bin_get_child (GTK_BIN (find_combo));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; i < FIND_TEXT && find_text[i]; i++)
        glist = g_list_append (glist, find_text[i]);
      find_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (find_combo), FALSE, TRUE);
      gtk_combo_set_case_sensitive (GTK_COMBO (find_combo), TRUE);
      find_entry = GTK_COMBO (find_combo)->entry;
      if (glist)
        {
          gtk_combo_set_popdown_strings (GTK_COMBO (find_combo), glist);
          gtk_entry_set_text (GTK_ENTRY (find_entry), glist->data);
          g_list_free (glist);
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      g_signal_connect (G_OBJECT (find_entry), "activate",
                                        G_CALLBACK (find_box_activate), NULL);
      g_signal_connect (G_OBJECT (find_entry), "changed",
                                        G_CALLBACK (find_box_changed), NULL);
#if GTK_CHECK_VERSION(2,4,0)
      replace_combo = gtk_combo_box_entry_new_text ();
      for (i = 0; i < REPLACE_TEXT && replace_text[i]; i++)
        gtk_combo_box_append_text (GTK_COMBO_BOX (replace_combo),
                                                            replace_text[i]);
      if (replace_text[0])
        gtk_combo_box_set_active (GTK_COMBO_BOX (replace_combo), 0);
      replace_entry = gtk_bin_get_child (GTK_BIN (replace_combo));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; i < REPLACE_TEXT && replace_text[i]; i++)
        glist = g_list_append (glist, replace_text[i]);
      replace_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (replace_combo), FALSE, TRUE);
      gtk_combo_set_case_sensitive (GTK_COMBO (replace_combo), TRUE);
      replace_entry = GTK_COMBO (replace_combo)->entry;
      if (glist)
        {
          gtk_combo_set_popdown_strings (GTK_COMBO (replace_combo), glist);
          gtk_entry_set_text (GTK_ENTRY (replace_entry), glist->data);
          g_list_free (glist);
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      g_signal_connect (G_OBJECT (replace_entry), "activate",
                                        G_CALLBACK (find_box_activate), NULL);
      /* ja:ラベル */
      replace_label = gtk_label_new (_("Replace String"));
      /* ja:ラジオボタン */
      find_radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Up"));
      find_radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                (GTK_RADIO_BUTTON (find_radio0), _("_Down"));
      gtk_toggle_button_set_active
            (GTK_TOGGLE_BUTTON (find_arrow ? find_radio1 : find_radio0), TRUE);
      /* ja:フレームとボックス */
      vbox = gtk_vbox_new (FALSE, SPACING);
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox),
                            gtk_label_new (_("Find String")), FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), find_combo, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), replace_label, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), replace_combo, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (find_box), vbox, TRUE, TRUE, 0);

      frame = gtk_frame_new (_("Option"));
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
      gtk_box_pack_start (GTK_BOX (vbox), find_check, FALSE, FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_box_pack_start (GTK_BOX (find_box), frame, FALSE, FALSE, 0);

      frame = gtk_frame_new (_("Direction"));
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
      gtk_box_pack_start (GTK_BOX (vbox), find_radio0, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), find_radio1, FALSE, FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_box_pack_start (GTK_BOX (find_box), frame, FALSE, FALSE, 0);

      vbox = gtk_vbox_new (FALSE, SPACING);
      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), find_button, FALSE, FALSE, 0);
#ifdef G_OS_WIN32
      gtk_box_pack_start (GTK_BOX (hbox), replace_button0, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), replace_button1, FALSE, FALSE, 0);
#else /* not G_OS_WIN32 */
      gtk_box_pack_start (GTK_BOX (hbox), replace_button1, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), replace_button0, FALSE, FALSE, 0);
#endif /* not G_OS_WIN32 */
      gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (find_box), vbox, FALSE, FALSE, 0);
    }
  return find_box;
}


/*  ja:検索ボックス開始                                                     */
void
find_box_start (void)
{
  gtk_widget_show (find_box);
  gtk_widget_show (find_button);
  gtk_widget_hide (replace_button0);
  gtk_widget_hide (replace_button1);
  gtk_widget_hide (replace_combo);
  gtk_widget_hide (replace_label);
  gtk_widget_grab_focus (find_entry);
  gtk_editable_select_region (GTK_EDITABLE (find_entry), 0, -1);
}


/*  ja:置換ボックス開始                                                     */
void
replace_box_start (void)
{
  gtk_widget_show (find_box);
  gtk_widget_hide (find_button);
  gtk_widget_show (replace_button0);
  gtk_widget_show (replace_button1);
  gtk_widget_show (replace_combo);
  gtk_widget_show (replace_label);
  gtk_editable_select_region (GTK_EDITABLE (replace_entry), 0, -1);
  if (GTK_WIDGET_HAS_FOCUS (find_entry))
    {
      gtk_widget_grab_focus (replace_entry);
    }
  else
    {
      gtk_editable_select_region (GTK_EDITABLE (find_entry), 0, -1);
      gtk_widget_grab_focus (find_entry);
    }
}


/*  ja:検索/置換ボックス終了                                                */
void
find_box_end (void)
{
  TmaidWindow *tmaid;

  gtk_widget_hide (find_box);
  tmaid = orz_mdi_get_data (ORZ_MDI (mdi), -1);
  if (tmaid)
    gtk_widget_grab_focus (tmaid->drawing);
}
