/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "charset.h"
#include "valchr.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:コード文字入力ダイアログ関数群                                           *
*                                                                             *
******************************************************************************/
static gunichar valchr_default = ' ';
static guint valchr_base = 16;


/* ja:エントリーが変更された */
static void
valchr_dialog_changed (GtkWidget *widget,
                       GtkWidget *dialog)
{
  gint value;

  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
            misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (widget)),
                                                        valchr_base, FALSE));
}


/* ja:エントリーでリターンが押された */
static void
valchr_dialog_activate (GtkWidget *widget,
                        GtkWidget *dialog)
{
  gint value;

  if (misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (widget)),
                                                        valchr_base, FALSE))
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
}


/* ja:ラジオボタンが押された */
static void
valchr_dialog_clicked (GtkWidget *widget,
                       GtkWidget *entry)
{
  gchar *text;
  gint value;

  misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (entry)),
                                                        valchr_base, FALSE);
  valchr_base = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (widget),
                                                                "user_data"));
  text = misc_str_from_val (value, valchr_base, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
}


/*  ja:コード文字入力ダイアログ表示
    valchr,入力文字
       RET,TRUE:OK,FALSE:Cancel                                             */
gboolean
valchr_dialog (gunichar *valchr)
{
  gboolean result;
  gchar *text;
  GtkWidget *dialog, *entry, *radio0, *radio1, *radio2, *frame, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Character by Value"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:エントリー */
  entry = gtk_entry_new ();
  text = misc_str_from_val (valchr_default, valchr_base, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
  g_signal_connect (G_OBJECT (entry), "activate",
                                G_CALLBACK (valchr_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (entry), "changed",
                                G_CALLBACK (valchr_dialog_changed), dialog);
  /* ja:ラジオボタン */
  radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Hexadecimal"));
  radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Decimal"));
  radio2 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio1), _("_Octal"));
  switch (valchr_base)
    {
      case 16: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio0), TRUE);
               break;
      case 10: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
               break;
      case  8: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);
    }
  g_signal_connect (G_OBJECT (radio0), "clicked",
                                    G_CALLBACK (valchr_dialog_clicked), entry);
  g_signal_connect (G_OBJECT (radio1), "clicked",
                                    G_CALLBACK (valchr_dialog_clicked), entry);
  g_signal_connect (G_OBJECT (radio2), "clicked",
                                    G_CALLBACK (valchr_dialog_clicked), entry);
  g_object_set_data (G_OBJECT (radio0), "user_data", GUINT_TO_POINTER (16));
  g_object_set_data (G_OBJECT (radio1), "user_data", GUINT_TO_POINTER (10));
  g_object_set_data (G_OBJECT (radio2), "user_data", GUINT_TO_POINTER (8));
  /* ja:フレームとボックス */
  frame = gtk_frame_new (_("Base"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), radio0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio2, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (entry);
  gtk_widget_show_all (vbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK;
  if (result)
    {
      gint value;

      misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (entry)),
                                                        valchr_base, FALSE);
      valchr_default = value;
      if (valchr)
        *valchr = valchr_default;
    }
  gtk_widget_destroy (dialog);

  return result;
}
