/*
    memapi
    copyright (c) 1998-2012 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MEMAPI_H__
#define __MEMAPI_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:֐Q                                                             *
*                                                                             *
******************************************************************************/
/*  ja:̓eRs[
    lpvDest,Rs[
     lpvSrc,Rs[
     uBytes,oCg                                                        */
VOID WINAPI
MemoryCopy (LPVOID  lpvDest,
            LPCVOID lpvSrc,
            UINT    uBytes);


/*  ja:̓eݒ肷
    lpvDest,ݒ
     nValue,l
     uBytes,oCg                                                        */
VOID WINAPI
MemorySet (LPVOID lpvDest,
           BYTE   nValue,
           UINT   uBytes);


/*  ja:̓er
    lpvBuf0,obt@0
    lpvBuf1,obt@1
     uBytes,oCg
        RET,:lpvBuf0,:lpvBuf1,0:                    */
INT WINAPI
MemoryCompare (LPCVOID lpvBuf0,
               LPCVOID lpvBuf1,
               UINT    uBytes);


/*  ja:mۂ
    uBytes,TCY
       RET,mۂ,NULL:G[                                       */
LPVOID WINAPI
MemoryAlloc (UINT uBytes);


/*  ja:
    lpMemory,mۂ
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
MemoryFree (LPVOID lpMemory);


/*  ja:̃TCYύX
    lpMemory,mۂ
      uBytes,TCY
         RET,mۂ,NULL:G[                                     */
LPVOID WINAPI
MemoryReAlloc (LPVOID lpMemory, UINT uBytes);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MEMAPI_H__ */
