/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __EDIT_H__
#define __EDIT_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:ҏW֐Q                                                               *
*                                                                             *
******************************************************************************/
/*  ja:Cobt@߂
    lpStart,Cobt@
     lpnOff,݂yW
          y,yW
        RET,Cobt@                                                  */
LPLINEBUF
GetLineBuffer (LINEBUF **lpStart,
               int      *lpnOff,
               int       y);


/*  ja:擾
    lpStart,Cobt@
     lpnOff,݂yW
          y,s
       nTab,^u
        RET,                                                            */
int
GetWidth (LINEBUF **lpStart,
          int      *lpnOff,
          int       y,
          int       nTab);


/*  ja:ő包擾
    ptw,TXTEChE
    RET,                                                                */
int
GetWidthMax (LPTEXTWND ptw);


/*  ja:Lbg̃ACgꂽxW߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
     fAlign,TRUE:EɊ񂹂,FALSE:Ɋ񂹂
        RET,W                                                            */
int
GetAlignPos (LINEBUF **lpStart,
             int      *lpnOff,
             int       x,
             int       y,
             int       nTab,
             BOOL      fAlign);


/*  ja:ʏ̍W烉Cobt@̃AhX߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
     fAlign,TRUE:EɊ񂹂,FALSE:Ɋ񂹂
        RET,AhX                                                        */
int
GetDataPos (LINEBUF **lpStart,
            int      *lpnOff,
            int       x,
            int       y,
            int       nTab,
            BOOL      fAlign);


/*  ja:Cobt@̃AhXʏ̍W߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
        RET,W                                                            */
int
GetScreenPos (LINEBUF **lpStart,
              int      *lpnOff,
              int       x,
              int       y,
              int       nTab);


/*  ja:̕
    lpszText,
     nLength,
         RET,                                                           */
DWORD
GetCharType (LPCSTR lpszText,
             int    nLength);


/*  ja:؂߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
      fMove,TRUE:EɈړ,FALSE:Ɉړ
        RET,W                                                            */
int
GetMovePos (LINEBUF **lpStart,
            int      *lpnOff,
            int       x,
            int       y,
            int       nTab,
            int       fMove);


/*  ja:w͈͂̃oCg߂
      lpStart,Cobt@
       lpnOff,݂yW
    lpptStart,I͈
      lpptEnd,I͈
         nTab,^u
          RET,oCg                                                      */
int
GetSelByte (LINEBUF **lpStart,
            int      *lpnOff,
            LPPOINT   lpptStart,
            LPPOINT   lpptEnd,
            int       nTab);


/*  ja:w͈͂ɃRs[
     lpStart,Cobt@
      lpnOff,݂yW
    pptStart,I͈
     lpptEnd,I͈
        nTab,^u
    lpszText,                                                         */
void
CpySelMem (LINEBUF **lpStart,
           int      *lpnOff,
           LPPOINT   lpptStart,
           LPPOINT   lpptEnd,
           int       nTab,
           LPSTR     lpszText);


/*  ja:f[^擾
     lpStart,Cobt@
      lpnOff,݂yW
     lpptGet,擾͂߂f[^W
    lpszText,
     nLength,oCg
         RET,擾łoCg                                             */
int
GetMem (LINEBUF **lpStart,
        int      *lpnOff,
        LPPOINT   lpptGet,
        LPSTR     lpszText,
        int       nLength);


/*  ja:̓e\t
     lpStart,Cobt@
      lpnOff,݂yW
     lpptPut,\tW
     lpptNew,VW
        nTab,^u
    lpszText,
     nLength,oCg
     nMargin,E}[W(0Ȃΐ܂ԂȂ)
         RET,}ꂽs                                                 */
int
PutMem (LINEBUF **lpStart,
        int      *lpnOff,
        LPPOINT   lpptPut,
        LPPOINT   lpptNew,
        int       nTab,
        LPSTR     lpszText,
        int       nLength,
        int       nMargin);


/*  ja:w͈͂폜
      lpStart,Cobt@
       lpnOff,݂yW
    lpptStart,I͈
      lpptEnd,I͈
         nTab,^u
     nMargin,E}[W(0Ȃΐ܂ԂȂ)
          RET,폜ꂽs                                                */
int
DelSelMem (LINEBUF **lpStart,
           int      *lpnOff,
           LPPOINT   lpptStart,
           LPPOINT   lpptEnd,
           int       nTab,
           int       nMargin);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __EDIT_H__ */
