/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "format.h"
#include "prop.h"


/******************************************************************************
*                                                                             *
* ե륿״ؿ                                                        *
*                                                                             *
******************************************************************************/
static gint ftpos;
static GtkWidget *button0,*button1,*button2,*button3,*button4;


static void format_dialog_select(GtkWidget *widget,gint pos)
{
	ftpos=pos;
	gtk_widget_set_sensitive(button0,TRUE);
	gtk_widget_set_sensitive(button1,ftnum>1);
	gtk_widget_set_sensitive(button2,ftpos<ftnum-1);
	gtk_widget_set_sensitive(button3,TRUE);
}


static void format_dialog_deselect(GtkWidget *widget,gint pos)
{
	ftpos=-1;
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_widget_set_sensitive(button2,FALSE);
	gtk_widget_set_sensitive(button3,FALSE);
}


static void format_dialog_clicked_new(GtkWidget *widget,GtkWidget *list)
{
	GtkWidget *item;

	ftype=g_realloc(ftype,++ftnum*sizeof(FTYPE));
	ftype[ftnum-1]=ftype[ftpos];
	ftype[ftnum-1].text=g_strdup(ftype[ftpos].text);
	ftype[ftnum-1].ext=g_strdup(ftype[ftpos].ext);
	ftype[ftnum-1].fontname=g_strdup(ftype[ftpos].fontname);

	item=gtk_list_item_new_with_label(ftype[ftnum-1].text);
	gtk_container_add(GTK_CONTAINER(list),item);
	gtk_signal_connect(GTK_OBJECT(item),"select",
									format_dialog_select,(gpointer)ftnum-1);
	gtk_signal_connect(GTK_OBJECT(item),"deselect",
									format_dialog_deselect,(gpointer)ftnum-1);
	gtk_widget_show(item);
}


static void format_dialog_clicked_remove(GtkWidget *widget,GtkWidget *list)
{
	gint i;
	GtkWidget *item;

	g_free(ftype[ftpos].text);
	g_free(ftype[ftpos].ext);
	g_free(ftype[ftpos].fontname);
	ftnum--;
	memcpy(ftype+ftpos,ftype+ftpos+1,(ftnum-ftpos)*sizeof(FTYPE));
	ftype=g_realloc(ftype,ftnum*sizeof(FTYPE));
	gtk_list_clear_items(GTK_LIST(list),0,-1);
	for (i=0;i<ftnum;i++) {
		item=gtk_list_item_new_with_label(ftype[i].text);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
										format_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
										format_dialog_deselect,(gpointer)i);
		gtk_widget_show(item);
	}
}


static void format_dialog_clicked_move(GtkWidget *widget,GtkWidget *list)
{
	gint i;
	FTYPE ft;
	GtkWidget *item;

	ft=ftype[ftpos];
	memcpy(ftype+ftpos,ftype+ftpos+1,(ftnum-ftpos)*sizeof(FTYPE));
	ftype[ftnum-1]=ft;
	gtk_list_clear_items(GTK_LIST(list),0,-1);
	for (i=0;i<ftnum;i++) {
		item=gtk_list_item_new_with_label(ftype[i].text);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
										format_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
										format_dialog_deselect,(gpointer)i);
		gtk_widget_show(item);
	}
}


static void format_dialog_clicked_edit(GtkWidget *widget,GtkWidget *list)
{
	gint i;
	GtkWidget *item;

	property_dialog(ftype+ftpos);
	gtk_list_clear_items(GTK_LIST(list),0,-1);
	for (i=0;i<ftnum;i++) {
		item=gtk_list_item_new_with_label(ftype[i].text);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
										format_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
										format_dialog_deselect,(gpointer)i);
		gtk_widget_show(item);
	}
}


/* ESC줿 */
static gboolean format_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void format_dialog(void)
{
	gint i;
	GtkWidget *dialog,*label,*list,*item,*scroll,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("ե륿"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(format_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ٥ */
	label=gtk_label_new(_("ϿƤե륿"));
	gtk_misc_set_alignment(GTK_MISC(label),0,.5);/*  */
	/* ꥹȥܥå */
	list=gtk_list_new();
	for (i=0;i<ftnum;i++) {
		item=gtk_list_item_new_with_label(ftype[i].text);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
										format_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
										format_dialog_deselect,(gpointer)i);
	}
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),list);
	/* ܥ */
	button0=gtk_button_new_with_label(_(""));
	button1=gtk_button_new_with_label(_(""));
	button2=gtk_button_new_with_label(_("ư"));
	button3=gtk_button_new_with_label(_("Խ"));
	button4=gtk_button_new_with_label(_("Ĥ"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
											format_dialog_clicked_new,list);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
											format_dialog_clicked_remove,list);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
											format_dialog_clicked_move,list);
	gtk_signal_connect(GTK_OBJECT(button3),"clicked",
											format_dialog_clicked_edit,list);
	gtk_signal_connect_object(GTK_OBJECT(button4),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button4,GTK_CAN_DEFAULT);
	/* ܥå */
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button2,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button3,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button4,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_widget_set_sensitive(button2,FALSE);
	gtk_widget_set_sensitive(button3,FALSE);
	gtk_widget_grab_focus(button4);
	ftpos=-1;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
