/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __PROFILE_H__
#define __PROFILE_H__


#include <gtk/gtk.h>


#define PROFILE_DATA_TYPE_UNKNOW 0
#define PROFILE_DATA_TYPE_SPACE 1
#define PROFILE_DATA_TYPE_COMMENT 2
#define PROFILE_DATA_TYPE_SECTION 3
#define PROFILE_DATA_TYPE_KEY 4
#define PROFILE_VALUE_TYPE_BOOL 0
#define PROFILE_VALUE_TYPE_INT 1
#define PROFILE_VALUE_TYPE_STRING 2
#define PROFILE_VALUE_TYPE_ARRAY 3


typedef struct profilelist {
	gchar *data,*section,*key,*value;
	guint type;
	struct profilelist *prev,*next;
} PROFILELIST;
typedef struct profile {
	gboolean edit;
	gchar *file;
	PROFILELIST *list;
} PROFILE;


/*	t@CJ
	file,t@C
	 RET,vt@C														*/
PROFILE *profile_open(gchar *file);


/*	t@C
	profile,vt@C
	    RET,TRUE:I,FALSE:G[										*/
gboolean profile_close(PROFILE *profile);


/*	t@C當擾
	profile,vt@C
	section,ZNV
	    key,L[
	    RET,,NULL:G[												*/
gchar *profile_get_string(PROFILE *profile,gchar *section,gchar *key);


/*	t@Cl擾
	profile,vt@C
	section,ZNV
	    key,L[
	  value,lobt@
	   size,lobt@̃TCY
	   type,^Cv
	    RET,TRUE:I,FALSE:G[										*/
gboolean profile_get_value(PROFILE *profile,gchar *section,gchar *key,
										gpointer *value,gint size,guint type);


/*	t@Cɒlݒ肷
	profile,vt@C
	section,ZNV
	    key,L[
	  value,lĂobt@
	   size,lĂobt@̃TCY
	   type,^Cv
	    RET,TRUE:I,FALSE:G[										*/
gboolean profile_set_value(PROFILE *profile,gchar *section,gchar *key,
										gpointer *value,gint size,guint type);


/*	t@C̃ZNV폜
	profile,vt@C
	section,ZNV
	    RET,TRUE:I,FALSE:G[										*/
gboolean profile_delete_section(PROFILE *profile,gchar *section);


#endif
