/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARSET_H__
#define __CHARSET_H__


#include "tmaid.h"


#define charset_length(ch) (charset->length[(gint)(guchar)(ch)])
#define charset_width(font,text,size) 										\
				(charset->length[(gint)*(guchar *)(text)]<=1?1				\
				:MAX((gdk_text_width((font),(text),							\
				charset->length[(gint)*(guchar *)(text)])+(size)-1)/(size),1))


typedef struct {
	gchar *name;
	gint length[256];
	guchar *space;
} CHARSET;


extern CHARSET *charset,charsetlist[];


void charset_set(gchar *lang);
void charset_init(void);
void charset_size(GdkFont *font,gint *width,gint *height,gint *ascent);


#endif
