/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include "charset.h"


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
static guchar space_eucjp[]=	{2,0xA1,0xA1,0};		/* ܸ */
static guchar space_shiftjis[]=	{2,0x81,0x40,0};
static guchar space_gb2312[]=	{2,0xA1,0xA1,0};		/* λ */
static guchar space_big5[]=		{2,0xA1,0x40,0};		/* λ */
static guchar space_ksc5601[]=	{2,0xA1,0xA1,0};		/* ڹ */
static guchar space_utf8[]=		{3,0xE3,0x80,0x80,0};	/* ISO-10646-1 */
static CharSet charset_list[]={
{
	"ascii,us-ascii,latin-1,iso-646,iso646,iso-8859,iso8859,iso-8859-1",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* A */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* C */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* E */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_ACCENT,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	CS_SYMBOL,		0,				CS_SYMBOL,		CS_ALPHA,
	/* 8 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 8 */	CS_ACCENT,		CS_SYMBOL,		CS_ALPHA,		CS_SYMBOL,
	/* 8 */	CS_ALPHA,		0,				CS_ALPHA,		0,
	/* 9 */	0,				CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 9 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 9 */	CS_SYMBOL,		CS_SYMBOL,		CS_ALPHA,		CS_SYMBOL,
	/* 9 */	CS_ALPHA,		0,				CS_ALPHA,		CS_ALPHA,
	/* A */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_ACCENT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* C */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* C */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* C */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* C */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* D */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* D */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* D */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* D */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* E */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* E */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* E */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* E */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* F */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* F */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* F */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* F */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA},
	NULL
},
{
	"euc-jp,eucjp,ujis",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* A */	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				CS_M_KANA,		CS_M_KANJI,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* A */	0,				CS_M_SYMBOL,	CS_M_SYMBOL,	CS_M_DIGITALPHA,
	/* A */	CS_M_HIRAGANA,	CS_M_KATAKANA,	CS_M_GREEK,		CS_M_CYRILLIC,
	/* A */	CS_M_LINE,		0,				0,				0,
	/* A */	0,				CS_M_MARK,		CS_M_KANJI,		0,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		0,				0,				0,
	/* F */	0,				0,				0,				0,
	/* F */	0,				0,				0,				0},
	space_eucjp
},
{
	"shift_jis,sjis",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* A */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* C */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* E */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				CS_M_SYMBOL,	CS_M_DIGITALPHA,CS_M_KATAKANA,
	/* 8 */	CS_M_CYRILLIC,	0,				0,				CS_M_MARK,
	/* 8 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 8 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* A */	CS_SPACE,		CS_PUNCT,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_PUNCT,		CS_SYMBOL,		CS_KANA,		CS_KANA,
	/* A */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* A */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* B */	CS_KANA_ACCENT,	CS_KANA,		CS_KANA,		CS_KANA,
	/* B */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* B */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* B */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* C */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* C */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* C */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* C */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* D */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* D */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* D */	CS_KANA,		CS_KANA,		CS_KANA,		CS_KANA,
	/* D */	CS_KANA,		CS_KANA,		CS_KANA_ACCENT,	CS_KANA_ACCENT,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		0,
	/* E */	0,				CS_M_KANJI,		CS_M_KANJI,		0,
	/* F */	0,				0,				0,				0,
	/* F */	0,				0,				0,				0,
	/* F */	0,				0,				CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		0,				0,				0},
	space_shiftjis
},
{
	"gb2312,gbk,euccn,euc-cn",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* A */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 8 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 8 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 8 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* 9 */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* A */	CS_M_KANJI,		CS_M_SYMBOL,	CS_M_MARK,		CS_M_DIGITALPHA,
	/* A */	CS_M_HIRAGANA,	CS_M_KATAKANA,	CS_M_GREEK,		CS_M_CYRILLIC,
	/* A */	CS_M_MARK,		CS_M_LINE,		CS_M_KANJI,		CS_M_KANJI,
	/* A */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		0},
	space_gb2312
},
{
	"big5,big-5",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* A */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* A */	0,				CS_M_SYMBOL,	CS_M_DIGITALPHA,CS_M_MARK,
	/* A */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* A */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* A */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* B */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		0,				0,
	/* F */	0,				0,				0,				0},
	space_big5
},
{
	"ks_c_5601-1987,ks_c_5601,ksc_5601,ksc5601,uhc,euckr,euc-kr",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* A */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 8 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 8 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 8 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 9 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 9 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 9 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* 9 */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* A */	CS_M_HANGUL,	CS_M_SYMBOL,	CS_M_MARK,		CS_M_DIGITALPHA,
	/* A */	CS_M_MARK,		CS_M_GREEK,		CS_M_LINE,		CS_M_MARK,
	/* A */	CS_M_MARK,		CS_M_MARK,		CS_M_HIRAGANA,	CS_M_KATAKANA,
	/* A */	CS_M_CYRILLIC,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* B */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* B */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* B */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* B */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* C */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* C */	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,	CS_M_HANGUL,
	/* C */	CS_M_HANGUL,	0,				CS_M_KANJI,		CS_M_KANJI,
	/* C */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* D */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		0,				0},
	space_ksc5601
},
{
	"uft8,utf-8",
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* A */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{	/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 4 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 5 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_SYMBOL,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 6 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_ALPHA,
	/* 7 */	CS_ALPHA,		CS_ALPHA,		CS_ALPHA,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 8 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* 9 */	0,				0,				0,				0,
	/* A */	0,				0,				0,				0,
	/* A */	0,				0,				0,				0,
	/* A */	0,				0,				0,				0,
	/* A */	0,				0,				0,				0,
	/* B */	0,				0,				0,				0,
	/* B */	0,				0,				0,				0,
	/* B */	0,				0,				0,				0,
	/* B */	0,				0,				0,				0,
	/* C */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* C */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* C */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* C */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* D */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* D */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* D */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* D */	CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,CS_M_DIGITALPHA,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* E */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,		CS_M_KANJI,
	/* F */	0,				0,				0,				0,
	/* F */	0,				0,				0,				0,
	/* F */	0,				0,				0,				0},
	space_utf8
},
{
	NULL,
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 2 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 4 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 6 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 8 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* A */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* C */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* E */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{	/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 2 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 4 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 6 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* 8 */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* A */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* C */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	/* E */	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	NULL
}};
CharSet *charset=charset_list;


void charset_set(const gchar *lang)
{
	gchar **charset_name;
	gint i,j;

	for (i=0;charset_list[i].name!=NULL;i++) {
		charset_name=g_strsplit(charset_list[i].name,",",G_MAXINT);
		for (j=0;charset_name[j]!=NULL;j++)
			if (g_strcasecmp(lang,charset_name[j])==0) {
				charset=charset_list+i;
				break;
			}
		g_strfreev(charset_name);
	}
}


void charset_init(void)
{
	gchar *env,*lang,*list[]={"LANG","LC_ALL","LANGUAGE",NULL};
	gint i;

	/* Ķѿ */
	for (i=0;list[i]!=NULL;i++)
		if ((env=g_getenv(list[i]))!=NULL && (env=strchr(env,'.'))!=NULL) {
			lang=g_strdup(env+1);
			if ((env=strchr(lang,'@'))!=NULL)
				*env='\0';
			charset_set(lang);
			g_free(lang);
			break;
		}
}


void charset_size(GdkFont *font,gint *width,gint *height,gint *ascent)
{
	gint i,w,h,a;

	*width=*height=*ascent=0;
	for (i=0;i<256;i++)
		if (charset_length(i)==1) {
			gdk_text_extents(font,(gchar *)&i,1,NULL,NULL,&w,&a,NULL);
			if (*width<w)
				*width=w;
			if (*ascent<a)
				*ascent=a;
			h=gdk_char_height(font,i);
			if (*height<h)
				*height=h;
		}
}
