/*
copyright (c) 2017-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <windows.h>
#include <tchar.h>
#include <imagehlp.h>
#include <string.h>


#define FILE_ALIGNMENT 512


typedef struct _PESEC
{
  int nData;
  LPVOID pData;
  IMAGE_SECTION_HEADER ish;
} PESEC;


static DWORD
FileAlignment (DWORD dwSize)
{
  return (dwSize + FILE_ALIGNMENT - 1) / FILE_ALIGNMENT * FILE_ALIGNMENT;
}


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int nResult = -1;
  DWORD dwImage, dwSection;
  HANDLE hFile, hHeap;
  LPVOID lpImage = NULL;
  IMAGE_NT_HEADERS32 inth;
  PESEC *pesec = NULL;

  hHeap = GetProcessHeap ();
  hFile = CreateFile (argv[1], GENERIC_READ, FILE_SHARE_READ,
                            NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile != INVALID_HANDLE_VALUE)
    {
      DWORD dwRead;
      IMAGE_DOS_HEADER idh;

      if (ReadFile (hFile, &idh, sizeof (IMAGE_DOS_HEADER), &dwRead, NULL)
        && dwRead == sizeof (IMAGE_DOS_HEADER)
        && idh.e_magic == IMAGE_DOS_SIGNATURE
        && SetFilePointer (hFile, idh.e_lfanew, NULL, FILE_BEGIN)
                                                    != INVALID_SET_FILE_POINTER
        && ReadFile (hFile, &inth, sizeof (IMAGE_NT_HEADERS32), &dwRead, NULL)
        && dwRead == sizeof (IMAGE_NT_HEADERS32)
        && inth.Signature == IMAGE_NT_SIGNATURE
        && inth.FileHeader.Machine == IMAGE_FILE_MACHINE_I386
        && inth.FileHeader.SizeOfOptionalHeader
                                            == sizeof (IMAGE_OPTIONAL_HEADER32)
        && inth.OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR32_MAGIC)
        {
          int i;

          pesec = HeapAlloc (hHeap, HEAP_ZERO_MEMORY,
                            inth.FileHeader.NumberOfSections * sizeof (PESEC));
          for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
            if (!ReadFile (hFile, &pesec[i].ish, sizeof (IMAGE_SECTION_HEADER),
                    &dwRead, NULL) || dwRead != sizeof (IMAGE_SECTION_HEADER))
              break;
          if (i >= inth.FileHeader.NumberOfSections)
            for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
              if (pesec[i].ish.SizeOfRawData > 0)
                {
                  pesec[i].pData = HeapAlloc (hHeap, 0,
                                                pesec[i].ish.SizeOfRawData);
                  if (SetFilePointer (hFile, pesec[i].ish.PointerToRawData,
                                NULL, FILE_BEGIN) == INVALID_SET_FILE_POINTER
                        || !ReadFile (hFile, pesec[i].pData,
                                    pesec[i].ish.SizeOfRawData, &dwRead, NULL)
                                    || dwRead != pesec[i].ish.SizeOfRawData)
                    break;
                }
          if (i < inth.FileHeader.NumberOfSections)
            {
              for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
                if (pesec[i].pData)
                  HeapFree (hHeap, 0, pesec[i].pData);
              HeapFree (hHeap, 0, pesec);
              pesec = NULL;
            }
        }
      CloseHandle (hFile);
    }
  if (pesec)
    {
      int i;
      DWORD dwAddress[2], dwSize[2], dwHeader, dwCheckSum;
      LPBYTE p;
      PIMAGE_NT_HEADERS32 pinth;

      dwAddress[0] = inth.OptionalHeader.DataDirectory
                                [IMAGE_DIRECTORY_ENTRY_DEBUG].VirtualAddress;
      dwSize[0] = inth.OptionalHeader.DataDirectory
                                [IMAGE_DIRECTORY_ENTRY_DEBUG].Size;
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        if (pesec[i].ish.VirtualAddress <= dwAddress[0]
                && dwAddress[0] + dwSize[0]
                <= pesec[i].ish.VirtualAddress + pesec[i].ish.Misc.VirtualSize)
          {
            PIMAGE_DEBUG_DIRECTORY pidd = NULL;

            pidd = (PIMAGE_DEBUG_DIRECTORY)((LPBYTE)pesec[i].pData
                                + dwAddress[0] - pesec[i].ish.VirtualAddress);
            dwAddress[1] = pidd->AddressOfRawData;
            dwSize[1] = pidd->SizeOfData;
            if (dwAddress[0] > dwAddress[1])
              {
                DWORD dwTemp;

                dwTemp = dwAddress[0];
                dwAddress[0] = dwAddress[1];
                dwAddress[1] = dwTemp;
                dwTemp = dwSize[0];
                dwSize[0] = dwSize[1];
                dwSize[1] = dwTemp;
              }
            for (i = 1; i >= 0; i--)
              {
                int j;

                for (j = 0; j < inth.FileHeader.NumberOfSections; j++)
                  if (pesec[j].ish.VirtualAddress <= dwAddress[i]
                    && dwAddress[i] + dwSize[i] == pesec[j].ish.VirtualAddress
                                            + pesec[j].ish.Misc.VirtualSize)
                    {
                      pesec[j].ish.Misc.VirtualSize -= dwSize[i];
                      dwAddress[i] = dwSize[i] = 0;
                    }
              }
            for (i = 0; i < 2; i++)
              {
                int j;

                for (j = 0; j < inth.FileHeader.NumberOfSections; j++)
                  if (pesec[j].ish.VirtualAddress <= dwAddress[i]
                    && dwAddress[i] + dwSize[i] <= pesec[j].ish.VirtualAddress
                                            + pesec[j].ish.Misc.VirtualSize)
                    memset ((LPBYTE)pesec[j].pData + dwAddress[i]
                                - pesec[j].ish.VirtualAddress, 0, dwSize[i]);
              }
          }
      dwImage = dwHeader = FileAlignment (sizeof (IMAGE_DOS_HEADER)
                                            + sizeof (IMAGE_NT_HEADERS32)
                                            + inth.FileHeader.NumberOfSections
                                            * sizeof (IMAGE_SECTION_HEADER));
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          int j;

          if (pesec[i].ish.SizeOfRawData > pesec[i].ish.Misc.VirtualSize)
            pesec[i].ish.SizeOfRawData = pesec[i].ish.Misc.VirtualSize;
          for (pesec[i].nData = pesec[i].ish.SizeOfRawData - 1;
                                        pesec[i].nData >= 0; pesec[i].nData--)
            if (((LPBYTE)pesec[i].pData)[pesec[i].nData] != 0)
              break;
          pesec[i].nData++;
          pesec[i].ish.SizeOfRawData = FileAlignment (pesec[i].nData);
          pesec[i].ish.PointerToRawData = pesec[i].nData > 0 ? dwImage : 0;
          dwImage += pesec[i].ish.SizeOfRawData;
        }
      inth.OptionalHeader.FileAlignment = FILE_ALIGNMENT;
      inth.OptionalHeader.SizeOfHeaders = dwHeader;
      inth.OptionalHeader.CheckSum = 0;
      inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG]
                                                        .VirtualAddress = 0;
      inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG]
                                                        .Size = 0;
      p = lpImage = HeapAlloc (hHeap, HEAP_ZERO_MEMORY, dwImage);
      ((PIMAGE_DOS_HEADER)p)->e_magic = IMAGE_DOS_SIGNATURE;
      ((PIMAGE_DOS_HEADER)p)->e_lfanew = sizeof (IMAGE_DOS_HEADER);
      p += sizeof (IMAGE_DOS_HEADER);
      memmove (p, &inth, sizeof (IMAGE_NT_HEADERS32));
      p += sizeof (IMAGE_NT_HEADERS32);
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          memmove (p, &pesec[i].ish, sizeof (IMAGE_SECTION_HEADER));
          p += sizeof (IMAGE_SECTION_HEADER);
        }
      p = (LPBYTE)lpImage + dwHeader;
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          memmove (p, pesec[i].pData, pesec[i].nData);
          p += pesec[i].ish.SizeOfRawData;
        }
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        if (pesec[i].pData)
          HeapFree (hHeap, 0, pesec[i].pData);
      HeapFree (hHeap, 0, pesec);
      pinth = CheckSumMappedFile (lpImage, dwImage, &dwHeader, &dwCheckSum);
      if (pinth)
        {
          pinth->OptionalHeader.CheckSum = dwCheckSum;
        }
      else
        {
          HeapFree (hHeap, 0, lpImage);
          lpImage = NULL;
        }
    }
  if (lpImage)
    {
      hFile = CreateFile (argv[2] ? argv[2] : argv[1],
                            GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
                            NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
      if (hFile != INVALID_HANDLE_VALUE)
        {
          DWORD dwWrite;

          if (WriteFile (hFile, lpImage, dwImage, &dwWrite, NULL)
                                                        && dwWrite == dwImage)
            nResult = 0;
        }
      CloseHandle (hFile);
      HeapFree (hHeap, 0, lpImage);
    }
  return nResult;
}
