/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "format.h"
#include <commctrl.h>
#include "general.h"
#include "property.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:フォーマット関数群                                                       *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
FormatDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  if (uMsg == uDlMsg)
    {
      switch (((LPDRAGLISTINFO)lParam)->uNotification)
        {
          case DL_DRAGGING:
            return 0;
          case DL_DROPPED:
            {
              int nPos, nItem;

              nPos = GetWindowLongPtr (hDlg, DWLP_USER);
              nItem = LBItemFromPt (((LPDRAGLISTINFO)lParam)->hWnd,
                                    ((LPDRAGLISTINFO)lParam)->ptCursor, TRUE);
              if (nItem > 0 && nPos != nItem)
                {
                  FILETYPE FileType;

                  FileType = lpFileType[nPos];
                  if (nItem < nPos)
                    MemoryCopy (&lpFileType[nItem + 1], &lpFileType[nItem],
                                        (nPos - nItem) * sizeof (FILETYPE));
                  else
                    MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                        (nItem - nPos) * sizeof (FILETYPE));
                  lpFileType[nItem] = FileType;
                  ListBoxItem_DeleteString (hDlg, IDC_LISTBOXE1, nPos);
                  ListBoxItem_InsertString (hDlg, IDC_LISTBOXE1,
                                                    nItem, FileType.lpszText);
                  ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nItem);
                  dwFilter = 0;
                  /* ja:位置設定 */
                  SetWindowLongPtr (hDlg, DWLP_USER, nItem);
                }
            }
        }
      return TRUE;
    }
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i, nPos;
          HWND hWnd;

          /* ja:位置設定 */
          nPos = dwFilter;
          if (nPos >= nFileType)
            nPos = 0;
          SetWindowLongPtr (hDlg, DWLP_USER, nPos);
          /* ja:リストボックスを設定する */
          for (i = 0; i < nFileType; i++)
            ListBoxItem_AddString (hDlg, IDC_LISTBOXE1,
                                                    lpFileType[i].lpszText);
          ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nPos);
          hWnd = GetDlgItem (hDlg, IDC_LISTBOXE1);
          if (hWnd)
            MakeDragList (hWnd);
          /* ja:コントロールの表示状態 */
          EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1);
          EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0);
          EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              break;
            case IDC_PUSHBUTTONE1:/* ja:新規 */
              {
                int nPos;

                nPos = GetWindowLongPtr (hDlg, DWLP_USER);
                lpFileType = MemoryReAlloc (lpFileType,
                                            ++nFileType * sizeof (FILETYPE));
                MemoryCopy (&lpFileType[nPos + 2], &lpFileType[nPos + 1],
                                (nFileType - nPos - 2) * sizeof (FILETYPE));
                lpFileType[nPos + 1] = lpFileType[nPos];
                lpFileType[nPos + 1].nID = nTypeCount++;
                ListBoxItem_InsertString (hDlg, IDC_LISTBOXE1,
                                        nPos + 1, lpFileType[nPos].lpszText);
                /* ja:コントロールの表示状態 */
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, TRUE);
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, TRUE);
              }
              break;
            case IDC_PUSHBUTTONE2:/* ja:削除 */
              {
                int nPos;

                nPos = GetWindowLongPtr (hDlg, DWLP_USER);
                ListBoxItem_DeleteString (hDlg, IDC_LISTBOXE1, nPos);
                MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                (nFileType - nPos - 1) * sizeof (FILETYPE));
                lpFileType = MemoryReAlloc (lpFileType,
                                            --nFileType * sizeof (FILETYPE));
                if (nPos > nFileType - 1)
                  nPos = nFileType - 1;
                ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nPos);
                /* ja:コントロールの表示状態 */
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1);
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0);
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1);
                dwFilter = 0;
                /* ja:位置設定 */
                SetWindowLongPtr (hDlg, DWLP_USER, nPos);
              }
              break;
            case IDC_PUSHBUTTONE3:/* ja:上へ */
              {
                int nPos;
                FILETYPE FileType;

                nPos = GetWindowLongPtr (hDlg, DWLP_USER);
                FileType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos - 1];
                lpFileType[nPos - 1] = FileType;
                ListBoxItem_DeleteString (hDlg, IDC_LISTBOXE1, nPos);
                ListBoxItem_InsertString (hDlg, IDC_LISTBOXE1,
                                                    --nPos, FileType.lpszText);
                ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nPos);
                /* ja:コントロールの表示状態 */
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0);
                dwFilter = 0;
                /* ja:位置設定 */
                SetWindowLongPtr (hDlg, DWLP_USER, nPos);
              }
              break;
            case IDC_PUSHBUTTONE4:/* ja:下へ */
              {
                int nPos;
                FILETYPE FileType;

                nPos = GetWindowLongPtr (hDlg, DWLP_USER);
                FileType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos + 1];
                lpFileType[nPos + 1] = FileType;
                ListBoxItem_DeleteString (hDlg, IDC_LISTBOXE1, nPos);
                ListBoxItem_InsertString (hDlg, IDC_LISTBOXE1,
                                                    ++nPos, FileType.lpszText);
                ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nPos);
                /* ja:コントロールの表示状態 */
                EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1);
                dwFilter = 0;
                /* ja:位置設定 */
                SetWindowLongPtr (hDlg, DWLP_USER, nPos);
              }
              break;
            case IDC_LISTBOXE1:/* ja:編集 */
              if (HIWORD (wParam) == LBN_SELCHANGE)
                {
                  int nPos;

                  /* ja:位置設定 */
                  nPos = ListBoxItem_GetCurSel (hDlg, IDC_LISTBOXE1);
                  SetWindowLongPtr (hDlg, DWLP_USER, nPos);
                  /* ja:コントロールの表示状態 */
                  EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0);
                  EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1);
                  break;
                }
              else if (HIWORD (wParam) != LBN_DBLCLK)
                {
                  return 1;
                }
            case IDC_PUSHBUTTONE5:
              {
                int nPos;

                nPos = ListBoxItem_GetCurSel (hDlg, IDC_LISTBOXE1);
                if (DialogBoxParamGUI (GetModuleHandle (NULL),
                        MAKEINTRESOURCE (DIALOG_D), hDlg,
                        PropertyDlgProc, (LPARAM)&lpFileType[nPos]) == IDOK)
                  {
                    ListBoxItem_InsertString (hDlg, IDC_LISTBOXE1,
                                            nPos, lpFileType[nPos].lpszText);
                    ListBoxItem_DeleteString (hDlg, IDC_LISTBOXE1, nPos + 1);
                    ListBoxItem_SetCurSel (hDlg, IDC_LISTBOXE1, nPos);
                    EnumChildWindows (hWndClient, PropertyEnumProc,
                                                    (LPARAM)&lpFileType[nPos]);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
